/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.HelmChart;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HelmChartFluent<A extends HelmChartFluent<A>>
extends BaseFluent<A> {
    private List<String> additionalValuesFiles = new ArrayList<String>();
    private List<String> apiVersions = new ArrayList<String>();
    private Boolean includeCRDs;
    private String name;
    private String nameTemplate;
    private String namespace;
    private String releaseName;
    private String repo;
    private Boolean skipHooks;
    private Boolean skipTests;
    private String valuesFile;
    private Map<String, Object> valuesInline;
    private String valuesMerge;
    private String version;
    private Map<String, Object> additionalProperties;

    public HelmChartFluent() {
    }

    public HelmChartFluent(HelmChart instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HelmChart instance) {
        HelmChart helmChart = instance = instance != null ? instance : new HelmChart();
        if (instance != null) {
            this.withAdditionalValuesFiles(instance.getAdditionalValuesFiles());
            this.withApiVersions(instance.getApiVersions());
            this.withIncludeCRDs(instance.getIncludeCRDs());
            this.withName(instance.getName());
            this.withNameTemplate(instance.getNameTemplate());
            this.withNamespace(instance.getNamespace());
            this.withReleaseName(instance.getReleaseName());
            this.withRepo(instance.getRepo());
            this.withSkipHooks(instance.getSkipHooks());
            this.withSkipTests(instance.getSkipTests());
            this.withValuesFile(instance.getValuesFile());
            this.withValuesInline(instance.getValuesInline());
            this.withValuesMerge(instance.getValuesMerge());
            this.withVersion(instance.getVersion());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAdditionalValuesFiles(int index, String item) {
        if (this.additionalValuesFiles == null) {
            this.additionalValuesFiles = new ArrayList<String>();
        }
        this.additionalValuesFiles.add(index, item);
        return (A)((Object)this);
    }

    public A setToAdditionalValuesFiles(int index, String item) {
        if (this.additionalValuesFiles == null) {
            this.additionalValuesFiles = new ArrayList<String>();
        }
        this.additionalValuesFiles.set(index, item);
        return (A)((Object)this);
    }

    public A addToAdditionalValuesFiles(String ... items) {
        if (this.additionalValuesFiles == null) {
            this.additionalValuesFiles = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalValuesFiles.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAdditionalValuesFiles(Collection<String> items) {
        if (this.additionalValuesFiles == null) {
            this.additionalValuesFiles = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalValuesFiles.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalValuesFiles(String ... items) {
        if (this.additionalValuesFiles == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.additionalValuesFiles.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAdditionalValuesFiles(Collection<String> items) {
        if (this.additionalValuesFiles == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.additionalValuesFiles.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAdditionalValuesFiles() {
        return this.additionalValuesFiles;
    }

    public String getAdditionalValuesFile(int index) {
        return this.additionalValuesFiles.get(index);
    }

    public String getFirstAdditionalValuesFile() {
        return this.additionalValuesFiles.get(0);
    }

    public String getLastAdditionalValuesFile() {
        return this.additionalValuesFiles.get(this.additionalValuesFiles.size() - 1);
    }

    public String getMatchingAdditionalValuesFile(Predicate<String> predicate) {
        for (String item : this.additionalValuesFiles) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAdditionalValuesFile(Predicate<String> predicate) {
        for (String item : this.additionalValuesFiles) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAdditionalValuesFiles(List<String> additionalValuesFiles) {
        if (additionalValuesFiles != null) {
            this.additionalValuesFiles = new ArrayList<String>();
            for (String item : additionalValuesFiles) {
                this.addToAdditionalValuesFiles(item);
            }
        } else {
            this.additionalValuesFiles = null;
        }
        return (A)((Object)this);
    }

    public A withAdditionalValuesFiles(String ... additionalValuesFiles) {
        if (this.additionalValuesFiles != null) {
            this.additionalValuesFiles.clear();
            this._visitables.remove((Object)"additionalValuesFiles");
        }
        if (additionalValuesFiles != null) {
            for (String item : additionalValuesFiles) {
                this.addToAdditionalValuesFiles(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAdditionalValuesFiles() {
        return this.additionalValuesFiles != null && !this.additionalValuesFiles.isEmpty();
    }

    public A addToApiVersions(int index, String item) {
        if (this.apiVersions == null) {
            this.apiVersions = new ArrayList<String>();
        }
        this.apiVersions.add(index, item);
        return (A)((Object)this);
    }

    public A setToApiVersions(int index, String item) {
        if (this.apiVersions == null) {
            this.apiVersions = new ArrayList<String>();
        }
        this.apiVersions.set(index, item);
        return (A)((Object)this);
    }

    public A addToApiVersions(String ... items) {
        if (this.apiVersions == null) {
            this.apiVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiVersions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToApiVersions(Collection<String> items) {
        if (this.apiVersions == null) {
            this.apiVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiVersions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromApiVersions(String ... items) {
        if (this.apiVersions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.apiVersions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromApiVersions(Collection<String> items) {
        if (this.apiVersions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.apiVersions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getApiVersions() {
        return this.apiVersions;
    }

    public String getApiVersion(int index) {
        return this.apiVersions.get(index);
    }

    public String getFirstApiVersion() {
        return this.apiVersions.get(0);
    }

    public String getLastApiVersion() {
        return this.apiVersions.get(this.apiVersions.size() - 1);
    }

    public String getMatchingApiVersion(Predicate<String> predicate) {
        for (String item : this.apiVersions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingApiVersion(Predicate<String> predicate) {
        for (String item : this.apiVersions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withApiVersions(List<String> apiVersions) {
        if (apiVersions != null) {
            this.apiVersions = new ArrayList<String>();
            for (String item : apiVersions) {
                this.addToApiVersions(item);
            }
        } else {
            this.apiVersions = null;
        }
        return (A)((Object)this);
    }

    public A withApiVersions(String ... apiVersions) {
        if (this.apiVersions != null) {
            this.apiVersions.clear();
            this._visitables.remove((Object)"apiVersions");
        }
        if (apiVersions != null) {
            for (String item : apiVersions) {
                this.addToApiVersions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasApiVersions() {
        return this.apiVersions != null && !this.apiVersions.isEmpty();
    }

    public Boolean getIncludeCRDs() {
        return this.includeCRDs;
    }

    public A withIncludeCRDs(Boolean includeCRDs) {
        this.includeCRDs = includeCRDs;
        return (A)((Object)this);
    }

    public boolean hasIncludeCRDs() {
        return this.includeCRDs != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getNameTemplate() {
        return this.nameTemplate;
    }

    public A withNameTemplate(String nameTemplate) {
        this.nameTemplate = nameTemplate;
        return (A)((Object)this);
    }

    public boolean hasNameTemplate() {
        return this.nameTemplate != null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)((Object)this);
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public A withReleaseName(String releaseName) {
        this.releaseName = releaseName;
        return (A)((Object)this);
    }

    public boolean hasReleaseName() {
        return this.releaseName != null;
    }

    public String getRepo() {
        return this.repo;
    }

    public A withRepo(String repo) {
        this.repo = repo;
        return (A)((Object)this);
    }

    public boolean hasRepo() {
        return this.repo != null;
    }

    public Boolean getSkipHooks() {
        return this.skipHooks;
    }

    public A withSkipHooks(Boolean skipHooks) {
        this.skipHooks = skipHooks;
        return (A)((Object)this);
    }

    public boolean hasSkipHooks() {
        return this.skipHooks != null;
    }

    public Boolean getSkipTests() {
        return this.skipTests;
    }

    public A withSkipTests(Boolean skipTests) {
        this.skipTests = skipTests;
        return (A)((Object)this);
    }

    public boolean hasSkipTests() {
        return this.skipTests != null;
    }

    public String getValuesFile() {
        return this.valuesFile;
    }

    public A withValuesFile(String valuesFile) {
        this.valuesFile = valuesFile;
        return (A)((Object)this);
    }

    public boolean hasValuesFile() {
        return this.valuesFile != null;
    }

    public A addToValuesInline(String key, Object value) {
        if (this.valuesInline == null && key != null && value != null) {
            this.valuesInline = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.valuesInline.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToValuesInline(Map<String, Object> map) {
        if (this.valuesInline == null && map != null) {
            this.valuesInline = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.valuesInline.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromValuesInline(String key) {
        if (this.valuesInline == null) {
            return (A)((Object)this);
        }
        if (key != null && this.valuesInline != null) {
            this.valuesInline.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromValuesInline(Map<String, Object> map) {
        if (this.valuesInline == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.valuesInline == null) continue;
                this.valuesInline.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getValuesInline() {
        return this.valuesInline;
    }

    public <K, V> A withValuesInline(Map<String, Object> valuesInline) {
        this.valuesInline = valuesInline == null ? null : new LinkedHashMap<String, Object>(valuesInline);
        return (A)((Object)this);
    }

    public boolean hasValuesInline() {
        return this.valuesInline != null;
    }

    public String getValuesMerge() {
        return this.valuesMerge;
    }

    public A withValuesMerge(String valuesMerge) {
        this.valuesMerge = valuesMerge;
        return (A)((Object)this);
    }

    public boolean hasValuesMerge() {
        return this.valuesMerge != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HelmChartFluent that = (HelmChartFluent)((Object)o);
        if (!Objects.equals(this.additionalValuesFiles, that.additionalValuesFiles)) {
            return false;
        }
        if (!Objects.equals(this.apiVersions, that.apiVersions)) {
            return false;
        }
        if (!Objects.equals(this.includeCRDs, that.includeCRDs)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.nameTemplate, that.nameTemplate)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.releaseName, that.releaseName)) {
            return false;
        }
        if (!Objects.equals(this.repo, that.repo)) {
            return false;
        }
        if (!Objects.equals(this.skipHooks, that.skipHooks)) {
            return false;
        }
        if (!Objects.equals(this.skipTests, that.skipTests)) {
            return false;
        }
        if (!Objects.equals(this.valuesFile, that.valuesFile)) {
            return false;
        }
        if (!Objects.equals(this.valuesInline, that.valuesInline)) {
            return false;
        }
        if (!Objects.equals(this.valuesMerge, that.valuesMerge)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.additionalValuesFiles, this.apiVersions, this.includeCRDs, this.name, this.nameTemplate, this.namespace, this.releaseName, this.repo, this.skipHooks, this.skipTests, this.valuesFile, this.valuesInline, this.valuesMerge, this.version, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.additionalValuesFiles != null && !this.additionalValuesFiles.isEmpty()) {
            sb.append("additionalValuesFiles:");
            sb.append(this.additionalValuesFiles + ",");
        }
        if (this.apiVersions != null && !this.apiVersions.isEmpty()) {
            sb.append("apiVersions:");
            sb.append(this.apiVersions + ",");
        }
        if (this.includeCRDs != null) {
            sb.append("includeCRDs:");
            sb.append(this.includeCRDs + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.nameTemplate != null) {
            sb.append("nameTemplate:");
            sb.append(this.nameTemplate + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.releaseName != null) {
            sb.append("releaseName:");
            sb.append(this.releaseName + ",");
        }
        if (this.repo != null) {
            sb.append("repo:");
            sb.append(this.repo + ",");
        }
        if (this.skipHooks != null) {
            sb.append("skipHooks:");
            sb.append(this.skipHooks + ",");
        }
        if (this.skipTests != null) {
            sb.append("skipTests:");
            sb.append(this.skipTests + ",");
        }
        if (this.valuesFile != null) {
            sb.append("valuesFile:");
            sb.append(this.valuesFile + ",");
        }
        if (this.valuesInline != null && !this.valuesInline.isEmpty()) {
            sb.append("valuesInline:");
            sb.append(this.valuesInline + ",");
        }
        if (this.valuesMerge != null) {
            sb.append("valuesMerge:");
            sb.append(this.valuesMerge + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withIncludeCRDs() {
        return this.withIncludeCRDs(true);
    }

    public A withSkipHooks() {
        return this.withSkipHooks(true);
    }

    public A withSkipTests() {
        return this.withSkipTests(true);
    }
}

