/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.PolicyAncestorStatus;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.PolicyAncestorStatusBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.PolicyAncestorStatusFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.PolicyStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PolicyStatusFluent<A extends PolicyStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<PolicyAncestorStatusBuilder> ancestors = new ArrayList();

    public PolicyStatusFluent() {
    }

    public PolicyStatusFluent(PolicyStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToAncestors(Collection<PolicyAncestorStatus> items) {
        if (this.ancestors == null) {
            this.ancestors = new ArrayList();
        }
        for (PolicyAncestorStatus item : items) {
            PolicyAncestorStatusBuilder builder = new PolicyAncestorStatusBuilder(item);
            this._visitables.get((Object)"ancestors").add(builder);
            this.ancestors.add(builder);
        }
        return (A)((Object)this);
    }

    public AncestorsNested<A> addNewAncestor() {
        return new AncestorsNested(-1, null);
    }

    public AncestorsNested<A> addNewAncestorLike(PolicyAncestorStatus item) {
        return new AncestorsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAncestors(PolicyAncestorStatus ... items) {
        if (this.ancestors == null) {
            this.ancestors = new ArrayList();
        }
        for (PolicyAncestorStatus item : items) {
            PolicyAncestorStatusBuilder builder = new PolicyAncestorStatusBuilder(item);
            this._visitables.get((Object)"ancestors").add(builder);
            this.ancestors.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToAncestors(int index, PolicyAncestorStatus item) {
        if (this.ancestors == null) {
            this.ancestors = new ArrayList();
        }
        PolicyAncestorStatusBuilder builder = new PolicyAncestorStatusBuilder(item);
        if (index < 0 || index >= this.ancestors.size()) {
            this._visitables.get((Object)"ancestors").add(builder);
            this.ancestors.add(builder);
        } else {
            this._visitables.get((Object)"ancestors").add(builder);
            this.ancestors.add(index, builder);
        }
        return (A)((Object)this);
    }

    public PolicyAncestorStatus buildAncestor(int index) {
        return this.ancestors.get(index).build();
    }

    public List<PolicyAncestorStatus> buildAncestors() {
        return this.ancestors != null ? PolicyStatusFluent.build(this.ancestors) : null;
    }

    public PolicyAncestorStatus buildFirstAncestor() {
        return this.ancestors.get(0).build();
    }

    public PolicyAncestorStatus buildLastAncestor() {
        return this.ancestors.get(this.ancestors.size() - 1).build();
    }

    public PolicyAncestorStatus buildMatchingAncestor(Predicate<PolicyAncestorStatusBuilder> predicate) {
        for (PolicyAncestorStatusBuilder item : this.ancestors) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(PolicyStatus instance) {
        PolicyStatus policyStatus = instance = instance != null ? instance : new PolicyStatus();
        if (instance != null) {
            this.withAncestors(instance.getAncestors());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AncestorsNested<A> editAncestor(int index) {
        if (this.ancestors.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "ancestors"));
        }
        return this.setNewAncestorLike(index, this.buildAncestor(index));
    }

    public AncestorsNested<A> editFirstAncestor() {
        if (this.ancestors.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "ancestors"));
        }
        return this.setNewAncestorLike(0, this.buildAncestor(0));
    }

    public AncestorsNested<A> editLastAncestor() {
        int index = this.ancestors.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "ancestors"));
        }
        return this.setNewAncestorLike(index, this.buildAncestor(index));
    }

    public AncestorsNested<A> editMatchingAncestor(Predicate<PolicyAncestorStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ancestors.size(); ++i) {
            if (!predicate.test(this.ancestors.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "ancestors"));
        }
        return this.setNewAncestorLike(index, this.buildAncestor(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicyStatusFluent that = (PolicyStatusFluent)((Object)o);
        if (!Objects.equals(this.ancestors, that.ancestors)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAncestors() {
        return this.ancestors != null && !this.ancestors.isEmpty();
    }

    public boolean hasMatchingAncestor(Predicate<PolicyAncestorStatusBuilder> predicate) {
        for (PolicyAncestorStatusBuilder item : this.ancestors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.ancestors, this.additionalProperties);
    }

    public A removeAllFromAncestors(Collection<PolicyAncestorStatus> items) {
        if (this.ancestors == null) {
            return (A)((Object)this);
        }
        for (PolicyAncestorStatus item : items) {
            PolicyAncestorStatusBuilder builder = new PolicyAncestorStatusBuilder(item);
            this._visitables.get((Object)"ancestors").remove((Object)builder);
            this.ancestors.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromAncestors(PolicyAncestorStatus ... items) {
        if (this.ancestors == null) {
            return (A)((Object)this);
        }
        for (PolicyAncestorStatus item : items) {
            PolicyAncestorStatusBuilder builder = new PolicyAncestorStatusBuilder(item);
            this._visitables.get((Object)"ancestors").remove((Object)builder);
            this.ancestors.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAncestors(Predicate<PolicyAncestorStatusBuilder> predicate) {
        if (this.ancestors == null) {
            return (A)((Object)this);
        }
        Iterator<PolicyAncestorStatusBuilder> each = this.ancestors.iterator();
        List visitables = this._visitables.get((Object)"ancestors");
        while (each.hasNext()) {
            PolicyAncestorStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public AncestorsNested<A> setNewAncestorLike(int index, PolicyAncestorStatus item) {
        return new AncestorsNested(index, item);
    }

    public A setToAncestors(int index, PolicyAncestorStatus item) {
        if (this.ancestors == null) {
            this.ancestors = new ArrayList();
        }
        PolicyAncestorStatusBuilder builder = new PolicyAncestorStatusBuilder(item);
        if (index < 0 || index >= this.ancestors.size()) {
            this._visitables.get((Object)"ancestors").add(builder);
            this.ancestors.add(builder);
        } else {
            this._visitables.get((Object)"ancestors").add(builder);
            this.ancestors.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ancestors != null && !this.ancestors.isEmpty()) {
            sb.append("ancestors:");
            sb.append(this.ancestors);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAncestors(List<PolicyAncestorStatus> ancestors) {
        if (this.ancestors != null) {
            this._visitables.get((Object)"ancestors").clear();
        }
        if (ancestors != null) {
            this.ancestors = new ArrayList();
            for (PolicyAncestorStatus item : ancestors) {
                this.addToAncestors(item);
            }
        } else {
            this.ancestors = null;
        }
        return (A)((Object)this);
    }

    public A withAncestors(PolicyAncestorStatus ... ancestors) {
        if (this.ancestors != null) {
            this.ancestors.clear();
            this._visitables.remove((Object)"ancestors");
        }
        if (ancestors != null) {
            for (PolicyAncestorStatus item : ancestors) {
                this.addToAncestors(item);
            }
        }
        return (A)((Object)this);
    }

    public class AncestorsNested<N>
    extends PolicyAncestorStatusFluent<AncestorsNested<N>>
    implements Nested<N> {
        PolicyAncestorStatusBuilder builder;
        int index;

        AncestorsNested(int index, PolicyAncestorStatus item) {
            this.index = index;
            this.builder = new PolicyAncestorStatusBuilder(this, item);
        }

        public N and() {
            return (N)PolicyStatusFluent.this.setToAncestors(this.index, this.builder.build());
        }

        public N endAncestor() {
            return this.and();
        }
    }
}

