/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.CookieConfig;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.CookieConfigBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.CookieConfigFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.SessionPersistence;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SessionPersistenceFluent<A extends SessionPersistenceFluent<A>>
extends BaseFluent<A> {
    private String absoluteTimeout;
    private Map<String, Object> additionalProperties;
    private CookieConfigBuilder cookieConfig;
    private String idleTimeout;
    private String sessionName;
    private String type;

    public SessionPersistenceFluent() {
    }

    public SessionPersistenceFluent(SessionPersistence instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public CookieConfig buildCookieConfig() {
        return this.cookieConfig != null ? this.cookieConfig.build() : null;
    }

    protected void copyInstance(SessionPersistence instance) {
        SessionPersistence sessionPersistence = instance = instance != null ? instance : new SessionPersistence();
        if (instance != null) {
            this.withAbsoluteTimeout(instance.getAbsoluteTimeout());
            this.withCookieConfig(instance.getCookieConfig());
            this.withIdleTimeout(instance.getIdleTimeout());
            this.withSessionName(instance.getSessionName());
            this.withType(instance.getType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public CookieConfigNested<A> editCookieConfig() {
        return this.withNewCookieConfigLike(Optional.ofNullable(this.buildCookieConfig()).orElse(null));
    }

    public CookieConfigNested<A> editOrNewCookieConfig() {
        return this.withNewCookieConfigLike(Optional.ofNullable(this.buildCookieConfig()).orElse(new CookieConfigBuilder().build()));
    }

    public CookieConfigNested<A> editOrNewCookieConfigLike(CookieConfig item) {
        return this.withNewCookieConfigLike(Optional.ofNullable(this.buildCookieConfig()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SessionPersistenceFluent that = (SessionPersistenceFluent)((Object)o);
        if (!Objects.equals(this.absoluteTimeout, that.absoluteTimeout)) {
            return false;
        }
        if (!Objects.equals((Object)this.cookieConfig, (Object)that.cookieConfig)) {
            return false;
        }
        if (!Objects.equals(this.idleTimeout, that.idleTimeout)) {
            return false;
        }
        if (!Objects.equals(this.sessionName, that.sessionName)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public String getAbsoluteTimeout() {
        return this.absoluteTimeout;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getIdleTimeout() {
        return this.idleTimeout;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public String getType() {
        return this.type;
    }

    public boolean hasAbsoluteTimeout() {
        return this.absoluteTimeout != null;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCookieConfig() {
        return this.cookieConfig != null;
    }

    public boolean hasIdleTimeout() {
        return this.idleTimeout != null;
    }

    public boolean hasSessionName() {
        return this.sessionName != null;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.absoluteTimeout, this.cookieConfig, this.idleTimeout, this.sessionName, this.type, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.absoluteTimeout != null) {
            sb.append("absoluteTimeout:");
            sb.append(this.absoluteTimeout);
            sb.append(",");
        }
        if (this.cookieConfig != null) {
            sb.append("cookieConfig:");
            sb.append((Object)this.cookieConfig);
            sb.append(",");
        }
        if (this.idleTimeout != null) {
            sb.append("idleTimeout:");
            sb.append(this.idleTimeout);
            sb.append(",");
        }
        if (this.sessionName != null) {
            sb.append("sessionName:");
            sb.append(this.sessionName);
            sb.append(",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAbsoluteTimeout(String absoluteTimeout) {
        this.absoluteTimeout = absoluteTimeout;
        return (A)((Object)this);
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withCookieConfig(CookieConfig cookieConfig) {
        this._visitables.remove((Object)"cookieConfig");
        if (cookieConfig != null) {
            this.cookieConfig = new CookieConfigBuilder(cookieConfig);
            this._visitables.get((Object)"cookieConfig").add(this.cookieConfig);
        } else {
            this.cookieConfig = null;
            this._visitables.get((Object)"cookieConfig").remove((Object)this.cookieConfig);
        }
        return (A)((Object)this);
    }

    public A withIdleTimeout(String idleTimeout) {
        this.idleTimeout = idleTimeout;
        return (A)((Object)this);
    }

    public CookieConfigNested<A> withNewCookieConfig() {
        return new CookieConfigNested(null);
    }

    public A withNewCookieConfig(String lifetimeType) {
        return this.withCookieConfig(new CookieConfig(lifetimeType));
    }

    public CookieConfigNested<A> withNewCookieConfigLike(CookieConfig item) {
        return new CookieConfigNested(item);
    }

    public A withSessionName(String sessionName) {
        this.sessionName = sessionName;
        return (A)((Object)this);
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public class CookieConfigNested<N>
    extends CookieConfigFluent<CookieConfigNested<N>>
    implements Nested<N> {
        CookieConfigBuilder builder;

        CookieConfigNested(CookieConfig item) {
            this.builder = new CookieConfigBuilder(this, item);
        }

        public N and() {
            return (N)SessionPersistenceFluent.this.withCookieConfig(this.builder.build());
        }

        public N endCookieConfig() {
            return this.and();
        }
    }
}

