/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.HTTPAuthConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HTTPAuthConfigFluent<A extends HTTPAuthConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private List<String> allowedHeaders = new ArrayList<String>();
    private List<String> allowedResponseHeaders = new ArrayList<String>();
    private String path;

    public HTTPAuthConfigFluent() {
    }

    public HTTPAuthConfigFluent(HTTPAuthConfig instance) {
        this.copyInstance(instance);
    }

    public A addAllToAllowedHeaders(Collection<String> items) {
        if (this.allowedHeaders == null) {
            this.allowedHeaders = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedHeaders.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAllowedResponseHeaders(Collection<String> items) {
        if (this.allowedResponseHeaders == null) {
            this.allowedResponseHeaders = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedResponseHeaders.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAllowedHeaders(String ... items) {
        if (this.allowedHeaders == null) {
            this.allowedHeaders = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedHeaders.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAllowedHeaders(int index, String item) {
        if (this.allowedHeaders == null) {
            this.allowedHeaders = new ArrayList<String>();
        }
        this.allowedHeaders.add(index, item);
        return (A)((Object)this);
    }

    public A addToAllowedResponseHeaders(String ... items) {
        if (this.allowedResponseHeaders == null) {
            this.allowedResponseHeaders = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedResponseHeaders.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAllowedResponseHeaders(int index, String item) {
        if (this.allowedResponseHeaders == null) {
            this.allowedResponseHeaders = new ArrayList<String>();
        }
        this.allowedResponseHeaders.add(index, item);
        return (A)((Object)this);
    }

    protected void copyInstance(HTTPAuthConfig instance) {
        HTTPAuthConfig hTTPAuthConfig = instance = instance != null ? instance : new HTTPAuthConfig();
        if (instance != null) {
            this.withAllowedHeaders(instance.getAllowedHeaders());
            this.withAllowedResponseHeaders(instance.getAllowedResponseHeaders());
            this.withPath(instance.getPath());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPAuthConfigFluent that = (HTTPAuthConfigFluent)((Object)o);
        if (!Objects.equals(this.allowedHeaders, that.allowedHeaders)) {
            return false;
        }
        if (!Objects.equals(this.allowedResponseHeaders, that.allowedResponseHeaders)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getAllowedHeader(int index) {
        return this.allowedHeaders.get(index);
    }

    public List<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public String getAllowedResponseHeader(int index) {
        return this.allowedResponseHeaders.get(index);
    }

    public List<String> getAllowedResponseHeaders() {
        return this.allowedResponseHeaders;
    }

    public String getFirstAllowedHeader() {
        return this.allowedHeaders.get(0);
    }

    public String getFirstAllowedResponseHeader() {
        return this.allowedResponseHeaders.get(0);
    }

    public String getLastAllowedHeader() {
        return this.allowedHeaders.get(this.allowedHeaders.size() - 1);
    }

    public String getLastAllowedResponseHeader() {
        return this.allowedResponseHeaders.get(this.allowedResponseHeaders.size() - 1);
    }

    public String getMatchingAllowedHeader(Predicate<String> predicate) {
        for (String item : this.allowedHeaders) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getMatchingAllowedResponseHeader(Predicate<String> predicate) {
        for (String item : this.allowedResponseHeaders) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAllowedHeaders() {
        return this.allowedHeaders != null && !this.allowedHeaders.isEmpty();
    }

    public boolean hasAllowedResponseHeaders() {
        return this.allowedResponseHeaders != null && !this.allowedResponseHeaders.isEmpty();
    }

    public boolean hasMatchingAllowedHeader(Predicate<String> predicate) {
        for (String item : this.allowedHeaders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingAllowedResponseHeader(Predicate<String> predicate) {
        for (String item : this.allowedResponseHeaders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public int hashCode() {
        return Objects.hash(this.allowedHeaders, this.allowedResponseHeaders, this.path, this.additionalProperties);
    }

    public A removeAllFromAllowedHeaders(Collection<String> items) {
        if (this.allowedHeaders == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.allowedHeaders.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAllowedResponseHeaders(Collection<String> items) {
        if (this.allowedResponseHeaders == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.allowedResponseHeaders.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromAllowedHeaders(String ... items) {
        if (this.allowedHeaders == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.allowedHeaders.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAllowedResponseHeaders(String ... items) {
        if (this.allowedResponseHeaders == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.allowedResponseHeaders.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToAllowedHeaders(int index, String item) {
        if (this.allowedHeaders == null) {
            this.allowedHeaders = new ArrayList<String>();
        }
        this.allowedHeaders.set(index, item);
        return (A)((Object)this);
    }

    public A setToAllowedResponseHeaders(int index, String item) {
        if (this.allowedResponseHeaders == null) {
            this.allowedResponseHeaders = new ArrayList<String>();
        }
        this.allowedResponseHeaders.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowedHeaders != null && !this.allowedHeaders.isEmpty()) {
            sb.append("allowedHeaders:");
            sb.append(this.allowedHeaders);
            sb.append(",");
        }
        if (this.allowedResponseHeaders != null && !this.allowedResponseHeaders.isEmpty()) {
            sb.append("allowedResponseHeaders:");
            sb.append(this.allowedResponseHeaders);
            sb.append(",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAllowedHeaders(List<String> allowedHeaders) {
        if (allowedHeaders != null) {
            this.allowedHeaders = new ArrayList<String>();
            for (String item : allowedHeaders) {
                this.addToAllowedHeaders(item);
            }
        } else {
            this.allowedHeaders = null;
        }
        return (A)((Object)this);
    }

    public A withAllowedHeaders(String ... allowedHeaders) {
        if (this.allowedHeaders != null) {
            this.allowedHeaders.clear();
            this._visitables.remove((Object)"allowedHeaders");
        }
        if (allowedHeaders != null) {
            for (String item : allowedHeaders) {
                this.addToAllowedHeaders(item);
            }
        }
        return (A)((Object)this);
    }

    public A withAllowedResponseHeaders(List<String> allowedResponseHeaders) {
        if (allowedResponseHeaders != null) {
            this.allowedResponseHeaders = new ArrayList<String>();
            for (String item : allowedResponseHeaders) {
                this.addToAllowedResponseHeaders(item);
            }
        } else {
            this.allowedResponseHeaders = null;
        }
        return (A)((Object)this);
    }

    public A withAllowedResponseHeaders(String ... allowedResponseHeaders) {
        if (this.allowedResponseHeaders != null) {
            this.allowedResponseHeaders.clear();
            this._visitables.remove((Object)"allowedResponseHeaders");
        }
        if (allowedResponseHeaders != null) {
            for (String item : allowedResponseHeaders) {
                this.addToAllowedResponseHeaders(item);
            }
        }
        return (A)((Object)this);
    }

    public A withPath(String path) {
        this.path = path;
        return (A)((Object)this);
    }
}

