package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GatewayStatusBuilder extends GatewayStatusFluent<GatewayStatusBuilder> implements VisitableBuilder<GatewayStatus,GatewayStatusBuilder>{
  public GatewayStatusBuilder() {
    this(new GatewayStatus());
  }
  
  public GatewayStatusBuilder(GatewayStatusFluent<?> fluent) {
    this(fluent, new GatewayStatus());
  }
  
  public GatewayStatusBuilder(GatewayStatusFluent<?> fluent,GatewayStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GatewayStatusBuilder(GatewayStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GatewayStatusFluent<?> fluent;
  
  public GatewayStatus build() {
    GatewayStatus buildable = new GatewayStatus(fluent.buildAddresses(),fluent.getConditions(),fluent.buildListeners());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}