package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GatewayClassStatusFluent<A extends GatewayClassStatusFluent<A>> extends BaseFluent<A>{
  public GatewayClassStatusFluent() {
  }
  
  public GatewayClassStatusFluent(GatewayClassStatus instance) {
    this.copyInstance(instance);
  }
  private List<Condition> conditions = new ArrayList<Condition>();
  private ArrayList<SupportedFeatureBuilder> supportedFeatures = new ArrayList<SupportedFeatureBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(GatewayClassStatus instance) {
    instance = (instance != null ? instance : new GatewayClassStatus());
    if (instance != null) {
          this.withConditions(instance.getConditions());
          this.withSupportedFeatures(instance.getSupportedFeatures());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<Condition> items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public List<Condition> getConditions() {
    return this.conditions;
  }
  
  public Condition getCondition(int index) {
    return this.conditions.get(index);
  }
  
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (Condition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (Condition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public A addToSupportedFeatures(int index,SupportedFeature item) {
    if (this.supportedFeatures == null) {this.supportedFeatures = new ArrayList<SupportedFeatureBuilder>();}
    SupportedFeatureBuilder builder = new SupportedFeatureBuilder(item);
    if (index < 0 || index >= supportedFeatures.size()) { _visitables.get("supportedFeatures").add(builder); supportedFeatures.add(builder); } else { _visitables.get("supportedFeatures").add(index, builder); supportedFeatures.add(index, builder);}
    return (A)this;
  }
  
  public A setToSupportedFeatures(int index,SupportedFeature item) {
    if (this.supportedFeatures == null) {this.supportedFeatures = new ArrayList<SupportedFeatureBuilder>();}
    SupportedFeatureBuilder builder = new SupportedFeatureBuilder(item);
    if (index < 0 || index >= supportedFeatures.size()) { _visitables.get("supportedFeatures").add(builder); supportedFeatures.add(builder); } else { _visitables.get("supportedFeatures").set(index, builder); supportedFeatures.set(index, builder);}
    return (A)this;
  }
  
  public A addToSupportedFeatures(io.fabric8.kubernetes.api.model.gatewayapi.v1.SupportedFeature... items) {
    if (this.supportedFeatures == null) {this.supportedFeatures = new ArrayList<SupportedFeatureBuilder>();}
    for (SupportedFeature item : items) {SupportedFeatureBuilder builder = new SupportedFeatureBuilder(item);_visitables.get("supportedFeatures").add(builder);this.supportedFeatures.add(builder);} return (A)this;
  }
  
  public A addAllToSupportedFeatures(Collection<SupportedFeature> items) {
    if (this.supportedFeatures == null) {this.supportedFeatures = new ArrayList<SupportedFeatureBuilder>();}
    for (SupportedFeature item : items) {SupportedFeatureBuilder builder = new SupportedFeatureBuilder(item);_visitables.get("supportedFeatures").add(builder);this.supportedFeatures.add(builder);} return (A)this;
  }
  
  public A removeFromSupportedFeatures(io.fabric8.kubernetes.api.model.gatewayapi.v1.SupportedFeature... items) {
    if (this.supportedFeatures == null) return (A)this;
    for (SupportedFeature item : items) {SupportedFeatureBuilder builder = new SupportedFeatureBuilder(item);_visitables.get("supportedFeatures").remove(builder); this.supportedFeatures.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSupportedFeatures(Collection<SupportedFeature> items) {
    if (this.supportedFeatures == null) return (A)this;
    for (SupportedFeature item : items) {SupportedFeatureBuilder builder = new SupportedFeatureBuilder(item);_visitables.get("supportedFeatures").remove(builder); this.supportedFeatures.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSupportedFeatures(Predicate<SupportedFeatureBuilder> predicate) {
    if (supportedFeatures == null) return (A) this;
    final Iterator<SupportedFeatureBuilder> each = supportedFeatures.iterator();
    final List visitables = _visitables.get("supportedFeatures");
    while (each.hasNext()) {
      SupportedFeatureBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SupportedFeature> buildSupportedFeatures() {
    return this.supportedFeatures != null ? build(supportedFeatures) : null;
  }
  
  public SupportedFeature buildSupportedFeature(int index) {
    return this.supportedFeatures.get(index).build();
  }
  
  public SupportedFeature buildFirstSupportedFeature() {
    return this.supportedFeatures.get(0).build();
  }
  
  public SupportedFeature buildLastSupportedFeature() {
    return this.supportedFeatures.get(supportedFeatures.size() - 1).build();
  }
  
  public SupportedFeature buildMatchingSupportedFeature(Predicate<SupportedFeatureBuilder> predicate) {
      for (SupportedFeatureBuilder item : supportedFeatures) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSupportedFeature(Predicate<SupportedFeatureBuilder> predicate) {
      for (SupportedFeatureBuilder item : supportedFeatures) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSupportedFeatures(List<SupportedFeature> supportedFeatures) {
    if (this.supportedFeatures != null) {
      this._visitables.get("supportedFeatures").clear();
    }
    if (supportedFeatures != null) {
        this.supportedFeatures = new ArrayList();
        for (SupportedFeature item : supportedFeatures) {
          this.addToSupportedFeatures(item);
        }
    } else {
      this.supportedFeatures = null;
    }
    return (A) this;
  }
  
  public A withSupportedFeatures(io.fabric8.kubernetes.api.model.gatewayapi.v1.SupportedFeature... supportedFeatures) {
    if (this.supportedFeatures != null) {
        this.supportedFeatures.clear();
        _visitables.remove("supportedFeatures");
    }
    if (supportedFeatures != null) {
      for (SupportedFeature item : supportedFeatures) {
        this.addToSupportedFeatures(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSupportedFeatures() {
    return this.supportedFeatures != null && !this.supportedFeatures.isEmpty();
  }
  
  public A addNewSupportedFeature(String name) {
    return (A)addToSupportedFeatures(new SupportedFeature(name));
  }
  
  public SupportedFeaturesNested<A> addNewSupportedFeature() {
    return new SupportedFeaturesNested(-1, null);
  }
  
  public SupportedFeaturesNested<A> addNewSupportedFeatureLike(SupportedFeature item) {
    return new SupportedFeaturesNested(-1, item);
  }
  
  public SupportedFeaturesNested<A> setNewSupportedFeatureLike(int index,SupportedFeature item) {
    return new SupportedFeaturesNested(index, item);
  }
  
  public SupportedFeaturesNested<A> editSupportedFeature(int index) {
    if (supportedFeatures.size() <= index) throw new RuntimeException("Can't edit supportedFeatures. Index exceeds size.");
    return setNewSupportedFeatureLike(index, buildSupportedFeature(index));
  }
  
  public SupportedFeaturesNested<A> editFirstSupportedFeature() {
    if (supportedFeatures.size() == 0) throw new RuntimeException("Can't edit first supportedFeatures. The list is empty.");
    return setNewSupportedFeatureLike(0, buildSupportedFeature(0));
  }
  
  public SupportedFeaturesNested<A> editLastSupportedFeature() {
    int index = supportedFeatures.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last supportedFeatures. The list is empty.");
    return setNewSupportedFeatureLike(index, buildSupportedFeature(index));
  }
  
  public SupportedFeaturesNested<A> editMatchingSupportedFeature(Predicate<SupportedFeatureBuilder> predicate) {
    int index = -1;
    for (int i=0;i<supportedFeatures.size();i++) { 
    if (predicate.test(supportedFeatures.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching supportedFeatures. No match found.");
    return setNewSupportedFeatureLike(index, buildSupportedFeature(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GatewayClassStatusFluent that = (GatewayClassStatusFluent) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(supportedFeatures, that.supportedFeatures)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(conditions,  supportedFeatures,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (supportedFeatures != null && !supportedFeatures.isEmpty()) { sb.append("supportedFeatures:"); sb.append(supportedFeatures + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SupportedFeaturesNested<N> extends SupportedFeatureFluent<SupportedFeaturesNested<N>> implements Nested<N>{
    SupportedFeaturesNested(int index,SupportedFeature item) {
      this.index = index;
      this.builder = new SupportedFeatureBuilder(this, item);
    }
    SupportedFeatureBuilder builder;
    int index;
    
    public N and() {
      return (N) GatewayClassStatusFluent.this.setToSupportedFeatures(index,builder.build());
    }
    
    public N endSupportedFeature() {
      return and();
    }
    
  
  }

}