package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NetworkPolicyEgressRuleBuilder extends NetworkPolicyEgressRuleFluent<NetworkPolicyEgressRuleBuilder> implements VisitableBuilder<NetworkPolicyEgressRule,NetworkPolicyEgressRuleBuilder>{
  public NetworkPolicyEgressRuleBuilder() {
    this(new NetworkPolicyEgressRule());
  }
  
  public NetworkPolicyEgressRuleBuilder(NetworkPolicyEgressRuleFluent<?> fluent) {
    this(fluent, new NetworkPolicyEgressRule());
  }
  
  public NetworkPolicyEgressRuleBuilder(NetworkPolicyEgressRuleFluent<?> fluent,NetworkPolicyEgressRule instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NetworkPolicyEgressRuleBuilder(NetworkPolicyEgressRule instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NetworkPolicyEgressRuleFluent<?> fluent;
  
  public NetworkPolicyEgressRule build() {
    NetworkPolicyEgressRule buildable = new NetworkPolicyEgressRule(fluent.buildPorts(),fluent.buildTo());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}