/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRule;
import io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleBuilder;
import io.fabric8.kubernetes.api.model.extensions.NetworkPolicyEgressRuleFluent;
import io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRule;
import io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleBuilder;
import io.fabric8.kubernetes.api.model.extensions.NetworkPolicyIngressRuleFluent;
import io.fabric8.kubernetes.api.model.extensions.NetworkPolicySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class NetworkPolicySpecFluent<A extends NetworkPolicySpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<NetworkPolicyEgressRuleBuilder> egress = new ArrayList();
    private ArrayList<NetworkPolicyIngressRuleBuilder> ingress = new ArrayList();
    private LabelSelectorBuilder podSelector;
    private List<String> policyTypes = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public NetworkPolicySpecFluent() {
    }

    public NetworkPolicySpecFluent(NetworkPolicySpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NetworkPolicySpec instance) {
        NetworkPolicySpec networkPolicySpec = instance = instance != null ? instance : new NetworkPolicySpec();
        if (instance != null) {
            this.withEgress(instance.getEgress());
            this.withIngress(instance.getIngress());
            this.withPodSelector(instance.getPodSelector());
            this.withPolicyTypes(instance.getPolicyTypes());
            this.withEgress(instance.getEgress());
            this.withIngress(instance.getIngress());
            this.withPodSelector(instance.getPodSelector());
            this.withPolicyTypes(instance.getPolicyTypes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToEgress(int index, NetworkPolicyEgressRule item) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);
        if (index < 0 || index >= this.egress.size()) {
            this._visitables.get((Object)"egress").add(builder);
            this.egress.add(builder);
        } else {
            this._visitables.get((Object)"egress").add(index, builder);
            this.egress.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEgress(int index, NetworkPolicyEgressRule item) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);
        if (index < 0 || index >= this.egress.size()) {
            this._visitables.get((Object)"egress").add(builder);
            this.egress.add(builder);
        } else {
            this._visitables.get((Object)"egress").set(index, builder);
            this.egress.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEgress(NetworkPolicyEgressRule ... items) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        for (NetworkPolicyEgressRule item : items) {
            NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get((Object)"egress").add(builder);
            this.egress.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEgress(Collection<NetworkPolicyEgressRule> items) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        for (NetworkPolicyEgressRule item : items) {
            NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get((Object)"egress").add(builder);
            this.egress.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEgress(NetworkPolicyEgressRule ... items) {
        if (this.egress == null) {
            return (A)((Object)this);
        }
        for (NetworkPolicyEgressRule item : items) {
            NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get((Object)"egress").remove((Object)builder);
            this.egress.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEgress(Collection<NetworkPolicyEgressRule> items) {
        if (this.egress == null) {
            return (A)((Object)this);
        }
        for (NetworkPolicyEgressRule item : items) {
            NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get((Object)"egress").remove((Object)builder);
            this.egress.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate) {
        if (this.egress == null) {
            return (A)((Object)this);
        }
        Iterator<NetworkPolicyEgressRuleBuilder> each = this.egress.iterator();
        List visitables = this._visitables.get((Object)"egress");
        while (each.hasNext()) {
            NetworkPolicyEgressRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<NetworkPolicyEgressRule> buildEgress() {
        return this.egress != null ? NetworkPolicySpecFluent.build(this.egress) : null;
    }

    public NetworkPolicyEgressRule buildEgress(int index) {
        return this.egress.get(index).build();
    }

    public NetworkPolicyEgressRule buildFirstEgress() {
        return this.egress.get(0).build();
    }

    public NetworkPolicyEgressRule buildLastEgress() {
        return this.egress.get(this.egress.size() - 1).build();
    }

    public NetworkPolicyEgressRule buildMatchingEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate) {
        for (NetworkPolicyEgressRuleBuilder item : this.egress) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate) {
        for (NetworkPolicyEgressRuleBuilder item : this.egress) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEgress(List<NetworkPolicyEgressRule> egress) {
        if (this.egress != null) {
            this._visitables.get((Object)"egress").clear();
        }
        if (egress != null) {
            this.egress = new ArrayList();
            for (NetworkPolicyEgressRule item : egress) {
                this.addToEgress(item);
            }
        } else {
            this.egress = null;
        }
        return (A)((Object)this);
    }

    public A withEgress(NetworkPolicyEgressRule ... egress) {
        if (this.egress != null) {
            this.egress.clear();
            this._visitables.remove((Object)"egress");
        }
        if (egress != null) {
            for (NetworkPolicyEgressRule item : egress) {
                this.addToEgress(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEgress() {
        return this.egress != null && !this.egress.isEmpty();
    }

    public EgressNested<A> addNewEgress() {
        return new EgressNested(-1, null);
    }

    public EgressNested<A> addNewEgressLike(NetworkPolicyEgressRule item) {
        return new EgressNested(-1, item);
    }

    public EgressNested<A> setNewEgressLike(int index, NetworkPolicyEgressRule item) {
        return new EgressNested(index, item);
    }

    public EgressNested<A> editEgress(int index) {
        if (this.egress.size() <= index) {
            throw new RuntimeException("Can't edit egress. Index exceeds size.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    public EgressNested<A> editFirstEgress() {
        if (this.egress.size() == 0) {
            throw new RuntimeException("Can't edit first egress. The list is empty.");
        }
        return this.setNewEgressLike(0, this.buildEgress(0));
    }

    public EgressNested<A> editLastEgress() {
        int index = this.egress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last egress. The list is empty.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    public EgressNested<A> editMatchingEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.egress.size(); ++i) {
            if (!predicate.test(this.egress.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching egress. No match found.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    public A addToIngress(int index, NetworkPolicyIngressRule item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get((Object)"ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get((Object)"ingress").add(index, builder);
            this.ingress.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToIngress(int index, NetworkPolicyIngressRule item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get((Object)"ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get((Object)"ingress").set(index, builder);
            this.ingress.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToIngress(NetworkPolicyIngressRule ... items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (NetworkPolicyIngressRule item : items) {
            NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get((Object)"ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToIngress(Collection<NetworkPolicyIngressRule> items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (NetworkPolicyIngressRule item : items) {
            NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get((Object)"ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromIngress(NetworkPolicyIngressRule ... items) {
        if (this.ingress == null) {
            return (A)((Object)this);
        }
        for (NetworkPolicyIngressRule item : items) {
            NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get((Object)"ingress").remove((Object)builder);
            this.ingress.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIngress(Collection<NetworkPolicyIngressRule> items) {
        if (this.ingress == null) {
            return (A)((Object)this);
        }
        for (NetworkPolicyIngressRule item : items) {
            NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get((Object)"ingress").remove((Object)builder);
            this.ingress.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate) {
        if (this.ingress == null) {
            return (A)((Object)this);
        }
        Iterator<NetworkPolicyIngressRuleBuilder> each = this.ingress.iterator();
        List visitables = this._visitables.get((Object)"ingress");
        while (each.hasNext()) {
            NetworkPolicyIngressRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<NetworkPolicyIngressRule> buildIngress() {
        return this.ingress != null ? NetworkPolicySpecFluent.build(this.ingress) : null;
    }

    public NetworkPolicyIngressRule buildIngress(int index) {
        return this.ingress.get(index).build();
    }

    public NetworkPolicyIngressRule buildFirstIngress() {
        return this.ingress.get(0).build();
    }

    public NetworkPolicyIngressRule buildLastIngress() {
        return this.ingress.get(this.ingress.size() - 1).build();
    }

    public NetworkPolicyIngressRule buildMatchingIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate) {
        for (NetworkPolicyIngressRuleBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate) {
        for (NetworkPolicyIngressRuleBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIngress(List<NetworkPolicyIngressRule> ingress) {
        if (this.ingress != null) {
            this._visitables.get((Object)"ingress").clear();
        }
        if (ingress != null) {
            this.ingress = new ArrayList();
            for (NetworkPolicyIngressRule item : ingress) {
                this.addToIngress(item);
            }
        } else {
            this.ingress = null;
        }
        return (A)((Object)this);
    }

    public A withIngress(NetworkPolicyIngressRule ... ingress) {
        if (this.ingress != null) {
            this.ingress.clear();
            this._visitables.remove((Object)"ingress");
        }
        if (ingress != null) {
            for (NetworkPolicyIngressRule item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasIngress() {
        return this.ingress != null && !this.ingress.isEmpty();
    }

    public IngressNested<A> addNewIngress() {
        return new IngressNested(-1, null);
    }

    public IngressNested<A> addNewIngressLike(NetworkPolicyIngressRule item) {
        return new IngressNested(-1, item);
    }

    public IngressNested<A> setNewIngressLike(int index, NetworkPolicyIngressRule item) {
        return new IngressNested(index, item);
    }

    public IngressNested<A> editIngress(int index) {
        if (this.ingress.size() <= index) {
            throw new RuntimeException("Can't edit ingress. Index exceeds size.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public IngressNested<A> editFirstIngress() {
        if (this.ingress.size() == 0) {
            throw new RuntimeException("Can't edit first ingress. The list is empty.");
        }
        return this.setNewIngressLike(0, this.buildIngress(0));
    }

    public IngressNested<A> editLastIngress() {
        int index = this.ingress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ingress. The list is empty.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public IngressNested<A> editMatchingIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ingress.size(); ++i) {
            if (!predicate.test(this.ingress.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ingress. No match found.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public LabelSelector buildPodSelector() {
        return this.podSelector != null ? this.podSelector.build() : null;
    }

    public A withPodSelector(LabelSelector podSelector) {
        this._visitables.remove((Object)this.podSelector);
        if (podSelector != null) {
            this.podSelector = new LabelSelectorBuilder(podSelector);
            this._visitables.get((Object)"podSelector").add(this.podSelector);
        } else {
            this.podSelector = null;
            this._visitables.get((Object)"podSelector").remove(this.podSelector);
        }
        return (A)((Object)this);
    }

    public boolean hasPodSelector() {
        return this.podSelector != null;
    }

    public PodSelectorNested<A> withNewPodSelector() {
        return new PodSelectorNested(null);
    }

    public PodSelectorNested<A> withNewPodSelectorLike(LabelSelector item) {
        return new PodSelectorNested(item);
    }

    public PodSelectorNested<A> editPodSelector() {
        return this.withNewPodSelectorLike(Optional.ofNullable(this.buildPodSelector()).orElse(null));
    }

    public PodSelectorNested<A> editOrNewPodSelector() {
        return this.withNewPodSelectorLike(Optional.ofNullable(this.buildPodSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public PodSelectorNested<A> editOrNewPodSelectorLike(LabelSelector item) {
        return this.withNewPodSelectorLike(Optional.ofNullable(this.buildPodSelector()).orElse(item));
    }

    public A addToPolicyTypes(int index, String item) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        this.policyTypes.add(index, item);
        return (A)((Object)this);
    }

    public A setToPolicyTypes(int index, String item) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        this.policyTypes.set(index, item);
        return (A)((Object)this);
    }

    public A addToPolicyTypes(String ... items) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.policyTypes.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToPolicyTypes(Collection<String> items) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.policyTypes.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromPolicyTypes(String ... items) {
        if (this.policyTypes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.policyTypes.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPolicyTypes(Collection<String> items) {
        if (this.policyTypes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.policyTypes.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getPolicyTypes() {
        return this.policyTypes;
    }

    public String getPolicyType(int index) {
        return this.policyTypes.get(index);
    }

    public String getFirstPolicyType() {
        return this.policyTypes.get(0);
    }

    public String getLastPolicyType() {
        return this.policyTypes.get(this.policyTypes.size() - 1);
    }

    public String getMatchingPolicyType(Predicate<String> predicate) {
        for (String item : this.policyTypes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPolicyType(Predicate<String> predicate) {
        for (String item : this.policyTypes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPolicyTypes(List<String> policyTypes) {
        if (policyTypes != null) {
            this.policyTypes = new ArrayList<String>();
            for (String item : policyTypes) {
                this.addToPolicyTypes(item);
            }
        } else {
            this.policyTypes = null;
        }
        return (A)((Object)this);
    }

    public A withPolicyTypes(String ... policyTypes) {
        if (this.policyTypes != null) {
            this.policyTypes.clear();
            this._visitables.remove((Object)"policyTypes");
        }
        if (policyTypes != null) {
            for (String item : policyTypes) {
                this.addToPolicyTypes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPolicyTypes() {
        return this.policyTypes != null && !this.policyTypes.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkPolicySpecFluent that = (NetworkPolicySpecFluent)((Object)o);
        if (!Objects.equals(this.egress, that.egress)) {
            return false;
        }
        if (!Objects.equals(this.ingress, that.ingress)) {
            return false;
        }
        if (!Objects.equals(this.podSelector, that.podSelector)) {
            return false;
        }
        if (!Objects.equals(this.policyTypes, that.policyTypes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.egress, this.ingress, this.podSelector, this.policyTypes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.egress != null && !this.egress.isEmpty()) {
            sb.append("egress:");
            sb.append(this.egress + ",");
        }
        if (this.ingress != null && !this.ingress.isEmpty()) {
            sb.append("ingress:");
            sb.append(this.ingress + ",");
        }
        if (this.podSelector != null) {
            sb.append("podSelector:");
            sb.append(this.podSelector + ",");
        }
        if (this.policyTypes != null && !this.policyTypes.isEmpty()) {
            sb.append("policyTypes:");
            sb.append(this.policyTypes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PodSelectorNested<N>
    extends LabelSelectorFluent<PodSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        PodSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)NetworkPolicySpecFluent.this.withPodSelector(this.builder.build());
        }

        public N endPodSelector() {
            return this.and();
        }
    }

    public class IngressNested<N>
    extends NetworkPolicyIngressRuleFluent<IngressNested<N>>
    implements Nested<N> {
        NetworkPolicyIngressRuleBuilder builder;
        int index;

        IngressNested(int index, NetworkPolicyIngressRule item) {
            this.index = index;
            this.builder = new NetworkPolicyIngressRuleBuilder(this, item);
        }

        public N and() {
            return (N)NetworkPolicySpecFluent.this.setToIngress(this.index, this.builder.build());
        }

        public N endIngress() {
            return this.and();
        }
    }

    public class EgressNested<N>
    extends NetworkPolicyEgressRuleFluent<EgressNested<N>>
    implements Nested<N> {
        NetworkPolicyEgressRuleBuilder builder;
        int index;

        EgressNested(int index, NetworkPolicyEgressRule item) {
            this.index = index;
            this.builder = new NetworkPolicyEgressRuleBuilder(this, item);
        }

        public N and() {
            return (N)NetworkPolicySpecFluent.this.setToEgress(this.index, this.builder.build());
        }

        public N endEgress() {
            return this.and();
        }
    }
}

