/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.clusterapi.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.NodeSystemInfo;
import io.fabric8.kubernetes.api.model.NodeSystemInfoBuilder;
import io.fabric8.kubernetes.api.model.NodeSystemInfoFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.Condition;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.ConditionBuilder;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.ConditionFluent;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineAddress;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineAddressBuilder;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineAddressFluent;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineDeletionStatus;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineDeletionStatusBuilder;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineDeletionStatusFluent;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineStatus;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineV1Beta2Status;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineV1Beta2StatusBuilder;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineV1Beta2StatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachineStatusFluent<A extends MachineStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<MachineAddressBuilder> addresses = new ArrayList();
    private Boolean bootstrapReady;
    private String certificatesExpiryDate;
    private ArrayList<ConditionBuilder> conditions = new ArrayList();
    private MachineDeletionStatusBuilder deletion;
    private String failureMessage;
    private String failureReason;
    private Boolean infrastructureReady;
    private String lastUpdated;
    private NodeSystemInfoBuilder nodeInfo;
    private ObjectReferenceBuilder nodeRef;
    private Long observedGeneration;
    private String phase;
    private MachineV1Beta2StatusBuilder v1beta2;

    public MachineStatusFluent() {
    }

    public MachineStatusFluent(MachineStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToAddresses(Collection<MachineAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (MachineAddress item : items) {
            MachineAddressBuilder builder = new MachineAddressBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public AddressesNested<A> addNewAddress() {
        return new AddressesNested(-1, null);
    }

    public A addNewAddress(String address, String type) {
        return this.addToAddresses(new MachineAddress(address, type));
    }

    public AddressesNested<A> addNewAddressLike(MachineAddress item) {
        return new AddressesNested(-1, item);
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(MachineAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (MachineAddress item : items) {
            MachineAddressBuilder builder = new MachineAddressBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(int index, MachineAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        MachineAddressBuilder builder = new MachineAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public MachineAddress buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    public List<MachineAddress> buildAddresses() {
        return this.addresses != null ? MachineStatusFluent.build(this.addresses) : null;
    }

    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public List<Condition> buildConditions() {
        return this.conditions != null ? MachineStatusFluent.build(this.conditions) : null;
    }

    public MachineDeletionStatus buildDeletion() {
        return this.deletion != null ? this.deletion.build() : null;
    }

    public MachineAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public MachineAddress buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public MachineAddress buildMatchingAddress(Predicate<MachineAddressBuilder> predicate) {
        for (MachineAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public NodeSystemInfo buildNodeInfo() {
        return this.nodeInfo != null ? this.nodeInfo.build() : null;
    }

    public ObjectReference buildNodeRef() {
        return this.nodeRef != null ? this.nodeRef.build() : null;
    }

    public MachineV1Beta2Status buildV1beta2() {
        return this.v1beta2 != null ? this.v1beta2.build() : null;
    }

    protected void copyInstance(MachineStatus instance) {
        MachineStatus machineStatus = instance = instance != null ? instance : new MachineStatus();
        if (instance != null) {
            this.withAddresses(instance.getAddresses());
            this.withBootstrapReady(instance.getBootstrapReady());
            this.withCertificatesExpiryDate(instance.getCertificatesExpiryDate());
            this.withConditions(instance.getConditions());
            this.withDeletion(instance.getDeletion());
            this.withFailureMessage(instance.getFailureMessage());
            this.withFailureReason(instance.getFailureReason());
            this.withInfrastructureReady(instance.getInfrastructureReady());
            this.withLastUpdated(instance.getLastUpdated());
            this.withNodeInfo(instance.getNodeInfo());
            this.withNodeRef(instance.getNodeRef());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withPhase(instance.getPhase());
            this.withV1beta2(instance.getV1beta2());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "addresses"));
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public DeletionNested<A> editDeletion() {
        return this.withNewDeletionLike(Optional.ofNullable(this.buildDeletion()).orElse(null));
    }

    public AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "addresses"));
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "addresses"));
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public AddressesNested<A> editMatchingAddress(Predicate<MachineAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "addresses"));
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public NodeInfoNested<A> editNodeInfo() {
        return this.withNewNodeInfoLike(Optional.ofNullable(this.buildNodeInfo()).orElse(null));
    }

    public NodeRefNested<A> editNodeRef() {
        return this.withNewNodeRefLike(Optional.ofNullable(this.buildNodeRef()).orElse(null));
    }

    public DeletionNested<A> editOrNewDeletion() {
        return this.withNewDeletionLike(Optional.ofNullable(this.buildDeletion()).orElse(new MachineDeletionStatusBuilder().build()));
    }

    public DeletionNested<A> editOrNewDeletionLike(MachineDeletionStatus item) {
        return this.withNewDeletionLike(Optional.ofNullable(this.buildDeletion()).orElse(item));
    }

    public NodeInfoNested<A> editOrNewNodeInfo() {
        return this.withNewNodeInfoLike(Optional.ofNullable(this.buildNodeInfo()).orElse(new NodeSystemInfoBuilder().build()));
    }

    public NodeInfoNested<A> editOrNewNodeInfoLike(NodeSystemInfo item) {
        return this.withNewNodeInfoLike(Optional.ofNullable(this.buildNodeInfo()).orElse(item));
    }

    public NodeRefNested<A> editOrNewNodeRef() {
        return this.withNewNodeRefLike(Optional.ofNullable(this.buildNodeRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public NodeRefNested<A> editOrNewNodeRefLike(ObjectReference item) {
        return this.withNewNodeRefLike(Optional.ofNullable(this.buildNodeRef()).orElse(item));
    }

    public V1beta2Nested<A> editOrNewV1beta2() {
        return this.withNewV1beta2Like(Optional.ofNullable(this.buildV1beta2()).orElse(new MachineV1Beta2StatusBuilder().build()));
    }

    public V1beta2Nested<A> editOrNewV1beta2Like(MachineV1Beta2Status item) {
        return this.withNewV1beta2Like(Optional.ofNullable(this.buildV1beta2()).orElse(item));
    }

    public V1beta2Nested<A> editV1beta2() {
        return this.withNewV1beta2Like(Optional.ofNullable(this.buildV1beta2()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineStatusFluent that = (MachineStatusFluent)((Object)o);
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals(this.bootstrapReady, that.bootstrapReady)) {
            return false;
        }
        if (!Objects.equals(this.certificatesExpiryDate, that.certificatesExpiryDate)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals((Object)this.deletion, (Object)that.deletion)) {
            return false;
        }
        if (!Objects.equals(this.failureMessage, that.failureMessage)) {
            return false;
        }
        if (!Objects.equals(this.failureReason, that.failureReason)) {
            return false;
        }
        if (!Objects.equals(this.infrastructureReady, that.infrastructureReady)) {
            return false;
        }
        if (!Objects.equals(this.lastUpdated, that.lastUpdated)) {
            return false;
        }
        if (!Objects.equals((Object)this.nodeInfo, (Object)that.nodeInfo)) {
            return false;
        }
        if (!Objects.equals((Object)this.nodeRef, (Object)that.nodeRef)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.phase, that.phase)) {
            return false;
        }
        if (!Objects.equals((Object)this.v1beta2, (Object)that.v1beta2)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Boolean getBootstrapReady() {
        return this.bootstrapReady;
    }

    public String getCertificatesExpiryDate() {
        return this.certificatesExpiryDate;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public Boolean getInfrastructureReady() {
        return this.infrastructureReady;
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public String getPhase() {
        return this.phase;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public boolean hasBootstrapReady() {
        return this.bootstrapReady != null;
    }

    public boolean hasCertificatesExpiryDate() {
        return this.certificatesExpiryDate != null;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasDeletion() {
        return this.deletion != null;
    }

    public boolean hasFailureMessage() {
        return this.failureMessage != null;
    }

    public boolean hasFailureReason() {
        return this.failureReason != null;
    }

    public boolean hasInfrastructureReady() {
        return this.infrastructureReady != null;
    }

    public boolean hasLastUpdated() {
        return this.lastUpdated != null;
    }

    public boolean hasMatchingAddress(Predicate<MachineAddressBuilder> predicate) {
        for (MachineAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNodeInfo() {
        return this.nodeInfo != null;
    }

    public boolean hasNodeRef() {
        return this.nodeRef != null;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public boolean hasV1beta2() {
        return this.v1beta2 != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addresses, this.bootstrapReady, this.certificatesExpiryDate, this.conditions, this.deletion, this.failureMessage, this.failureReason, this.infrastructureReady, this.lastUpdated, this.nodeInfo, this.nodeRef, this.observedGeneration, this.phase, this.v1beta2, this.additionalProperties});
    }

    public A removeAllFromAddresses(Collection<MachineAddress> items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (MachineAddress item : items) {
            MachineAddressBuilder builder = new MachineAddressBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromAddresses(MachineAddress ... items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (MachineAddress item : items) {
            MachineAddressBuilder builder = new MachineAddressBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAddresses(Predicate<MachineAddressBuilder> predicate) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        Iterator<MachineAddressBuilder> each = this.addresses.iterator();
        List visitables = this._visitables.get((Object)"addresses");
        while (each.hasNext()) {
            MachineAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public AddressesNested<A> setNewAddressLike(int index, MachineAddress item) {
        return new AddressesNested(index, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, Condition item) {
        return new ConditionsNested(index, item);
    }

    public A setToAddresses(int index, MachineAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        MachineAddressBuilder builder = new MachineAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses);
            sb.append(",");
        }
        if (this.bootstrapReady != null) {
            sb.append("bootstrapReady:");
            sb.append(this.bootstrapReady);
            sb.append(",");
        }
        if (this.certificatesExpiryDate != null) {
            sb.append("certificatesExpiryDate:");
            sb.append(this.certificatesExpiryDate);
            sb.append(",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.deletion != null) {
            sb.append("deletion:");
            sb.append((Object)this.deletion);
            sb.append(",");
        }
        if (this.failureMessage != null) {
            sb.append("failureMessage:");
            sb.append(this.failureMessage);
            sb.append(",");
        }
        if (this.failureReason != null) {
            sb.append("failureReason:");
            sb.append(this.failureReason);
            sb.append(",");
        }
        if (this.infrastructureReady != null) {
            sb.append("infrastructureReady:");
            sb.append(this.infrastructureReady);
            sb.append(",");
        }
        if (this.lastUpdated != null) {
            sb.append("lastUpdated:");
            sb.append(this.lastUpdated);
            sb.append(",");
        }
        if (this.nodeInfo != null) {
            sb.append("nodeInfo:");
            sb.append((Object)this.nodeInfo);
            sb.append(",");
        }
        if (this.nodeRef != null) {
            sb.append("nodeRef:");
            sb.append((Object)this.nodeRef);
            sb.append(",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration);
            sb.append(",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase);
            sb.append(",");
        }
        if (this.v1beta2 != null) {
            sb.append("v1beta2:");
            sb.append((Object)this.v1beta2);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAddresses(List<MachineAddress> addresses) {
        if (this.addresses != null) {
            this._visitables.get((Object)"addresses").clear();
        }
        if (addresses != null) {
            this.addresses = new ArrayList();
            for (MachineAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)((Object)this);
    }

    public A withAddresses(MachineAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove((Object)"addresses");
        }
        if (addresses != null) {
            for (MachineAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public A withBootstrapReady() {
        return this.withBootstrapReady(true);
    }

    public A withBootstrapReady(Boolean bootstrapReady) {
        this.bootstrapReady = bootstrapReady;
        return (A)((Object)this);
    }

    public A withCertificatesExpiryDate(String certificatesExpiryDate) {
        this.certificatesExpiryDate = certificatesExpiryDate;
        return (A)((Object)this);
    }

    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withDeletion(MachineDeletionStatus deletion) {
        this._visitables.remove((Object)"deletion");
        if (deletion != null) {
            this.deletion = new MachineDeletionStatusBuilder(deletion);
            this._visitables.get((Object)"deletion").add(this.deletion);
        } else {
            this.deletion = null;
            this._visitables.get((Object)"deletion").remove((Object)this.deletion);
        }
        return (A)((Object)this);
    }

    public A withFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
        return (A)((Object)this);
    }

    public A withFailureReason(String failureReason) {
        this.failureReason = failureReason;
        return (A)((Object)this);
    }

    public A withInfrastructureReady() {
        return this.withInfrastructureReady(true);
    }

    public A withInfrastructureReady(Boolean infrastructureReady) {
        this.infrastructureReady = infrastructureReady;
        return (A)((Object)this);
    }

    public A withLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
        return (A)((Object)this);
    }

    public DeletionNested<A> withNewDeletion() {
        return new DeletionNested(null);
    }

    public A withNewDeletion(String nodeDrainStartTime, String waitForNodeVolumeDetachStartTime) {
        return this.withDeletion(new MachineDeletionStatus(nodeDrainStartTime, waitForNodeVolumeDetachStartTime));
    }

    public DeletionNested<A> withNewDeletionLike(MachineDeletionStatus item) {
        return new DeletionNested(item);
    }

    public NodeInfoNested<A> withNewNodeInfo() {
        return new NodeInfoNested(null);
    }

    public NodeInfoNested<A> withNewNodeInfoLike(NodeSystemInfo item) {
        return new NodeInfoNested(item);
    }

    public NodeRefNested<A> withNewNodeRef() {
        return new NodeRefNested(null);
    }

    public NodeRefNested<A> withNewNodeRefLike(ObjectReference item) {
        return new NodeRefNested(item);
    }

    public V1beta2Nested<A> withNewV1beta2() {
        return new V1beta2Nested(null);
    }

    public V1beta2Nested<A> withNewV1beta2Like(MachineV1Beta2Status item) {
        return new V1beta2Nested(item);
    }

    public A withNodeInfo(NodeSystemInfo nodeInfo) {
        this._visitables.remove((Object)"nodeInfo");
        if (nodeInfo != null) {
            this.nodeInfo = new NodeSystemInfoBuilder(nodeInfo);
            this._visitables.get((Object)"nodeInfo").add(this.nodeInfo);
        } else {
            this.nodeInfo = null;
            this._visitables.get((Object)"nodeInfo").remove((Object)this.nodeInfo);
        }
        return (A)((Object)this);
    }

    public A withNodeRef(ObjectReference nodeRef) {
        this._visitables.remove((Object)"nodeRef");
        if (nodeRef != null) {
            this.nodeRef = new ObjectReferenceBuilder(nodeRef);
            this._visitables.get((Object)"nodeRef").add(this.nodeRef);
        } else {
            this.nodeRef = null;
            this._visitables.get((Object)"nodeRef").remove((Object)this.nodeRef);
        }
        return (A)((Object)this);
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public A withPhase(String phase) {
        this.phase = phase;
        return (A)((Object)this);
    }

    public A withV1beta2(MachineV1Beta2Status v1beta2) {
        this._visitables.remove((Object)"v1beta2");
        if (v1beta2 != null) {
            this.v1beta2 = new MachineV1Beta2StatusBuilder(v1beta2);
            this._visitables.get((Object)"v1beta2").add(this.v1beta2);
        } else {
            this.v1beta2 = null;
            this._visitables.get((Object)"v1beta2").remove((Object)this.v1beta2);
        }
        return (A)((Object)this);
    }

    public class V1beta2Nested<N>
    extends MachineV1Beta2StatusFluent<V1beta2Nested<N>>
    implements Nested<N> {
        MachineV1Beta2StatusBuilder builder;

        V1beta2Nested(MachineV1Beta2Status item) {
            this.builder = new MachineV1Beta2StatusBuilder(this, item);
        }

        public N and() {
            return (N)MachineStatusFluent.this.withV1beta2(this.builder.build());
        }

        public N endV1beta2() {
            return this.and();
        }
    }

    public class NodeRefNested<N>
    extends ObjectReferenceFluent<NodeRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        NodeRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)MachineStatusFluent.this.withNodeRef(this.builder.build());
        }

        public N endNodeRef() {
            return this.and();
        }
    }

    public class NodeInfoNested<N>
    extends NodeSystemInfoFluent<NodeInfoNested<N>>
    implements Nested<N> {
        NodeSystemInfoBuilder builder;

        NodeInfoNested(NodeSystemInfo item) {
            this.builder = new NodeSystemInfoBuilder(this, item);
        }

        public N and() {
            return (N)MachineStatusFluent.this.withNodeInfo(this.builder.build());
        }

        public N endNodeInfo() {
            return this.and();
        }
    }

    public class DeletionNested<N>
    extends MachineDeletionStatusFluent<DeletionNested<N>>
    implements Nested<N> {
        MachineDeletionStatusBuilder builder;

        DeletionNested(MachineDeletionStatus item) {
            this.builder = new MachineDeletionStatusBuilder(this, item);
        }

        public N and() {
            return (N)MachineStatusFluent.this.withDeletion(this.builder.build());
        }

        public N endDeletion() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends ConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ConditionBuilder builder;
        int index;

        ConditionsNested(int index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        public N and() {
            return (N)MachineStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class AddressesNested<N>
    extends MachineAddressFluent<AddressesNested<N>>
    implements Nested<N> {
        MachineAddressBuilder builder;
        int index;

        AddressesNested(int index, MachineAddress item) {
            this.index = index;
            this.builder = new MachineAddressBuilder(this, item);
        }

        public N and() {
            return (N)MachineStatusFluent.this.setToAddresses(this.index, this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }
}

