/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceHealth;
import io.fabric8.kubernetes.api.model.ResourceHealthBuilder;
import io.fabric8.kubernetes.api.model.ResourceHealthFluent;
import io.fabric8.kubernetes.api.model.ResourceStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ResourceStatusFluent<A extends ResourceStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String name;
    private ArrayList<ResourceHealthBuilder> resources = new ArrayList();

    public ResourceStatusFluent() {
    }

    public ResourceStatusFluent(ResourceStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToResources(Collection<ResourceHealth> items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (ResourceHealth item : items) {
            ResourceHealthBuilder builder = new ResourceHealthBuilder(item);
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        }
        return (A)((Object)this);
    }

    public ResourcesNested<A> addNewResource() {
        return new ResourcesNested(-1, null);
    }

    public A addNewResource(String health, String resourceID) {
        return this.addToResources(new ResourceHealth(health, resourceID));
    }

    public ResourcesNested<A> addNewResourceLike(ResourceHealth item) {
        return new ResourcesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToResources(ResourceHealth ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (ResourceHealth item : items) {
            ResourceHealthBuilder builder = new ResourceHealthBuilder(item);
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToResources(int index, ResourceHealth item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        ResourceHealthBuilder builder = new ResourceHealthBuilder(item);
        if (index < 0 || index >= this.resources.size()) {
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        } else {
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(index, builder);
        }
        return (A)((Object)this);
    }

    public ResourceHealth buildFirstResource() {
        return this.resources.get(0).build();
    }

    public ResourceHealth buildLastResource() {
        return this.resources.get(this.resources.size() - 1).build();
    }

    public ResourceHealth buildMatchingResource(Predicate<ResourceHealthBuilder> predicate) {
        for (ResourceHealthBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ResourceHealth buildResource(int index) {
        return this.resources.get(index).build();
    }

    public List<ResourceHealth> buildResources() {
        return this.resources != null ? ResourceStatusFluent.build(this.resources) : null;
    }

    protected void copyInstance(ResourceStatus instance) {
        ResourceStatus resourceStatus = instance = instance != null ? instance : new ResourceStatus();
        if (instance != null) {
            this.withName(instance.getName());
            this.withResources(instance.getResources());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ResourcesNested<A> editFirstResource() {
        if (this.resources.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "resources"));
        }
        return this.setNewResourceLike(0, this.buildResource(0));
    }

    public ResourcesNested<A> editLastResource() {
        int index = this.resources.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "resources"));
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    public ResourcesNested<A> editMatchingResource(Predicate<ResourceHealthBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resources.size(); ++i) {
            if (!predicate.test(this.resources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "resources"));
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    public ResourcesNested<A> editResource(int index) {
        if (this.resources.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "resources"));
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceStatusFluent that = (ResourceStatusFluent)((Object)o);
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchingResource(Predicate<ResourceHealthBuilder> predicate) {
        for (ResourceHealthBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.resources, this.additionalProperties);
    }

    public A removeAllFromResources(Collection<ResourceHealth> items) {
        if (this.resources == null) {
            return (A)((Object)this);
        }
        for (ResourceHealth item : items) {
            ResourceHealthBuilder builder = new ResourceHealthBuilder(item);
            this._visitables.get((Object)"resources").remove((Object)builder);
            this.resources.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromResources(ResourceHealth ... items) {
        if (this.resources == null) {
            return (A)((Object)this);
        }
        for (ResourceHealth item : items) {
            ResourceHealthBuilder builder = new ResourceHealthBuilder(item);
            this._visitables.get((Object)"resources").remove((Object)builder);
            this.resources.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromResources(Predicate<ResourceHealthBuilder> predicate) {
        if (this.resources == null) {
            return (A)((Object)this);
        }
        Iterator<ResourceHealthBuilder> each = this.resources.iterator();
        List visitables = this._visitables.get((Object)"resources");
        while (each.hasNext()) {
            ResourceHealthBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ResourcesNested<A> setNewResourceLike(int index, ResourceHealth item) {
        return new ResourcesNested(index, item);
    }

    public A setToResources(int index, ResourceHealth item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        ResourceHealthBuilder builder = new ResourceHealthBuilder(item);
        if (index < 0 || index >= this.resources.size()) {
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        } else {
            this._visitables.get((Object)"resources").add(builder);
            this.resources.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.resources != null && !this.resources.isEmpty()) {
            sb.append("resources:");
            sb.append(this.resources);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public A withResources(List<ResourceHealth> resources) {
        if (this.resources != null) {
            this._visitables.get((Object)"resources").clear();
        }
        if (resources != null) {
            this.resources = new ArrayList();
            for (ResourceHealth item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)((Object)this);
    }

    public A withResources(ResourceHealth ... resources) {
        if (this.resources != null) {
            this.resources.clear();
            this._visitables.remove((Object)"resources");
        }
        if (resources != null) {
            for (ResourceHealth item : resources) {
                this.addToResources(item);
            }
        }
        return (A)((Object)this);
    }

    public class ResourcesNested<N>
    extends ResourceHealthFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourceHealthBuilder builder;
        int index;

        ResourcesNested(int index, ResourceHealth item) {
            this.index = index;
            this.builder = new ResourceHealthBuilder(this, item);
        }

        public N and() {
            return (N)ResourceStatusFluent.this.setToResources(this.index, this.builder.build());
        }

        public N endResource() {
            return this.and();
        }
    }
}

