/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.NodeRuntimeHandler;
import io.fabric8.kubernetes.api.model.NodeRuntimeHandlerFeatures;
import io.fabric8.kubernetes.api.model.NodeRuntimeHandlerFeaturesBuilder;
import io.fabric8.kubernetes.api.model.NodeRuntimeHandlerFeaturesFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NodeRuntimeHandlerFluent<A extends NodeRuntimeHandlerFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private NodeRuntimeHandlerFeaturesBuilder features;
    private String name;

    public NodeRuntimeHandlerFluent() {
    }

    public NodeRuntimeHandlerFluent(NodeRuntimeHandler instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public NodeRuntimeHandlerFeatures buildFeatures() {
        return this.features != null ? this.features.build() : null;
    }

    protected void copyInstance(NodeRuntimeHandler instance) {
        NodeRuntimeHandler nodeRuntimeHandler = instance = instance != null ? instance : new NodeRuntimeHandler();
        if (instance != null) {
            this.withFeatures(instance.getFeatures());
            this.withName(instance.getName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public FeaturesNested<A> editFeatures() {
        return this.withNewFeaturesLike(Optional.ofNullable(this.buildFeatures()).orElse(null));
    }

    public FeaturesNested<A> editOrNewFeatures() {
        return this.withNewFeaturesLike(Optional.ofNullable(this.buildFeatures()).orElse(new NodeRuntimeHandlerFeaturesBuilder().build()));
    }

    public FeaturesNested<A> editOrNewFeaturesLike(NodeRuntimeHandlerFeatures item) {
        return this.withNewFeaturesLike(Optional.ofNullable(this.buildFeatures()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeRuntimeHandlerFluent that = (NodeRuntimeHandlerFluent)((Object)o);
        if (!Objects.equals((Object)this.features, (Object)that.features)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasFeatures() {
        return this.features != null;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.features, this.name, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.features != null) {
            sb.append("features:");
            sb.append((Object)this.features);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withFeatures(NodeRuntimeHandlerFeatures features) {
        this._visitables.remove((Object)"features");
        if (features != null) {
            this.features = new NodeRuntimeHandlerFeaturesBuilder(features);
            this._visitables.get((Object)"features").add(this.features);
        } else {
            this.features = null;
            this._visitables.get((Object)"features").remove((Object)this.features);
        }
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public FeaturesNested<A> withNewFeatures() {
        return new FeaturesNested(null);
    }

    public A withNewFeatures(Boolean recursiveReadOnlyMounts, Boolean userNamespaces) {
        return this.withFeatures(new NodeRuntimeHandlerFeatures(recursiveReadOnlyMounts, userNamespaces));
    }

    public FeaturesNested<A> withNewFeaturesLike(NodeRuntimeHandlerFeatures item) {
        return new FeaturesNested(item);
    }

    public class FeaturesNested<N>
    extends NodeRuntimeHandlerFeaturesFluent<FeaturesNested<N>>
    implements Nested<N> {
        NodeRuntimeHandlerFeaturesBuilder builder;

        FeaturesNested(NodeRuntimeHandlerFeatures item) {
            this.builder = new NodeRuntimeHandlerFeaturesBuilder(this, item);
        }

        public N and() {
            return (N)NodeRuntimeHandlerFluent.this.withFeatures(this.builder.build());
        }

        public N endFeatures() {
            return this.and();
        }
    }
}

