/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Cluster;
import io.fabric8.kubernetes.api.model.ClusterBuilder;
import io.fabric8.kubernetes.api.model.ClusterFluent;
import io.fabric8.kubernetes.api.model.NamedCluster;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NamedClusterFluent<A extends NamedClusterFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ClusterBuilder cluster;
    private String name;

    public NamedClusterFluent() {
    }

    public NamedClusterFluent(NamedCluster instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public Cluster buildCluster() {
        return this.cluster != null ? this.cluster.build() : null;
    }

    protected void copyInstance(NamedCluster instance) {
        NamedCluster namedCluster = instance = instance != null ? instance : new NamedCluster();
        if (instance != null) {
            this.withCluster(instance.getCluster());
            this.withName(instance.getName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ClusterNested<A> editCluster() {
        return this.withNewClusterLike(Optional.ofNullable(this.buildCluster()).orElse(null));
    }

    public ClusterNested<A> editOrNewCluster() {
        return this.withNewClusterLike(Optional.ofNullable(this.buildCluster()).orElse(new ClusterBuilder().build()));
    }

    public ClusterNested<A> editOrNewClusterLike(Cluster item) {
        return this.withNewClusterLike(Optional.ofNullable(this.buildCluster()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedClusterFluent that = (NamedClusterFluent)((Object)o);
        if (!Objects.equals((Object)this.cluster, (Object)that.cluster)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCluster() {
        return this.cluster != null;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cluster, this.name, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cluster != null) {
            sb.append("cluster:");
            sb.append((Object)this.cluster);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withCluster(Cluster cluster) {
        this._visitables.remove((Object)"cluster");
        if (cluster != null) {
            this.cluster = new ClusterBuilder(cluster);
            this._visitables.get((Object)"cluster").add(this.cluster);
        } else {
            this.cluster = null;
            this._visitables.get((Object)"cluster").remove((Object)this.cluster);
        }
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public ClusterNested<A> withNewCluster() {
        return new ClusterNested(null);
    }

    public ClusterNested<A> withNewClusterLike(Cluster item) {
        return new ClusterNested(item);
    }

    public class ClusterNested<N>
    extends ClusterFluent<ClusterNested<N>>
    implements Nested<N> {
        ClusterBuilder builder;

        ClusterNested(Cluster item) {
            this.builder = new ClusterBuilder(this, item);
        }

        public N and() {
            return (N)NamedClusterFluent.this.withCluster(this.builder.build());
        }

        public N endCluster() {
            return this.and();
        }
    }
}

