/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.ContainerPortFluent;
import io.fabric8.kubernetes.api.model.ContainerResizePolicy;
import io.fabric8.kubernetes.api.model.ContainerResizePolicyBuilder;
import io.fabric8.kubernetes.api.model.ContainerResizePolicyFluent;
import io.fabric8.kubernetes.api.model.ContainerRestartRule;
import io.fabric8.kubernetes.api.model.ContainerRestartRuleBuilder;
import io.fabric8.kubernetes.api.model.ContainerRestartRuleFluent;
import io.fabric8.kubernetes.api.model.EnvFromSource;
import io.fabric8.kubernetes.api.model.EnvFromSourceBuilder;
import io.fabric8.kubernetes.api.model.EnvFromSourceFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.EphemeralContainer;
import io.fabric8.kubernetes.api.model.Lifecycle;
import io.fabric8.kubernetes.api.model.LifecycleBuilder;
import io.fabric8.kubernetes.api.model.LifecycleFluent;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.fabric8.kubernetes.api.model.SecurityContextBuilder;
import io.fabric8.kubernetes.api.model.SecurityContextFluent;
import io.fabric8.kubernetes.api.model.VolumeDevice;
import io.fabric8.kubernetes.api.model.VolumeDeviceBuilder;
import io.fabric8.kubernetes.api.model.VolumeDeviceFluent;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class EphemeralContainerFluent<A extends EphemeralContainerFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private List<String> args = new ArrayList<String>();
    private List<String> command = new ArrayList<String>();
    private ArrayList<EnvVarBuilder> env = new ArrayList();
    private ArrayList<EnvFromSourceBuilder> envFrom = new ArrayList();
    private String image;
    private String imagePullPolicy;
    private LifecycleBuilder lifecycle;
    private ProbeBuilder livenessProbe;
    private String name;
    private ArrayList<ContainerPortBuilder> ports = new ArrayList();
    private ProbeBuilder readinessProbe;
    private ArrayList<ContainerResizePolicyBuilder> resizePolicy = new ArrayList();
    private ResourceRequirementsBuilder resources;
    private String restartPolicy;
    private ArrayList<ContainerRestartRuleBuilder> restartPolicyRules = new ArrayList();
    private SecurityContextBuilder securityContext;
    private ProbeBuilder startupProbe;
    private Boolean stdin;
    private Boolean stdinOnce;
    private String targetContainerName;
    private String terminationMessagePath;
    private String terminationMessagePolicy;
    private Boolean tty;
    private ArrayList<VolumeDeviceBuilder> volumeDevices = new ArrayList();
    private ArrayList<VolumeMountBuilder> volumeMounts = new ArrayList();
    private String workingDir;

    public EphemeralContainerFluent() {
    }

    public EphemeralContainerFluent(EphemeralContainer instance) {
        this.copyInstance(instance);
    }

    public A addAllToArgs(Collection<String> items) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        for (String item : items) {
            this.args.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCommand(Collection<String> items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEnvFrom(Collection<EnvFromSource> items) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList();
        }
        for (EnvFromSource item : items) {
            EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
            this._visitables.get((Object)"envFrom").add(builder);
            this.envFrom.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPorts(Collection<ContainerPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (ContainerPort item : items) {
            ContainerPortBuilder builder = new ContainerPortBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToResizePolicy(Collection<ContainerResizePolicy> items) {
        if (this.resizePolicy == null) {
            this.resizePolicy = new ArrayList();
        }
        for (ContainerResizePolicy item : items) {
            ContainerResizePolicyBuilder builder = new ContainerResizePolicyBuilder(item);
            this._visitables.get((Object)"resizePolicy").add(builder);
            this.resizePolicy.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRestartPolicyRules(Collection<ContainerRestartRule> items) {
        if (this.restartPolicyRules == null) {
            this.restartPolicyRules = new ArrayList();
        }
        for (ContainerRestartRule item : items) {
            ContainerRestartRuleBuilder builder = new ContainerRestartRuleBuilder(item);
            this._visitables.get((Object)"restartPolicyRules").add(builder);
            this.restartPolicyRules.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumeDevices(Collection<VolumeDevice> items) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList();
        }
        for (VolumeDevice item : items) {
            VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);
            this._visitables.get((Object)"volumeDevices").add(builder);
            this.volumeDevices.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)((Object)this);
    }

    public EnvNested<A> addNewEnv() {
        return new EnvNested(-1, null);
    }

    public EnvFromNested<A> addNewEnvFrom() {
        return new EnvFromNested(-1, null);
    }

    public EnvFromNested<A> addNewEnvFromLike(EnvFromSource item) {
        return new EnvFromNested(-1, item);
    }

    public EnvNested<A> addNewEnvLike(EnvVar item) {
        return new EnvNested(-1, item);
    }

    public PortsNested<A> addNewPort() {
        return new PortsNested(-1, null);
    }

    public A addNewPort(Integer containerPort, String hostIP, Integer hostPort, String name, String protocol) {
        return this.addToPorts(new ContainerPort(containerPort, hostIP, hostPort, name, protocol));
    }

    public PortsNested<A> addNewPortLike(ContainerPort item) {
        return new PortsNested(-1, item);
    }

    public ResizePolicyNested<A> addNewResizePolicy() {
        return new ResizePolicyNested(-1, null);
    }

    public A addNewResizePolicy(String resourceName, String restartPolicy) {
        return this.addToResizePolicy(new ContainerResizePolicy(resourceName, restartPolicy));
    }

    public ResizePolicyNested<A> addNewResizePolicyLike(ContainerResizePolicy item) {
        return new ResizePolicyNested(-1, item);
    }

    public RestartPolicyRulesNested<A> addNewRestartPolicyRule() {
        return new RestartPolicyRulesNested(-1, null);
    }

    public RestartPolicyRulesNested<A> addNewRestartPolicyRuleLike(ContainerRestartRule item) {
        return new RestartPolicyRulesNested(-1, item);
    }

    public VolumeDevicesNested<A> addNewVolumeDevice() {
        return new VolumeDevicesNested(-1, null);
    }

    public A addNewVolumeDevice(String devicePath, String name) {
        return this.addToVolumeDevices(new VolumeDevice(devicePath, name));
    }

    public VolumeDevicesNested<A> addNewVolumeDeviceLike(VolumeDevice item) {
        return new VolumeDevicesNested(-1, item);
    }

    public VolumeMountsNested<A> addNewVolumeMount() {
        return new VolumeMountsNested(-1, null);
    }

    public VolumeMountsNested<A> addNewVolumeMountLike(VolumeMount item) {
        return new VolumeMountsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToArgs(String ... items) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        for (String item : items) {
            this.args.add(item);
        }
        return (A)((Object)this);
    }

    public A addToArgs(int index, String item) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.add(index, item);
        return (A)((Object)this);
    }

    public A addToCommand(String ... items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)((Object)this);
    }

    public A addToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(index, item);
        return (A)((Object)this);
    }

    public A addToEnv(EnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEnvFrom(EnvFromSource ... items) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList();
        }
        for (EnvFromSource item : items) {
            EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
            this._visitables.get((Object)"envFrom").add(builder);
            this.envFrom.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToEnvFrom(int index, EnvFromSource item) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList();
        }
        EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
        if (index < 0 || index >= this.envFrom.size()) {
            this._visitables.get((Object)"envFrom").add(builder);
            this.envFrom.add(builder);
        } else {
            this._visitables.get((Object)"envFrom").add(builder);
            this.envFrom.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPorts(ContainerPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (ContainerPort item : items) {
            ContainerPortBuilder builder = new ContainerPortBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToPorts(int index, ContainerPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        ContainerPortBuilder builder = new ContainerPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToResizePolicy(ContainerResizePolicy ... items) {
        if (this.resizePolicy == null) {
            this.resizePolicy = new ArrayList();
        }
        for (ContainerResizePolicy item : items) {
            ContainerResizePolicyBuilder builder = new ContainerResizePolicyBuilder(item);
            this._visitables.get((Object)"resizePolicy").add(builder);
            this.resizePolicy.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToResizePolicy(int index, ContainerResizePolicy item) {
        if (this.resizePolicy == null) {
            this.resizePolicy = new ArrayList();
        }
        ContainerResizePolicyBuilder builder = new ContainerResizePolicyBuilder(item);
        if (index < 0 || index >= this.resizePolicy.size()) {
            this._visitables.get((Object)"resizePolicy").add(builder);
            this.resizePolicy.add(builder);
        } else {
            this._visitables.get((Object)"resizePolicy").add(builder);
            this.resizePolicy.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRestartPolicyRules(ContainerRestartRule ... items) {
        if (this.restartPolicyRules == null) {
            this.restartPolicyRules = new ArrayList();
        }
        for (ContainerRestartRule item : items) {
            ContainerRestartRuleBuilder builder = new ContainerRestartRuleBuilder(item);
            this._visitables.get((Object)"restartPolicyRules").add(builder);
            this.restartPolicyRules.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToRestartPolicyRules(int index, ContainerRestartRule item) {
        if (this.restartPolicyRules == null) {
            this.restartPolicyRules = new ArrayList();
        }
        ContainerRestartRuleBuilder builder = new ContainerRestartRuleBuilder(item);
        if (index < 0 || index >= this.restartPolicyRules.size()) {
            this._visitables.get((Object)"restartPolicyRules").add(builder);
            this.restartPolicyRules.add(builder);
        } else {
            this._visitables.get((Object)"restartPolicyRules").add(builder);
            this.restartPolicyRules.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumeDevices(VolumeDevice ... items) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList();
        }
        for (VolumeDevice item : items) {
            VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);
            this._visitables.get((Object)"volumeDevices").add(builder);
            this.volumeDevices.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumeDevices(int index, VolumeDevice item) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList();
        }
        VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);
        if (index < 0 || index >= this.volumeDevices.size()) {
            this._visitables.get((Object)"volumeDevices").add(builder);
            this.volumeDevices.add(builder);
        } else {
            this._visitables.get((Object)"volumeDevices").add(builder);
            this.volumeDevices.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumeMounts(VolumeMount ... items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        VolumeMountBuilder builder = new VolumeMountBuilder(item);
        if (index < 0 || index >= this.volumeMounts.size()) {
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        } else {
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(index, builder);
        }
        return (A)((Object)this);
    }

    public List<EnvVar> buildEnv() {
        return this.env != null ? EphemeralContainerFluent.build(this.env) : null;
    }

    public EnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    public List<EnvFromSource> buildEnvFrom() {
        return this.envFrom != null ? EphemeralContainerFluent.build(this.envFrom) : null;
    }

    public EnvFromSource buildEnvFrom(int index) {
        return this.envFrom.get(index).build();
    }

    public EnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    public EnvFromSource buildFirstEnvFrom() {
        return this.envFrom.get(0).build();
    }

    public ContainerPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    public ContainerResizePolicy buildFirstResizePolicy() {
        return this.resizePolicy.get(0).build();
    }

    public ContainerRestartRule buildFirstRestartPolicyRule() {
        return this.restartPolicyRules.get(0).build();
    }

    public VolumeDevice buildFirstVolumeDevice() {
        return this.volumeDevices.get(0).build();
    }

    public VolumeMount buildFirstVolumeMount() {
        return this.volumeMounts.get(0).build();
    }

    public EnvVar buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    public EnvFromSource buildLastEnvFrom() {
        return this.envFrom.get(this.envFrom.size() - 1).build();
    }

    public ContainerPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    public ContainerResizePolicy buildLastResizePolicy() {
        return this.resizePolicy.get(this.resizePolicy.size() - 1).build();
    }

    public ContainerRestartRule buildLastRestartPolicyRule() {
        return this.restartPolicyRules.get(this.restartPolicyRules.size() - 1).build();
    }

    public VolumeDevice buildLastVolumeDevice() {
        return this.volumeDevices.get(this.volumeDevices.size() - 1).build();
    }

    public VolumeMount buildLastVolumeMount() {
        return this.volumeMounts.get(this.volumeMounts.size() - 1).build();
    }

    public Lifecycle buildLifecycle() {
        return this.lifecycle != null ? this.lifecycle.build() : null;
    }

    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public EnvFromSource buildMatchingEnvFrom(Predicate<EnvFromSourceBuilder> predicate) {
        for (EnvFromSourceBuilder item : this.envFrom) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ContainerPort buildMatchingPort(Predicate<ContainerPortBuilder> predicate) {
        for (ContainerPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ContainerResizePolicy buildMatchingResizePolicy(Predicate<ContainerResizePolicyBuilder> predicate) {
        for (ContainerResizePolicyBuilder item : this.resizePolicy) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ContainerRestartRule buildMatchingRestartPolicyRule(Predicate<ContainerRestartRuleBuilder> predicate) {
        for (ContainerRestartRuleBuilder item : this.restartPolicyRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public VolumeDevice buildMatchingVolumeDevice(Predicate<VolumeDeviceBuilder> predicate) {
        for (VolumeDeviceBuilder item : this.volumeDevices) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public VolumeMount buildMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        for (VolumeMountBuilder item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ContainerPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    public List<ContainerPort> buildPorts() {
        return this.ports != null ? EphemeralContainerFluent.build(this.ports) : null;
    }

    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    public List<ContainerResizePolicy> buildResizePolicy() {
        return this.resizePolicy != null ? EphemeralContainerFluent.build(this.resizePolicy) : null;
    }

    public ContainerResizePolicy buildResizePolicy(int index) {
        return this.resizePolicy.get(index).build();
    }

    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public ContainerRestartRule buildRestartPolicyRule(int index) {
        return this.restartPolicyRules.get(index).build();
    }

    public List<ContainerRestartRule> buildRestartPolicyRules() {
        return this.restartPolicyRules != null ? EphemeralContainerFluent.build(this.restartPolicyRules) : null;
    }

    public SecurityContext buildSecurityContext() {
        return this.securityContext != null ? this.securityContext.build() : null;
    }

    public Probe buildStartupProbe() {
        return this.startupProbe != null ? this.startupProbe.build() : null;
    }

    public VolumeDevice buildVolumeDevice(int index) {
        return this.volumeDevices.get(index).build();
    }

    public List<VolumeDevice> buildVolumeDevices() {
        return this.volumeDevices != null ? EphemeralContainerFluent.build(this.volumeDevices) : null;
    }

    public VolumeMount buildVolumeMount(int index) {
        return this.volumeMounts.get(index).build();
    }

    public List<VolumeMount> buildVolumeMounts() {
        return this.volumeMounts != null ? EphemeralContainerFluent.build(this.volumeMounts) : null;
    }

    protected void copyInstance(EphemeralContainer instance) {
        EphemeralContainer ephemeralContainer = instance = instance != null ? instance : new EphemeralContainer();
        if (instance != null) {
            this.withArgs(instance.getArgs());
            this.withCommand(instance.getCommand());
            this.withEnv(instance.getEnv());
            this.withEnvFrom(instance.getEnvFrom());
            this.withImage(instance.getImage());
            this.withImagePullPolicy(instance.getImagePullPolicy());
            this.withLifecycle(instance.getLifecycle());
            this.withLivenessProbe(instance.getLivenessProbe());
            this.withName(instance.getName());
            this.withPorts(instance.getPorts());
            this.withReadinessProbe(instance.getReadinessProbe());
            this.withResizePolicy(instance.getResizePolicy());
            this.withResources(instance.getResources());
            this.withRestartPolicy(instance.getRestartPolicy());
            this.withRestartPolicyRules(instance.getRestartPolicyRules());
            this.withSecurityContext(instance.getSecurityContext());
            this.withStartupProbe(instance.getStartupProbe());
            this.withStdin(instance.getStdin());
            this.withStdinOnce(instance.getStdinOnce());
            this.withTargetContainerName(instance.getTargetContainerName());
            this.withTerminationMessagePath(instance.getTerminationMessagePath());
            this.withTerminationMessagePolicy(instance.getTerminationMessagePolicy());
            this.withTty(instance.getTty());
            this.withVolumeDevices(instance.getVolumeDevices());
            this.withVolumeMounts(instance.getVolumeMounts());
            this.withWorkingDir(instance.getWorkingDir());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "env"));
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvFromNested<A> editEnvFrom(int index) {
        if (this.envFrom.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "envFrom"));
        }
        return this.setNewEnvFromLike(index, this.buildEnvFrom(index));
    }

    public EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "env"));
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    public EnvFromNested<A> editFirstEnvFrom() {
        if (this.envFrom.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "envFrom"));
        }
        return this.setNewEnvFromLike(0, this.buildEnvFrom(0));
    }

    public PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "ports"));
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    public ResizePolicyNested<A> editFirstResizePolicy() {
        if (this.resizePolicy.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "resizePolicy"));
        }
        return this.setNewResizePolicyLike(0, this.buildResizePolicy(0));
    }

    public RestartPolicyRulesNested<A> editFirstRestartPolicyRule() {
        if (this.restartPolicyRules.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "restartPolicyRules"));
        }
        return this.setNewRestartPolicyRuleLike(0, this.buildRestartPolicyRule(0));
    }

    public VolumeDevicesNested<A> editFirstVolumeDevice() {
        if (this.volumeDevices.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "volumeDevices"));
        }
        return this.setNewVolumeDeviceLike(0, this.buildVolumeDevice(0));
    }

    public VolumeMountsNested<A> editFirstVolumeMount() {
        if (this.volumeMounts.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "volumeMounts"));
        }
        return this.setNewVolumeMountLike(0, this.buildVolumeMount(0));
    }

    public EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "env"));
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvFromNested<A> editLastEnvFrom() {
        int index = this.envFrom.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "envFrom"));
        }
        return this.setNewEnvFromLike(index, this.buildEnvFrom(index));
    }

    public PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "ports"));
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public ResizePolicyNested<A> editLastResizePolicy() {
        int index = this.resizePolicy.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "resizePolicy"));
        }
        return this.setNewResizePolicyLike(index, this.buildResizePolicy(index));
    }

    public RestartPolicyRulesNested<A> editLastRestartPolicyRule() {
        int index = this.restartPolicyRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "restartPolicyRules"));
        }
        return this.setNewRestartPolicyRuleLike(index, this.buildRestartPolicyRule(index));
    }

    public VolumeDevicesNested<A> editLastVolumeDevice() {
        int index = this.volumeDevices.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "volumeDevices"));
        }
        return this.setNewVolumeDeviceLike(index, this.buildVolumeDevice(index));
    }

    public VolumeMountsNested<A> editLastVolumeMount() {
        int index = this.volumeMounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "volumeMounts"));
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    public LifecycleNested<A> editLifecycle() {
        return this.withNewLifecycleLike(Optional.ofNullable(this.buildLifecycle()).orElse(null));
    }

    public LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(null));
    }

    public EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.test(this.env.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "env"));
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvFromNested<A> editMatchingEnvFrom(Predicate<EnvFromSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.envFrom.size(); ++i) {
            if (!predicate.test(this.envFrom.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "envFrom"));
        }
        return this.setNewEnvFromLike(index, this.buildEnvFrom(index));
    }

    public PortsNested<A> editMatchingPort(Predicate<ContainerPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "ports"));
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public ResizePolicyNested<A> editMatchingResizePolicy(Predicate<ContainerResizePolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resizePolicy.size(); ++i) {
            if (!predicate.test(this.resizePolicy.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "resizePolicy"));
        }
        return this.setNewResizePolicyLike(index, this.buildResizePolicy(index));
    }

    public RestartPolicyRulesNested<A> editMatchingRestartPolicyRule(Predicate<ContainerRestartRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.restartPolicyRules.size(); ++i) {
            if (!predicate.test(this.restartPolicyRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "restartPolicyRules"));
        }
        return this.setNewRestartPolicyRuleLike(index, this.buildRestartPolicyRule(index));
    }

    public VolumeDevicesNested<A> editMatchingVolumeDevice(Predicate<VolumeDeviceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeDevices.size(); ++i) {
            if (!predicate.test(this.volumeDevices.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "volumeDevices"));
        }
        return this.setNewVolumeDeviceLike(index, this.buildVolumeDevice(index));
    }

    public VolumeMountsNested<A> editMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeMounts.size(); ++i) {
            if (!predicate.test(this.volumeMounts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "volumeMounts"));
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    public LifecycleNested<A> editOrNewLifecycle() {
        return this.withNewLifecycleLike(Optional.ofNullable(this.buildLifecycle()).orElse(new LifecycleBuilder().build()));
    }

    public LifecycleNested<A> editOrNewLifecycleLike(Lifecycle item) {
        return this.withNewLifecycleLike(Optional.ofNullable(this.buildLifecycle()).orElse(item));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(new ProbeBuilder().build()));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(item));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(new ProbeBuilder().build()));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(item));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public SecurityContextNested<A> editOrNewSecurityContext() {
        return this.withNewSecurityContextLike(Optional.ofNullable(this.buildSecurityContext()).orElse(new SecurityContextBuilder().build()));
    }

    public SecurityContextNested<A> editOrNewSecurityContextLike(SecurityContext item) {
        return this.withNewSecurityContextLike(Optional.ofNullable(this.buildSecurityContext()).orElse(item));
    }

    public StartupProbeNested<A> editOrNewStartupProbe() {
        return this.withNewStartupProbeLike(Optional.ofNullable(this.buildStartupProbe()).orElse(new ProbeBuilder().build()));
    }

    public StartupProbeNested<A> editOrNewStartupProbeLike(Probe item) {
        return this.withNewStartupProbeLike(Optional.ofNullable(this.buildStartupProbe()).orElse(item));
    }

    public PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "ports"));
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(null));
    }

    public ResizePolicyNested<A> editResizePolicy(int index) {
        if (this.resizePolicy.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "resizePolicy"));
        }
        return this.setNewResizePolicyLike(index, this.buildResizePolicy(index));
    }

    public ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public RestartPolicyRulesNested<A> editRestartPolicyRule(int index) {
        if (this.restartPolicyRules.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "restartPolicyRules"));
        }
        return this.setNewRestartPolicyRuleLike(index, this.buildRestartPolicyRule(index));
    }

    public SecurityContextNested<A> editSecurityContext() {
        return this.withNewSecurityContextLike(Optional.ofNullable(this.buildSecurityContext()).orElse(null));
    }

    public StartupProbeNested<A> editStartupProbe() {
        return this.withNewStartupProbeLike(Optional.ofNullable(this.buildStartupProbe()).orElse(null));
    }

    public VolumeDevicesNested<A> editVolumeDevice(int index) {
        if (this.volumeDevices.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "volumeDevices"));
        }
        return this.setNewVolumeDeviceLike(index, this.buildVolumeDevice(index));
    }

    public VolumeMountsNested<A> editVolumeMount(int index) {
        if (this.volumeMounts.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "volumeMounts"));
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EphemeralContainerFluent that = (EphemeralContainerFluent)((Object)o);
        if (!Objects.equals(this.args, that.args)) {
            return false;
        }
        if (!Objects.equals(this.command, that.command)) {
            return false;
        }
        if (!Objects.equals(this.env, that.env)) {
            return false;
        }
        if (!Objects.equals(this.envFrom, that.envFrom)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.imagePullPolicy, that.imagePullPolicy)) {
            return false;
        }
        if (!Objects.equals((Object)this.lifecycle, (Object)that.lifecycle)) {
            return false;
        }
        if (!Objects.equals((Object)this.livenessProbe, (Object)that.livenessProbe)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.ports, that.ports)) {
            return false;
        }
        if (!Objects.equals((Object)this.readinessProbe, (Object)that.readinessProbe)) {
            return false;
        }
        if (!Objects.equals(this.resizePolicy, that.resizePolicy)) {
            return false;
        }
        if (!Objects.equals((Object)this.resources, (Object)that.resources)) {
            return false;
        }
        if (!Objects.equals(this.restartPolicy, that.restartPolicy)) {
            return false;
        }
        if (!Objects.equals(this.restartPolicyRules, that.restartPolicyRules)) {
            return false;
        }
        if (!Objects.equals((Object)this.securityContext, (Object)that.securityContext)) {
            return false;
        }
        if (!Objects.equals((Object)this.startupProbe, (Object)that.startupProbe)) {
            return false;
        }
        if (!Objects.equals(this.stdin, that.stdin)) {
            return false;
        }
        if (!Objects.equals(this.stdinOnce, that.stdinOnce)) {
            return false;
        }
        if (!Objects.equals(this.targetContainerName, that.targetContainerName)) {
            return false;
        }
        if (!Objects.equals(this.terminationMessagePath, that.terminationMessagePath)) {
            return false;
        }
        if (!Objects.equals(this.terminationMessagePolicy, that.terminationMessagePolicy)) {
            return false;
        }
        if (!Objects.equals(this.tty, that.tty)) {
            return false;
        }
        if (!Objects.equals(this.volumeDevices, that.volumeDevices)) {
            return false;
        }
        if (!Objects.equals(this.volumeMounts, that.volumeMounts)) {
            return false;
        }
        if (!Objects.equals(this.workingDir, that.workingDir)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getArg(int index) {
        return this.args.get(index);
    }

    public List<String> getArgs() {
        return this.args;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public String getCommand(int index) {
        return this.command.get(index);
    }

    public String getFirstArg() {
        return this.args.get(0);
    }

    public String getFirstCommand() {
        return this.command.get(0);
    }

    public String getImage() {
        return this.image;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public String getLastArg() {
        return this.args.get(this.args.size() - 1);
    }

    public String getLastCommand() {
        return this.command.get(this.command.size() - 1);
    }

    public String getMatchingArg(Predicate<String> predicate) {
        for (String item : this.args) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public Boolean getStdin() {
        return this.stdin;
    }

    public Boolean getStdinOnce() {
        return this.stdinOnce;
    }

    public String getTargetContainerName() {
        return this.targetContainerName;
    }

    public String getTerminationMessagePath() {
        return this.terminationMessagePath;
    }

    public String getTerminationMessagePolicy() {
        return this.terminationMessagePolicy;
    }

    public Boolean getTty() {
        return this.tty;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasArgs() {
        return this.args != null && !this.args.isEmpty();
    }

    public boolean hasCommand() {
        return this.command != null && !this.command.isEmpty();
    }

    public boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    public boolean hasEnvFrom() {
        return this.envFrom != null && !this.envFrom.isEmpty();
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public boolean hasImagePullPolicy() {
        return this.imagePullPolicy != null;
    }

    public boolean hasLifecycle() {
        return this.lifecycle != null;
    }

    public boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public boolean hasMatchingArg(Predicate<String> predicate) {
        for (String item : this.args) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingEnvFrom(Predicate<EnvFromSourceBuilder> predicate) {
        for (EnvFromSourceBuilder item : this.envFrom) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingPort(Predicate<ContainerPortBuilder> predicate) {
        for (ContainerPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingResizePolicy(Predicate<ContainerResizePolicyBuilder> predicate) {
        for (ContainerResizePolicyBuilder item : this.resizePolicy) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingRestartPolicyRule(Predicate<ContainerRestartRuleBuilder> predicate) {
        for (ContainerRestartRuleBuilder item : this.restartPolicyRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingVolumeDevice(Predicate<VolumeDeviceBuilder> predicate) {
        for (VolumeDeviceBuilder item : this.volumeDevices) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        for (VolumeMountBuilder item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    public boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public boolean hasResizePolicy() {
        return this.resizePolicy != null && !this.resizePolicy.isEmpty();
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public boolean hasRestartPolicy() {
        return this.restartPolicy != null;
    }

    public boolean hasRestartPolicyRules() {
        return this.restartPolicyRules != null && !this.restartPolicyRules.isEmpty();
    }

    public boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    public boolean hasStartupProbe() {
        return this.startupProbe != null;
    }

    public boolean hasStdin() {
        return this.stdin != null;
    }

    public boolean hasStdinOnce() {
        return this.stdinOnce != null;
    }

    public boolean hasTargetContainerName() {
        return this.targetContainerName != null;
    }

    public boolean hasTerminationMessagePath() {
        return this.terminationMessagePath != null;
    }

    public boolean hasTerminationMessagePolicy() {
        return this.terminationMessagePolicy != null;
    }

    public boolean hasTty() {
        return this.tty != null;
    }

    public boolean hasVolumeDevices() {
        return this.volumeDevices != null && !this.volumeDevices.isEmpty();
    }

    public boolean hasVolumeMounts() {
        return this.volumeMounts != null && !this.volumeMounts.isEmpty();
    }

    public boolean hasWorkingDir() {
        return this.workingDir != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.args, this.command, this.env, this.envFrom, this.image, this.imagePullPolicy, this.lifecycle, this.livenessProbe, this.name, this.ports, this.readinessProbe, this.resizePolicy, this.resources, this.restartPolicy, this.restartPolicyRules, this.securityContext, this.startupProbe, this.stdin, this.stdinOnce, this.targetContainerName, this.terminationMessagePath, this.terminationMessagePolicy, this.tty, this.volumeDevices, this.volumeMounts, this.workingDir, this.additionalProperties});
    }

    public A removeAllFromArgs(Collection<String> items) {
        if (this.args == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.args.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCommand(Collection<String> items) {
        if (this.command == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").remove((Object)builder);
            this.env.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEnvFrom(Collection<EnvFromSource> items) {
        if (this.envFrom == null) {
            return (A)((Object)this);
        }
        for (EnvFromSource item : items) {
            EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
            this._visitables.get((Object)"envFrom").remove((Object)builder);
            this.envFrom.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPorts(Collection<ContainerPort> items) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        for (ContainerPort item : items) {
            ContainerPortBuilder builder = new ContainerPortBuilder(item);
            this._visitables.get((Object)"ports").remove((Object)builder);
            this.ports.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResizePolicy(Collection<ContainerResizePolicy> items) {
        if (this.resizePolicy == null) {
            return (A)((Object)this);
        }
        for (ContainerResizePolicy item : items) {
            ContainerResizePolicyBuilder builder = new ContainerResizePolicyBuilder(item);
            this._visitables.get((Object)"resizePolicy").remove((Object)builder);
            this.resizePolicy.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRestartPolicyRules(Collection<ContainerRestartRule> items) {
        if (this.restartPolicyRules == null) {
            return (A)((Object)this);
        }
        for (ContainerRestartRule item : items) {
            ContainerRestartRuleBuilder builder = new ContainerRestartRuleBuilder(item);
            this._visitables.get((Object)"restartPolicyRules").remove((Object)builder);
            this.restartPolicyRules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumeDevices(Collection<VolumeDevice> items) {
        if (this.volumeDevices == null) {
            return (A)((Object)this);
        }
        for (VolumeDevice item : items) {
            VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);
            this._visitables.get((Object)"volumeDevices").remove((Object)builder);
            this.volumeDevices.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {
            return (A)((Object)this);
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get((Object)"volumeMounts").remove((Object)builder);
            this.volumeMounts.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromArgs(String ... items) {
        if (this.args == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.args.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCommand(String ... items) {
        if (this.command == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromEnv(EnvVar ... items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").remove((Object)builder);
            this.env.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEnvFrom(EnvFromSource ... items) {
        if (this.envFrom == null) {
            return (A)((Object)this);
        }
        for (EnvFromSource item : items) {
            EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
            this._visitables.get((Object)"envFrom").remove((Object)builder);
            this.envFrom.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPorts(ContainerPort ... items) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        for (ContainerPort item : items) {
            ContainerPortBuilder builder = new ContainerPortBuilder(item);
            this._visitables.get((Object)"ports").remove((Object)builder);
            this.ports.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromResizePolicy(ContainerResizePolicy ... items) {
        if (this.resizePolicy == null) {
            return (A)((Object)this);
        }
        for (ContainerResizePolicy item : items) {
            ContainerResizePolicyBuilder builder = new ContainerResizePolicyBuilder(item);
            this._visitables.get((Object)"resizePolicy").remove((Object)builder);
            this.resizePolicy.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRestartPolicyRules(ContainerRestartRule ... items) {
        if (this.restartPolicyRules == null) {
            return (A)((Object)this);
        }
        for (ContainerRestartRule item : items) {
            ContainerRestartRuleBuilder builder = new ContainerRestartRuleBuilder(item);
            this._visitables.get((Object)"restartPolicyRules").remove((Object)builder);
            this.restartPolicyRules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumeDevices(VolumeDevice ... items) {
        if (this.volumeDevices == null) {
            return (A)((Object)this);
        }
        for (VolumeDevice item : items) {
            VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);
            this._visitables.get((Object)"volumeDevices").remove((Object)builder);
            this.volumeDevices.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumeMounts(VolumeMount ... items) {
        if (this.volumeMounts == null) {
            return (A)((Object)this);
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get((Object)"volumeMounts").remove((Object)builder);
            this.volumeMounts.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEnv(Predicate<EnvVarBuilder> predicate) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        Iterator<EnvVarBuilder> each = this.env.iterator();
        List visitables = this._visitables.get((Object)"env");
        while (each.hasNext()) {
            EnvVarBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEnvFrom(Predicate<EnvFromSourceBuilder> predicate) {
        if (this.envFrom == null) {
            return (A)((Object)this);
        }
        Iterator<EnvFromSourceBuilder> each = this.envFrom.iterator();
        List visitables = this._visitables.get((Object)"envFrom");
        while (each.hasNext()) {
            EnvFromSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPorts(Predicate<ContainerPortBuilder> predicate) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        Iterator<ContainerPortBuilder> each = this.ports.iterator();
        List visitables = this._visitables.get((Object)"ports");
        while (each.hasNext()) {
            ContainerPortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromResizePolicy(Predicate<ContainerResizePolicyBuilder> predicate) {
        if (this.resizePolicy == null) {
            return (A)((Object)this);
        }
        Iterator<ContainerResizePolicyBuilder> each = this.resizePolicy.iterator();
        List visitables = this._visitables.get((Object)"resizePolicy");
        while (each.hasNext()) {
            ContainerResizePolicyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRestartPolicyRules(Predicate<ContainerRestartRuleBuilder> predicate) {
        if (this.restartPolicyRules == null) {
            return (A)((Object)this);
        }
        Iterator<ContainerRestartRuleBuilder> each = this.restartPolicyRules.iterator();
        List visitables = this._visitables.get((Object)"restartPolicyRules");
        while (each.hasNext()) {
            ContainerRestartRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromVolumeDevices(Predicate<VolumeDeviceBuilder> predicate) {
        if (this.volumeDevices == null) {
            return (A)((Object)this);
        }
        Iterator<VolumeDeviceBuilder> each = this.volumeDevices.iterator();
        List visitables = this._visitables.get((Object)"volumeDevices");
        while (each.hasNext()) {
            VolumeDeviceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromVolumeMounts(Predicate<VolumeMountBuilder> predicate) {
        if (this.volumeMounts == null) {
            return (A)((Object)this);
        }
        Iterator<VolumeMountBuilder> each = this.volumeMounts.iterator();
        List visitables = this._visitables.get((Object)"volumeMounts");
        while (each.hasNext()) {
            VolumeMountBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public EnvFromNested<A> setNewEnvFromLike(int index, EnvFromSource item) {
        return new EnvFromNested(index, item);
    }

    public EnvNested<A> setNewEnvLike(int index, EnvVar item) {
        return new EnvNested(index, item);
    }

    public PortsNested<A> setNewPortLike(int index, ContainerPort item) {
        return new PortsNested(index, item);
    }

    public ResizePolicyNested<A> setNewResizePolicyLike(int index, ContainerResizePolicy item) {
        return new ResizePolicyNested(index, item);
    }

    public RestartPolicyRulesNested<A> setNewRestartPolicyRuleLike(int index, ContainerRestartRule item) {
        return new RestartPolicyRulesNested(index, item);
    }

    public VolumeDevicesNested<A> setNewVolumeDeviceLike(int index, VolumeDevice item) {
        return new VolumeDevicesNested(index, item);
    }

    public VolumeMountsNested<A> setNewVolumeMountLike(int index, VolumeMount item) {
        return new VolumeMountsNested(index, item);
    }

    public A setToArgs(int index, String item) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.set(index, item);
        return (A)((Object)this);
    }

    public A setToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.set(index, item);
        return (A)((Object)this);
    }

    public A setToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").add(builder);
            this.env.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEnvFrom(int index, EnvFromSource item) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList();
        }
        EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
        if (index < 0 || index >= this.envFrom.size()) {
            this._visitables.get((Object)"envFrom").add(builder);
            this.envFrom.add(builder);
        } else {
            this._visitables.get((Object)"envFrom").add(builder);
            this.envFrom.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPorts(int index, ContainerPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        ContainerPortBuilder builder = new ContainerPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToResizePolicy(int index, ContainerResizePolicy item) {
        if (this.resizePolicy == null) {
            this.resizePolicy = new ArrayList();
        }
        ContainerResizePolicyBuilder builder = new ContainerResizePolicyBuilder(item);
        if (index < 0 || index >= this.resizePolicy.size()) {
            this._visitables.get((Object)"resizePolicy").add(builder);
            this.resizePolicy.add(builder);
        } else {
            this._visitables.get((Object)"resizePolicy").add(builder);
            this.resizePolicy.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRestartPolicyRules(int index, ContainerRestartRule item) {
        if (this.restartPolicyRules == null) {
            this.restartPolicyRules = new ArrayList();
        }
        ContainerRestartRuleBuilder builder = new ContainerRestartRuleBuilder(item);
        if (index < 0 || index >= this.restartPolicyRules.size()) {
            this._visitables.get((Object)"restartPolicyRules").add(builder);
            this.restartPolicyRules.add(builder);
        } else {
            this._visitables.get((Object)"restartPolicyRules").add(builder);
            this.restartPolicyRules.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToVolumeDevices(int index, VolumeDevice item) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList();
        }
        VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);
        if (index < 0 || index >= this.volumeDevices.size()) {
            this._visitables.get((Object)"volumeDevices").add(builder);
            this.volumeDevices.add(builder);
        } else {
            this._visitables.get((Object)"volumeDevices").add(builder);
            this.volumeDevices.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        VolumeMountBuilder builder = new VolumeMountBuilder(item);
        if (index < 0 || index >= this.volumeMounts.size()) {
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        } else {
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.args != null && !this.args.isEmpty()) {
            sb.append("args:");
            sb.append(this.args);
            sb.append(",");
        }
        if (this.command != null && !this.command.isEmpty()) {
            sb.append("command:");
            sb.append(this.command);
            sb.append(",");
        }
        if (this.env != null && !this.env.isEmpty()) {
            sb.append("env:");
            sb.append(this.env);
            sb.append(",");
        }
        if (this.envFrom != null && !this.envFrom.isEmpty()) {
            sb.append("envFrom:");
            sb.append(this.envFrom);
            sb.append(",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image);
            sb.append(",");
        }
        if (this.imagePullPolicy != null) {
            sb.append("imagePullPolicy:");
            sb.append(this.imagePullPolicy);
            sb.append(",");
        }
        if (this.lifecycle != null) {
            sb.append("lifecycle:");
            sb.append((Object)this.lifecycle);
            sb.append(",");
        }
        if (this.livenessProbe != null) {
            sb.append("livenessProbe:");
            sb.append((Object)this.livenessProbe);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(this.ports);
            sb.append(",");
        }
        if (this.readinessProbe != null) {
            sb.append("readinessProbe:");
            sb.append((Object)this.readinessProbe);
            sb.append(",");
        }
        if (this.resizePolicy != null && !this.resizePolicy.isEmpty()) {
            sb.append("resizePolicy:");
            sb.append(this.resizePolicy);
            sb.append(",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append((Object)this.resources);
            sb.append(",");
        }
        if (this.restartPolicy != null) {
            sb.append("restartPolicy:");
            sb.append(this.restartPolicy);
            sb.append(",");
        }
        if (this.restartPolicyRules != null && !this.restartPolicyRules.isEmpty()) {
            sb.append("restartPolicyRules:");
            sb.append(this.restartPolicyRules);
            sb.append(",");
        }
        if (this.securityContext != null) {
            sb.append("securityContext:");
            sb.append((Object)this.securityContext);
            sb.append(",");
        }
        if (this.startupProbe != null) {
            sb.append("startupProbe:");
            sb.append((Object)this.startupProbe);
            sb.append(",");
        }
        if (this.stdin != null) {
            sb.append("stdin:");
            sb.append(this.stdin);
            sb.append(",");
        }
        if (this.stdinOnce != null) {
            sb.append("stdinOnce:");
            sb.append(this.stdinOnce);
            sb.append(",");
        }
        if (this.targetContainerName != null) {
            sb.append("targetContainerName:");
            sb.append(this.targetContainerName);
            sb.append(",");
        }
        if (this.terminationMessagePath != null) {
            sb.append("terminationMessagePath:");
            sb.append(this.terminationMessagePath);
            sb.append(",");
        }
        if (this.terminationMessagePolicy != null) {
            sb.append("terminationMessagePolicy:");
            sb.append(this.terminationMessagePolicy);
            sb.append(",");
        }
        if (this.tty != null) {
            sb.append("tty:");
            sb.append(this.tty);
            sb.append(",");
        }
        if (this.volumeDevices != null && !this.volumeDevices.isEmpty()) {
            sb.append("volumeDevices:");
            sb.append(this.volumeDevices);
            sb.append(",");
        }
        if (this.volumeMounts != null && !this.volumeMounts.isEmpty()) {
            sb.append("volumeMounts:");
            sb.append(this.volumeMounts);
            sb.append(",");
        }
        if (this.workingDir != null) {
            sb.append("workingDir:");
            sb.append(this.workingDir);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withArgs(List<String> args) {
        if (args != null) {
            this.args = new ArrayList<String>();
            for (String item : args) {
                this.addToArgs(item);
            }
        } else {
            this.args = null;
        }
        return (A)((Object)this);
    }

    public A withArgs(String ... args) {
        if (this.args != null) {
            this.args.clear();
            this._visitables.remove((Object)"args");
        }
        if (args != null) {
            for (String item : args) {
                this.addToArgs(item);
            }
        }
        return (A)((Object)this);
    }

    public A withCommand(List<String> command) {
        if (command != null) {
            this.command = new ArrayList<String>();
            for (String item : command) {
                this.addToCommand(item);
            }
        } else {
            this.command = null;
        }
        return (A)((Object)this);
    }

    public A withCommand(String ... command) {
        if (this.command != null) {
            this.command.clear();
            this._visitables.remove((Object)"command");
        }
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)((Object)this);
    }

    public A withEnv(List<EnvVar> env) {
        if (this.env != null) {
            this._visitables.get((Object)"env").clear();
        }
        if (env != null) {
            this.env = new ArrayList();
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)((Object)this);
    }

    public A withEnv(EnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
            this._visitables.remove((Object)"env");
        }
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)((Object)this);
    }

    public A withEnvFrom(List<EnvFromSource> envFrom) {
        if (this.envFrom != null) {
            this._visitables.get((Object)"envFrom").clear();
        }
        if (envFrom != null) {
            this.envFrom = new ArrayList();
            for (EnvFromSource item : envFrom) {
                this.addToEnvFrom(item);
            }
        } else {
            this.envFrom = null;
        }
        return (A)((Object)this);
    }

    public A withEnvFrom(EnvFromSource ... envFrom) {
        if (this.envFrom != null) {
            this.envFrom.clear();
            this._visitables.remove((Object)"envFrom");
        }
        if (envFrom != null) {
            for (EnvFromSource item : envFrom) {
                this.addToEnvFrom(item);
            }
        }
        return (A)((Object)this);
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public A withImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (A)((Object)this);
    }

    public A withLifecycle(Lifecycle lifecycle) {
        this._visitables.remove((Object)"lifecycle");
        if (lifecycle != null) {
            this.lifecycle = new LifecycleBuilder(lifecycle);
            this._visitables.get((Object)"lifecycle").add(this.lifecycle);
        } else {
            this.lifecycle = null;
            this._visitables.get((Object)"lifecycle").remove((Object)this.lifecycle);
        }
        return (A)((Object)this);
    }

    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.remove((Object)"livenessProbe");
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.get((Object)"livenessProbe").add(this.livenessProbe);
        } else {
            this.livenessProbe = null;
            this._visitables.get((Object)"livenessProbe").remove((Object)this.livenessProbe);
        }
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public LifecycleNested<A> withNewLifecycle() {
        return new LifecycleNested(null);
    }

    public LifecycleNested<A> withNewLifecycleLike(Lifecycle item) {
        return new LifecycleNested(item);
    }

    public LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNested(null);
    }

    public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNested(item);
    }

    public ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNested(null);
    }

    public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNested(item);
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNested(item);
    }

    public SecurityContextNested<A> withNewSecurityContext() {
        return new SecurityContextNested(null);
    }

    public SecurityContextNested<A> withNewSecurityContextLike(SecurityContext item) {
        return new SecurityContextNested(item);
    }

    public StartupProbeNested<A> withNewStartupProbe() {
        return new StartupProbeNested(null);
    }

    public StartupProbeNested<A> withNewStartupProbeLike(Probe item) {
        return new StartupProbeNested(item);
    }

    public A withPorts(List<ContainerPort> ports) {
        if (this.ports != null) {
            this._visitables.get((Object)"ports").clear();
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (ContainerPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)((Object)this);
    }

    public A withPorts(ContainerPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
            this._visitables.remove((Object)"ports");
        }
        if (ports != null) {
            for (ContainerPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)((Object)this);
    }

    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.remove((Object)"readinessProbe");
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.get((Object)"readinessProbe").add(this.readinessProbe);
        } else {
            this.readinessProbe = null;
            this._visitables.get((Object)"readinessProbe").remove((Object)this.readinessProbe);
        }
        return (A)((Object)this);
    }

    public A withResizePolicy(List<ContainerResizePolicy> resizePolicy) {
        if (this.resizePolicy != null) {
            this._visitables.get((Object)"resizePolicy").clear();
        }
        if (resizePolicy != null) {
            this.resizePolicy = new ArrayList();
            for (ContainerResizePolicy item : resizePolicy) {
                this.addToResizePolicy(item);
            }
        } else {
            this.resizePolicy = null;
        }
        return (A)((Object)this);
    }

    public A withResizePolicy(ContainerResizePolicy ... resizePolicy) {
        if (this.resizePolicy != null) {
            this.resizePolicy.clear();
            this._visitables.remove((Object)"resizePolicy");
        }
        if (resizePolicy != null) {
            for (ContainerResizePolicy item : resizePolicy) {
                this.addToResizePolicy(item);
            }
        }
        return (A)((Object)this);
    }

    public A withResources(ResourceRequirements resources) {
        this._visitables.remove((Object)"resources");
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get((Object)"resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get((Object)"resources").remove((Object)this.resources);
        }
        return (A)((Object)this);
    }

    public A withRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return (A)((Object)this);
    }

    public A withRestartPolicyRules(List<ContainerRestartRule> restartPolicyRules) {
        if (this.restartPolicyRules != null) {
            this._visitables.get((Object)"restartPolicyRules").clear();
        }
        if (restartPolicyRules != null) {
            this.restartPolicyRules = new ArrayList();
            for (ContainerRestartRule item : restartPolicyRules) {
                this.addToRestartPolicyRules(item);
            }
        } else {
            this.restartPolicyRules = null;
        }
        return (A)((Object)this);
    }

    public A withRestartPolicyRules(ContainerRestartRule ... restartPolicyRules) {
        if (this.restartPolicyRules != null) {
            this.restartPolicyRules.clear();
            this._visitables.remove((Object)"restartPolicyRules");
        }
        if (restartPolicyRules != null) {
            for (ContainerRestartRule item : restartPolicyRules) {
                this.addToRestartPolicyRules(item);
            }
        }
        return (A)((Object)this);
    }

    public A withSecurityContext(SecurityContext securityContext) {
        this._visitables.remove((Object)"securityContext");
        if (securityContext != null) {
            this.securityContext = new SecurityContextBuilder(securityContext);
            this._visitables.get((Object)"securityContext").add(this.securityContext);
        } else {
            this.securityContext = null;
            this._visitables.get((Object)"securityContext").remove((Object)this.securityContext);
        }
        return (A)((Object)this);
    }

    public A withStartupProbe(Probe startupProbe) {
        this._visitables.remove((Object)"startupProbe");
        if (startupProbe != null) {
            this.startupProbe = new ProbeBuilder(startupProbe);
            this._visitables.get((Object)"startupProbe").add(this.startupProbe);
        } else {
            this.startupProbe = null;
            this._visitables.get((Object)"startupProbe").remove((Object)this.startupProbe);
        }
        return (A)((Object)this);
    }

    public A withStdin() {
        return this.withStdin(true);
    }

    public A withStdin(Boolean stdin) {
        this.stdin = stdin;
        return (A)((Object)this);
    }

    public A withStdinOnce() {
        return this.withStdinOnce(true);
    }

    public A withStdinOnce(Boolean stdinOnce) {
        this.stdinOnce = stdinOnce;
        return (A)((Object)this);
    }

    public A withTargetContainerName(String targetContainerName) {
        this.targetContainerName = targetContainerName;
        return (A)((Object)this);
    }

    public A withTerminationMessagePath(String terminationMessagePath) {
        this.terminationMessagePath = terminationMessagePath;
        return (A)((Object)this);
    }

    public A withTerminationMessagePolicy(String terminationMessagePolicy) {
        this.terminationMessagePolicy = terminationMessagePolicy;
        return (A)((Object)this);
    }

    public A withTty() {
        return this.withTty(true);
    }

    public A withTty(Boolean tty) {
        this.tty = tty;
        return (A)((Object)this);
    }

    public A withVolumeDevices(List<VolumeDevice> volumeDevices) {
        if (this.volumeDevices != null) {
            this._visitables.get((Object)"volumeDevices").clear();
        }
        if (volumeDevices != null) {
            this.volumeDevices = new ArrayList();
            for (VolumeDevice item : volumeDevices) {
                this.addToVolumeDevices(item);
            }
        } else {
            this.volumeDevices = null;
        }
        return (A)((Object)this);
    }

    public A withVolumeDevices(VolumeDevice ... volumeDevices) {
        if (this.volumeDevices != null) {
            this.volumeDevices.clear();
            this._visitables.remove((Object)"volumeDevices");
        }
        if (volumeDevices != null) {
            for (VolumeDevice item : volumeDevices) {
                this.addToVolumeDevices(item);
            }
        }
        return (A)((Object)this);
    }

    public A withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (this.volumeMounts != null) {
            this._visitables.get((Object)"volumeMounts").clear();
        }
        if (volumeMounts != null) {
            this.volumeMounts = new ArrayList();
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        } else {
            this.volumeMounts = null;
        }
        return (A)((Object)this);
    }

    public A withVolumeMounts(VolumeMount ... volumeMounts) {
        if (this.volumeMounts != null) {
            this.volumeMounts.clear();
            this._visitables.remove((Object)"volumeMounts");
        }
        if (volumeMounts != null) {
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (A)((Object)this);
    }

    public A withWorkingDir(String workingDir) {
        this.workingDir = workingDir;
        return (A)((Object)this);
    }

    public class VolumeMountsNested<N>
    extends VolumeMountFluent<VolumeMountsNested<N>>
    implements Nested<N> {
        VolumeMountBuilder builder;
        int index;

        VolumeMountsNested(int index, VolumeMount item) {
            this.index = index;
            this.builder = new VolumeMountBuilder(this, item);
        }

        public N and() {
            return (N)EphemeralContainerFluent.this.setToVolumeMounts(this.index, this.builder.build());
        }

        public N endVolumeMount() {
            return this.and();
        }
    }

    public class VolumeDevicesNested<N>
    extends VolumeDeviceFluent<VolumeDevicesNested<N>>
    implements Nested<N> {
        VolumeDeviceBuilder builder;
        int index;

        VolumeDevicesNested(int index, VolumeDevice item) {
            this.index = index;
            this.builder = new VolumeDeviceBuilder(this, item);
        }

        public N and() {
            return (N)EphemeralContainerFluent.this.setToVolumeDevices(this.index, this.builder.build());
        }

        public N endVolumeDevice() {
            return this.and();
        }
    }

    public class StartupProbeNested<N>
    extends ProbeFluent<StartupProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        StartupProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)EphemeralContainerFluent.this.withStartupProbe(this.builder.build());
        }

        public N endStartupProbe() {
            return this.and();
        }
    }

    public class SecurityContextNested<N>
    extends SecurityContextFluent<SecurityContextNested<N>>
    implements Nested<N> {
        SecurityContextBuilder builder;

        SecurityContextNested(SecurityContext item) {
            this.builder = new SecurityContextBuilder(this, item);
        }

        public N and() {
            return (N)EphemeralContainerFluent.this.withSecurityContext(this.builder.build());
        }

        public N endSecurityContext() {
            return this.and();
        }
    }

    public class RestartPolicyRulesNested<N>
    extends ContainerRestartRuleFluent<RestartPolicyRulesNested<N>>
    implements Nested<N> {
        ContainerRestartRuleBuilder builder;
        int index;

        RestartPolicyRulesNested(int index, ContainerRestartRule item) {
            this.index = index;
            this.builder = new ContainerRestartRuleBuilder(this, item);
        }

        public N and() {
            return (N)EphemeralContainerFluent.this.setToRestartPolicyRules(this.index, this.builder.build());
        }

        public N endRestartPolicyRule() {
            return this.and();
        }
    }

    public class ResourcesNested<N>
    extends ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        ResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        public N and() {
            return (N)EphemeralContainerFluent.this.withResources(this.builder.build());
        }

        public N endResources() {
            return this.and();
        }
    }

    public class ResizePolicyNested<N>
    extends ContainerResizePolicyFluent<ResizePolicyNested<N>>
    implements Nested<N> {
        ContainerResizePolicyBuilder builder;
        int index;

        ResizePolicyNested(int index, ContainerResizePolicy item) {
            this.index = index;
            this.builder = new ContainerResizePolicyBuilder(this, item);
        }

        public N and() {
            return (N)EphemeralContainerFluent.this.setToResizePolicy(this.index, this.builder.build());
        }

        public N endResizePolicy() {
            return this.and();
        }
    }

    public class ReadinessProbeNested<N>
    extends ProbeFluent<ReadinessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        ReadinessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)EphemeralContainerFluent.this.withReadinessProbe(this.builder.build());
        }

        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class PortsNested<N>
    extends ContainerPortFluent<PortsNested<N>>
    implements Nested<N> {
        ContainerPortBuilder builder;
        int index;

        PortsNested(int index, ContainerPort item) {
            this.index = index;
            this.builder = new ContainerPortBuilder(this, item);
        }

        public N and() {
            return (N)EphemeralContainerFluent.this.setToPorts(this.index, this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }

    public class LivenessProbeNested<N>
    extends ProbeFluent<LivenessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        LivenessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)EphemeralContainerFluent.this.withLivenessProbe(this.builder.build());
        }

        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class LifecycleNested<N>
    extends LifecycleFluent<LifecycleNested<N>>
    implements Nested<N> {
        LifecycleBuilder builder;

        LifecycleNested(Lifecycle item) {
            this.builder = new LifecycleBuilder(this, item);
        }

        public N and() {
            return (N)EphemeralContainerFluent.this.withLifecycle(this.builder.build());
        }

        public N endLifecycle() {
            return this.and();
        }
    }

    public class EnvNested<N>
    extends EnvVarFluent<EnvNested<N>>
    implements Nested<N> {
        EnvVarBuilder builder;
        int index;

        EnvNested(int index, EnvVar item) {
            this.index = index;
            this.builder = new EnvVarBuilder(this, item);
        }

        public N and() {
            return (N)EphemeralContainerFluent.this.setToEnv(this.index, this.builder.build());
        }

        public N endEnv() {
            return this.and();
        }
    }

    public class EnvFromNested<N>
    extends EnvFromSourceFluent<EnvFromNested<N>>
    implements Nested<N> {
        EnvFromSourceBuilder builder;
        int index;

        EnvFromNested(int index, EnvFromSource item) {
            this.index = index;
            this.builder = new EnvFromSourceBuilder(this, item);
        }

        public N and() {
            return (N)EphemeralContainerFluent.this.setToEnvFrom(this.index, this.builder.build());
        }

        public N endEnvFrom() {
            return this.and();
        }
    }
}

