/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Cluster;
import io.fabric8.kubernetes.api.model.NamedExtension;
import io.fabric8.kubernetes.api.model.NamedExtensionBuilder;
import io.fabric8.kubernetes.api.model.NamedExtensionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterFluent<A extends ClusterFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String certificateAuthority;
    private String certificateAuthorityData;
    private Boolean disableCompression;
    private ArrayList<NamedExtensionBuilder> extensions = new ArrayList();
    private Boolean insecureSkipTlsVerify;
    private String proxyUrl;
    private String server;
    private String tlsServerName;

    public ClusterFluent() {
    }

    public ClusterFluent(Cluster instance) {
        this.copyInstance(instance);
    }

    public A addAllToExtensions(Collection<NamedExtension> items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList();
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get((Object)"extensions").add(builder);
            this.extensions.add(builder);
        }
        return (A)((Object)this);
    }

    public ExtensionsNested<A> addNewExtension() {
        return new ExtensionsNested(-1, null);
    }

    public A addNewExtension(Object extension, String name) {
        return this.addToExtensions(new NamedExtension(extension, name));
    }

    public ExtensionsNested<A> addNewExtensionLike(NamedExtension item) {
        return new ExtensionsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToExtensions(NamedExtension ... items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList();
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get((Object)"extensions").add(builder);
            this.extensions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToExtensions(int index, NamedExtension item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList();
        }
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
        if (index < 0 || index >= this.extensions.size()) {
            this._visitables.get((Object)"extensions").add(builder);
            this.extensions.add(builder);
        } else {
            this._visitables.get((Object)"extensions").add(builder);
            this.extensions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public NamedExtension buildExtension(int index) {
        return this.extensions.get(index).build();
    }

    public List<NamedExtension> buildExtensions() {
        return this.extensions != null ? ClusterFluent.build(this.extensions) : null;
    }

    public NamedExtension buildFirstExtension() {
        return this.extensions.get(0).build();
    }

    public NamedExtension buildLastExtension() {
        return this.extensions.get(this.extensions.size() - 1).build();
    }

    public NamedExtension buildMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        for (NamedExtensionBuilder item : this.extensions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(Cluster instance) {
        Cluster cluster = instance = instance != null ? instance : new Cluster();
        if (instance != null) {
            this.withCertificateAuthority(instance.getCertificateAuthority());
            this.withCertificateAuthorityData(instance.getCertificateAuthorityData());
            this.withDisableCompression(instance.getDisableCompression());
            this.withExtensions(instance.getExtensions());
            this.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify());
            this.withProxyUrl(instance.getProxyUrl());
            this.withServer(instance.getServer());
            this.withTlsServerName(instance.getTlsServerName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ExtensionsNested<A> editExtension(int index) {
        if (this.extensions.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "extensions"));
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    public ExtensionsNested<A> editFirstExtension() {
        if (this.extensions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "extensions"));
        }
        return this.setNewExtensionLike(0, this.buildExtension(0));
    }

    public ExtensionsNested<A> editLastExtension() {
        int index = this.extensions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "extensions"));
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    public ExtensionsNested<A> editMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.extensions.size(); ++i) {
            if (!predicate.test(this.extensions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "extensions"));
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterFluent that = (ClusterFluent)((Object)o);
        if (!Objects.equals(this.certificateAuthority, that.certificateAuthority)) {
            return false;
        }
        if (!Objects.equals(this.certificateAuthorityData, that.certificateAuthorityData)) {
            return false;
        }
        if (!Objects.equals(this.disableCompression, that.disableCompression)) {
            return false;
        }
        if (!Objects.equals(this.extensions, that.extensions)) {
            return false;
        }
        if (!Objects.equals(this.insecureSkipTlsVerify, that.insecureSkipTlsVerify)) {
            return false;
        }
        if (!Objects.equals(this.proxyUrl, that.proxyUrl)) {
            return false;
        }
        if (!Objects.equals(this.server, that.server)) {
            return false;
        }
        if (!Objects.equals(this.tlsServerName, that.tlsServerName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getCertificateAuthority() {
        return this.certificateAuthority;
    }

    public String getCertificateAuthorityData() {
        return this.certificateAuthorityData;
    }

    public Boolean getDisableCompression() {
        return this.disableCompression;
    }

    public Boolean getInsecureSkipTlsVerify() {
        return this.insecureSkipTlsVerify;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public String getServer() {
        return this.server;
    }

    public String getTlsServerName() {
        return this.tlsServerName;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCertificateAuthority() {
        return this.certificateAuthority != null;
    }

    public boolean hasCertificateAuthorityData() {
        return this.certificateAuthorityData != null;
    }

    public boolean hasDisableCompression() {
        return this.disableCompression != null;
    }

    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    public boolean hasInsecureSkipTlsVerify() {
        return this.insecureSkipTlsVerify != null;
    }

    public boolean hasMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        for (NamedExtensionBuilder item : this.extensions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasProxyUrl() {
        return this.proxyUrl != null;
    }

    public boolean hasServer() {
        return this.server != null;
    }

    public boolean hasTlsServerName() {
        return this.tlsServerName != null;
    }

    public int hashCode() {
        return Objects.hash(this.certificateAuthority, this.certificateAuthorityData, this.disableCompression, this.extensions, this.insecureSkipTlsVerify, this.proxyUrl, this.server, this.tlsServerName, this.additionalProperties);
    }

    public A removeAllFromExtensions(Collection<NamedExtension> items) {
        if (this.extensions == null) {
            return (A)((Object)this);
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get((Object)"extensions").remove((Object)builder);
            this.extensions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromExtensions(NamedExtension ... items) {
        if (this.extensions == null) {
            return (A)((Object)this);
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get((Object)"extensions").remove((Object)builder);
            this.extensions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromExtensions(Predicate<NamedExtensionBuilder> predicate) {
        if (this.extensions == null) {
            return (A)((Object)this);
        }
        Iterator<NamedExtensionBuilder> each = this.extensions.iterator();
        List visitables = this._visitables.get((Object)"extensions");
        while (each.hasNext()) {
            NamedExtensionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ExtensionsNested<A> setNewExtensionLike(int index, NamedExtension item) {
        return new ExtensionsNested(index, item);
    }

    public A setToExtensions(int index, NamedExtension item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList();
        }
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
        if (index < 0 || index >= this.extensions.size()) {
            this._visitables.get((Object)"extensions").add(builder);
            this.extensions.add(builder);
        } else {
            this._visitables.get((Object)"extensions").add(builder);
            this.extensions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.certificateAuthority != null) {
            sb.append("certificateAuthority:");
            sb.append(this.certificateAuthority);
            sb.append(",");
        }
        if (this.certificateAuthorityData != null) {
            sb.append("certificateAuthorityData:");
            sb.append(this.certificateAuthorityData);
            sb.append(",");
        }
        if (this.disableCompression != null) {
            sb.append("disableCompression:");
            sb.append(this.disableCompression);
            sb.append(",");
        }
        if (this.extensions != null && !this.extensions.isEmpty()) {
            sb.append("extensions:");
            sb.append(this.extensions);
            sb.append(",");
        }
        if (this.insecureSkipTlsVerify != null) {
            sb.append("insecureSkipTlsVerify:");
            sb.append(this.insecureSkipTlsVerify);
            sb.append(",");
        }
        if (this.proxyUrl != null) {
            sb.append("proxyUrl:");
            sb.append(this.proxyUrl);
            sb.append(",");
        }
        if (this.server != null) {
            sb.append("server:");
            sb.append(this.server);
            sb.append(",");
        }
        if (this.tlsServerName != null) {
            sb.append("tlsServerName:");
            sb.append(this.tlsServerName);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withCertificateAuthority(String certificateAuthority) {
        this.certificateAuthority = certificateAuthority;
        return (A)((Object)this);
    }

    public A withCertificateAuthorityData(String certificateAuthorityData) {
        this.certificateAuthorityData = certificateAuthorityData;
        return (A)((Object)this);
    }

    public A withDisableCompression() {
        return this.withDisableCompression(true);
    }

    public A withDisableCompression(Boolean disableCompression) {
        this.disableCompression = disableCompression;
        return (A)((Object)this);
    }

    public A withExtensions(List<NamedExtension> extensions) {
        if (this.extensions != null) {
            this._visitables.get((Object)"extensions").clear();
        }
        if (extensions != null) {
            this.extensions = new ArrayList();
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        } else {
            this.extensions = null;
        }
        return (A)((Object)this);
    }

    public A withExtensions(NamedExtension ... extensions) {
        if (this.extensions != null) {
            this.extensions.clear();
            this._visitables.remove((Object)"extensions");
        }
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withInsecureSkipTlsVerify() {
        return this.withInsecureSkipTlsVerify(true);
    }

    public A withInsecureSkipTlsVerify(Boolean insecureSkipTlsVerify) {
        this.insecureSkipTlsVerify = insecureSkipTlsVerify;
        return (A)((Object)this);
    }

    public A withProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
        return (A)((Object)this);
    }

    public A withServer(String server) {
        this.server = server;
        return (A)((Object)this);
    }

    public A withTlsServerName(String tlsServerName) {
        this.tlsServerName = tlsServerName;
        return (A)((Object)this);
    }

    public class ExtensionsNested<N>
    extends NamedExtensionFluent<ExtensionsNested<N>>
    implements Nested<N> {
        NamedExtensionBuilder builder;
        int index;

        ExtensionsNested(int index, NamedExtension item) {
            this.index = index;
            this.builder = new NamedExtensionBuilder(this, item);
        }

        public N and() {
            return (N)ClusterFluent.this.setToExtensions(this.index, this.builder.build());
        }

        public N endExtension() {
            return this.and();
        }
    }
}

