package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class EndpointsFluent<A extends EndpointsFluent<A>> extends BaseFluent<A>{
  public EndpointsFluent() {
  }
  
  public EndpointsFluent(Endpoints instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private ArrayList<EndpointSubsetBuilder> subsets = new ArrayList<EndpointSubsetBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Endpoints instance) {
    instance = (instance != null ? instance : new Endpoints());
    if (instance != null) {
          this.withApiVersion(instance.getApiVersion());
          this.withKind(instance.getKind());
          this.withMetadata(instance.getMetadata());
          this.withSubsets(instance.getSubsets());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public ObjectMeta buildMetadata() {
    return this.metadata != null ? this.metadata.build() : null;
  }
  
  public A withMetadata(ObjectMeta metadata) {
    this._visitables.remove("metadata");
    if (metadata != null) {
        this.metadata = new ObjectMetaBuilder(metadata);
        this._visitables.get("metadata").add(this.metadata);
    } else {
        this.metadata = null;
        this._visitables.get("metadata").remove(this.metadata);
    }
    return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  
  public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MetadataNested(item);
  }
  
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ObjectMetaBuilder().build()));
  }
  
  public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  
  public A addToSubsets(int index,EndpointSubset item) {
    if (this.subsets == null) {this.subsets = new ArrayList<EndpointSubsetBuilder>();}
    EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
    if (index < 0 || index >= subsets.size()) {
        _visitables.get("subsets").add(builder);
        subsets.add(builder);
    } else {
        _visitables.get("subsets").add(builder);
        subsets.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToSubsets(int index,EndpointSubset item) {
    if (this.subsets == null) {this.subsets = new ArrayList<EndpointSubsetBuilder>();}
    EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
    if (index < 0 || index >= subsets.size()) {
        _visitables.get("subsets").add(builder);
        subsets.add(builder);
    } else {
        _visitables.get("subsets").add(builder);
        subsets.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToSubsets(io.fabric8.kubernetes.api.model.EndpointSubset... items) {
    if (this.subsets == null) {this.subsets = new ArrayList<EndpointSubsetBuilder>();}
    for (EndpointSubset item : items) {EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);_visitables.get("subsets").add(builder);this.subsets.add(builder);} return (A)this;
  }
  
  public A addAllToSubsets(Collection<EndpointSubset> items) {
    if (this.subsets == null) {this.subsets = new ArrayList<EndpointSubsetBuilder>();}
    for (EndpointSubset item : items) {EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);_visitables.get("subsets").add(builder);this.subsets.add(builder);} return (A)this;
  }
  
  public A removeFromSubsets(io.fabric8.kubernetes.api.model.EndpointSubset... items) {
    if (this.subsets == null) return (A)this;
    for (EndpointSubset item : items) {EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);_visitables.get("subsets").remove(builder); this.subsets.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSubsets(Collection<EndpointSubset> items) {
    if (this.subsets == null) return (A)this;
    for (EndpointSubset item : items) {EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);_visitables.get("subsets").remove(builder); this.subsets.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSubsets(Predicate<EndpointSubsetBuilder> predicate) {
    if (subsets == null) return (A) this;
    final Iterator<EndpointSubsetBuilder> each = subsets.iterator();
    final List visitables = _visitables.get("subsets");
    while (each.hasNext()) {
      EndpointSubsetBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<EndpointSubset> buildSubsets() {
    return this.subsets != null ? build(subsets) : null;
  }
  
  public EndpointSubset buildSubset(int index) {
    return this.subsets.get(index).build();
  }
  
  public EndpointSubset buildFirstSubset() {
    return this.subsets.get(0).build();
  }
  
  public EndpointSubset buildLastSubset() {
    return this.subsets.get(subsets.size() - 1).build();
  }
  
  public EndpointSubset buildMatchingSubset(Predicate<EndpointSubsetBuilder> predicate) {
      for (EndpointSubsetBuilder item : subsets) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSubset(Predicate<EndpointSubsetBuilder> predicate) {
      for (EndpointSubsetBuilder item : subsets) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSubsets(List<EndpointSubset> subsets) {
    if (this.subsets != null) {
      this._visitables.get("subsets").clear();
    }
    if (subsets != null) {
        this.subsets = new ArrayList();
        for (EndpointSubset item : subsets) {
          this.addToSubsets(item);
        }
    } else {
      this.subsets = null;
    }
    return (A) this;
  }
  
  public A withSubsets(io.fabric8.kubernetes.api.model.EndpointSubset... subsets) {
    if (this.subsets != null) {
        this.subsets.clear();
        _visitables.remove("subsets");
    }
    if (subsets != null) {
      for (EndpointSubset item : subsets) {
        this.addToSubsets(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSubsets() {
    return this.subsets != null && !this.subsets.isEmpty();
  }
  
  public SubsetsNested<A> addNewSubset() {
    return new SubsetsNested(-1, null);
  }
  
  public SubsetsNested<A> addNewSubsetLike(EndpointSubset item) {
    return new SubsetsNested(-1, item);
  }
  
  public SubsetsNested<A> setNewSubsetLike(int index,EndpointSubset item) {
    return new SubsetsNested(index, item);
  }
  
  public SubsetsNested<A> editSubset(int index) {
    if (subsets.size() <= index) throw new RuntimeException("Can't edit subsets. Index exceeds size.");
    return setNewSubsetLike(index, buildSubset(index));
  }
  
  public SubsetsNested<A> editFirstSubset() {
    if (subsets.size() == 0) throw new RuntimeException("Can't edit first subsets. The list is empty.");
    return setNewSubsetLike(0, buildSubset(0));
  }
  
  public SubsetsNested<A> editLastSubset() {
    int index = subsets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last subsets. The list is empty.");
    return setNewSubsetLike(index, buildSubset(index));
  }
  
  public SubsetsNested<A> editMatchingSubset(Predicate<EndpointSubsetBuilder> predicate) {
    int index = -1;
    for (int i=0;i<subsets.size();i++) { 
    if (predicate.test(subsets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching subsets. No match found.");
    return setNewSubsetLike(index, buildSubset(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EndpointsFluent that = (EndpointsFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
    if (!java.util.Objects.equals(subsets, that.subsets)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  subsets,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (subsets != null && !subsets.isEmpty()) { sb.append("subsets:"); sb.append(subsets + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) EndpointsFluent.this.withMetadata(builder.build());
    }
    
    public N endMetadata() {
      return and();
    }
    
  
  }
  public class SubsetsNested<N> extends EndpointSubsetFluent<SubsetsNested<N>> implements Nested<N>{
    SubsetsNested(int index,EndpointSubset item) {
      this.index = index;
      this.builder = new EndpointSubsetBuilder(this, item);
    }
    EndpointSubsetBuilder builder;
    int index;
    
    public N and() {
      return (N) EndpointsFluent.this.setToSubsets(index,builder.build());
    }
    
    public N endSubset() {
      return and();
    }
    
  
  }

}