/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ConfigMapProjection;
import io.fabric8.kubernetes.api.model.ConfigMapProjectionBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapProjectionFluent;
import io.fabric8.kubernetes.api.model.DownwardAPIProjection;
import io.fabric8.kubernetes.api.model.DownwardAPIProjectionBuilder;
import io.fabric8.kubernetes.api.model.DownwardAPIProjectionFluent;
import io.fabric8.kubernetes.api.model.SecretProjection;
import io.fabric8.kubernetes.api.model.SecretProjectionBuilder;
import io.fabric8.kubernetes.api.model.SecretProjectionFluent;
import io.fabric8.kubernetes.api.model.ServiceAccountTokenProjection;
import io.fabric8.kubernetes.api.model.ServiceAccountTokenProjectionBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountTokenProjectionFluent;
import io.fabric8.kubernetes.api.model.VolumeProjection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class VolumeProjectionFluent<A extends VolumeProjectionFluent<A>>
extends BaseFluent<A> {
    private ConfigMapProjectionBuilder configMap;
    private DownwardAPIProjectionBuilder downwardAPI;
    private SecretProjectionBuilder secret;
    private ServiceAccountTokenProjectionBuilder serviceAccountToken;
    private Map<String, Object> additionalProperties;

    public VolumeProjectionFluent() {
    }

    public VolumeProjectionFluent(VolumeProjection instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(VolumeProjection instance) {
        VolumeProjection volumeProjection = instance = instance != null ? instance : new VolumeProjection();
        if (instance != null) {
            this.withConfigMap(instance.getConfigMap());
            this.withDownwardAPI(instance.getDownwardAPI());
            this.withSecret(instance.getSecret());
            this.withServiceAccountToken(instance.getServiceAccountToken());
            this.withConfigMap(instance.getConfigMap());
            this.withDownwardAPI(instance.getDownwardAPI());
            this.withSecret(instance.getSecret());
            this.withServiceAccountToken(instance.getServiceAccountToken());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConfigMapProjection buildConfigMap() {
        return this.configMap != null ? this.configMap.build() : null;
    }

    public A withConfigMap(ConfigMapProjection configMap) {
        this._visitables.remove((Object)this.configMap);
        if (configMap != null) {
            this.configMap = new ConfigMapProjectionBuilder(configMap);
            this._visitables.get((Object)"configMap").add(this.configMap);
        } else {
            this.configMap = null;
            this._visitables.get((Object)"configMap").remove((Object)this.configMap);
        }
        return (A)((Object)this);
    }

    public boolean hasConfigMap() {
        return this.configMap != null;
    }

    public ConfigMapNested<A> withNewConfigMap() {
        return new ConfigMapNested(null);
    }

    public ConfigMapNested<A> withNewConfigMapLike(ConfigMapProjection item) {
        return new ConfigMapNested(item);
    }

    public ConfigMapNested<A> editConfigMap() {
        return this.withNewConfigMapLike(Optional.ofNullable(this.buildConfigMap()).orElse(null));
    }

    public ConfigMapNested<A> editOrNewConfigMap() {
        return this.withNewConfigMapLike(Optional.ofNullable(this.buildConfigMap()).orElse(new ConfigMapProjectionBuilder().build()));
    }

    public ConfigMapNested<A> editOrNewConfigMapLike(ConfigMapProjection item) {
        return this.withNewConfigMapLike(Optional.ofNullable(this.buildConfigMap()).orElse(item));
    }

    public DownwardAPIProjection buildDownwardAPI() {
        return this.downwardAPI != null ? this.downwardAPI.build() : null;
    }

    public A withDownwardAPI(DownwardAPIProjection downwardAPI) {
        this._visitables.remove((Object)this.downwardAPI);
        if (downwardAPI != null) {
            this.downwardAPI = new DownwardAPIProjectionBuilder(downwardAPI);
            this._visitables.get((Object)"downwardAPI").add(this.downwardAPI);
        } else {
            this.downwardAPI = null;
            this._visitables.get((Object)"downwardAPI").remove((Object)this.downwardAPI);
        }
        return (A)((Object)this);
    }

    public boolean hasDownwardAPI() {
        return this.downwardAPI != null;
    }

    public DownwardAPINested<A> withNewDownwardAPI() {
        return new DownwardAPINested(null);
    }

    public DownwardAPINested<A> withNewDownwardAPILike(DownwardAPIProjection item) {
        return new DownwardAPINested(item);
    }

    public DownwardAPINested<A> editDownwardAPI() {
        return this.withNewDownwardAPILike(Optional.ofNullable(this.buildDownwardAPI()).orElse(null));
    }

    public DownwardAPINested<A> editOrNewDownwardAPI() {
        return this.withNewDownwardAPILike(Optional.ofNullable(this.buildDownwardAPI()).orElse(new DownwardAPIProjectionBuilder().build()));
    }

    public DownwardAPINested<A> editOrNewDownwardAPILike(DownwardAPIProjection item) {
        return this.withNewDownwardAPILike(Optional.ofNullable(this.buildDownwardAPI()).orElse(item));
    }

    public SecretProjection buildSecret() {
        return this.secret != null ? this.secret.build() : null;
    }

    public A withSecret(SecretProjection secret) {
        this._visitables.remove((Object)this.secret);
        if (secret != null) {
            this.secret = new SecretProjectionBuilder(secret);
            this._visitables.get((Object)"secret").add(this.secret);
        } else {
            this.secret = null;
            this._visitables.get((Object)"secret").remove((Object)this.secret);
        }
        return (A)((Object)this);
    }

    public boolean hasSecret() {
        return this.secret != null;
    }

    public SecretNested<A> withNewSecret() {
        return new SecretNested(null);
    }

    public SecretNested<A> withNewSecretLike(SecretProjection item) {
        return new SecretNested(item);
    }

    public SecretNested<A> editSecret() {
        return this.withNewSecretLike(Optional.ofNullable(this.buildSecret()).orElse(null));
    }

    public SecretNested<A> editOrNewSecret() {
        return this.withNewSecretLike(Optional.ofNullable(this.buildSecret()).orElse(new SecretProjectionBuilder().build()));
    }

    public SecretNested<A> editOrNewSecretLike(SecretProjection item) {
        return this.withNewSecretLike(Optional.ofNullable(this.buildSecret()).orElse(item));
    }

    public ServiceAccountTokenProjection buildServiceAccountToken() {
        return this.serviceAccountToken != null ? this.serviceAccountToken.build() : null;
    }

    public A withServiceAccountToken(ServiceAccountTokenProjection serviceAccountToken) {
        this._visitables.remove((Object)this.serviceAccountToken);
        if (serviceAccountToken != null) {
            this.serviceAccountToken = new ServiceAccountTokenProjectionBuilder(serviceAccountToken);
            this._visitables.get((Object)"serviceAccountToken").add(this.serviceAccountToken);
        } else {
            this.serviceAccountToken = null;
            this._visitables.get((Object)"serviceAccountToken").remove((Object)this.serviceAccountToken);
        }
        return (A)((Object)this);
    }

    public boolean hasServiceAccountToken() {
        return this.serviceAccountToken != null;
    }

    public A withNewServiceAccountToken(String audience, Long expirationSeconds, String path) {
        return this.withServiceAccountToken(new ServiceAccountTokenProjection(audience, expirationSeconds, path));
    }

    public ServiceAccountTokenNested<A> withNewServiceAccountToken() {
        return new ServiceAccountTokenNested(null);
    }

    public ServiceAccountTokenNested<A> withNewServiceAccountTokenLike(ServiceAccountTokenProjection item) {
        return new ServiceAccountTokenNested(item);
    }

    public ServiceAccountTokenNested<A> editServiceAccountToken() {
        return this.withNewServiceAccountTokenLike(Optional.ofNullable(this.buildServiceAccountToken()).orElse(null));
    }

    public ServiceAccountTokenNested<A> editOrNewServiceAccountToken() {
        return this.withNewServiceAccountTokenLike(Optional.ofNullable(this.buildServiceAccountToken()).orElse(new ServiceAccountTokenProjectionBuilder().build()));
    }

    public ServiceAccountTokenNested<A> editOrNewServiceAccountTokenLike(ServiceAccountTokenProjection item) {
        return this.withNewServiceAccountTokenLike(Optional.ofNullable(this.buildServiceAccountToken()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VolumeProjectionFluent that = (VolumeProjectionFluent)((Object)o);
        if (!Objects.equals((Object)this.configMap, (Object)that.configMap)) {
            return false;
        }
        if (!Objects.equals((Object)this.downwardAPI, (Object)that.downwardAPI)) {
            return false;
        }
        if (!Objects.equals((Object)this.secret, (Object)that.secret)) {
            return false;
        }
        if (!Objects.equals((Object)this.serviceAccountToken, (Object)that.serviceAccountToken)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configMap, this.downwardAPI, this.secret, this.serviceAccountToken, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configMap != null) {
            sb.append("configMap:");
            sb.append((Object)((Object)this.configMap) + ",");
        }
        if (this.downwardAPI != null) {
            sb.append("downwardAPI:");
            sb.append((Object)((Object)this.downwardAPI) + ",");
        }
        if (this.secret != null) {
            sb.append("secret:");
            sb.append((Object)((Object)this.secret) + ",");
        }
        if (this.serviceAccountToken != null) {
            sb.append("serviceAccountToken:");
            sb.append((Object)((Object)this.serviceAccountToken) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ServiceAccountTokenNested<N>
    extends ServiceAccountTokenProjectionFluent<ServiceAccountTokenNested<N>>
    implements Nested<N> {
        ServiceAccountTokenProjectionBuilder builder;

        ServiceAccountTokenNested(ServiceAccountTokenProjection item) {
            this.builder = new ServiceAccountTokenProjectionBuilder(this, item);
        }

        public N and() {
            return (N)VolumeProjectionFluent.this.withServiceAccountToken(this.builder.build());
        }

        public N endServiceAccountToken() {
            return this.and();
        }
    }

    public class SecretNested<N>
    extends SecretProjectionFluent<SecretNested<N>>
    implements Nested<N> {
        SecretProjectionBuilder builder;

        SecretNested(SecretProjection item) {
            this.builder = new SecretProjectionBuilder(this, item);
        }

        public N and() {
            return (N)VolumeProjectionFluent.this.withSecret(this.builder.build());
        }

        public N endSecret() {
            return this.and();
        }
    }

    public class DownwardAPINested<N>
    extends DownwardAPIProjectionFluent<DownwardAPINested<N>>
    implements Nested<N> {
        DownwardAPIProjectionBuilder builder;

        DownwardAPINested(DownwardAPIProjection item) {
            this.builder = new DownwardAPIProjectionBuilder(this, item);
        }

        public N and() {
            return (N)VolumeProjectionFluent.this.withDownwardAPI(this.builder.build());
        }

        public N endDownwardAPI() {
            return this.and();
        }
    }

    public class ConfigMapNested<N>
    extends ConfigMapProjectionFluent<ConfigMapNested<N>>
    implements Nested<N> {
        ConfigMapProjectionBuilder builder;

        ConfigMapNested(ConfigMapProjection item) {
            this.builder = new ConfigMapProjectionBuilder(this, item);
        }

        public N and() {
            return (N)VolumeProjectionFluent.this.withConfigMap(this.builder.build());
        }

        public N endConfigMap() {
            return this.and();
        }
    }
}

