/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LoadBalancerIngress;
import io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent;
import io.fabric8.kubernetes.api.model.PortStatus;
import io.fabric8.kubernetes.api.model.PortStatusBuilder;
import io.fabric8.kubernetes.api.model.PortStatusFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class LoadBalancerIngressFluentImpl<A extends LoadBalancerIngressFluent<A>>
extends BaseFluent<A>
implements LoadBalancerIngressFluent<A> {
    private String hostname;
    private String ip;
    private List<PortStatusBuilder> ports = new ArrayList<PortStatusBuilder>();

    public LoadBalancerIngressFluentImpl() {
    }

    public LoadBalancerIngressFluentImpl(LoadBalancerIngress instance) {
        this.withHostname(instance.getHostname());
        this.withIp(instance.getIp());
        this.withPorts(instance.getPorts());
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    @Override
    public Boolean hasHostname() {
        return this.hostname != null;
    }

    @Override
    public A withNewHostname(String arg1) {
        return this.withHostname(new String(arg1));
    }

    @Override
    public A withNewHostname(StringBuilder arg1) {
        return this.withHostname(new String(arg1));
    }

    @Override
    public A withNewHostname(StringBuffer arg1) {
        return this.withHostname(new String(arg1));
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public A withIp(String ip) {
        this.ip = ip;
        return (A)this;
    }

    @Override
    public Boolean hasIp() {
        return this.ip != null;
    }

    @Override
    public A withNewIp(String arg1) {
        return this.withIp(new String(arg1));
    }

    @Override
    public A withNewIp(StringBuilder arg1) {
        return this.withIp(new String(arg1));
    }

    @Override
    public A withNewIp(StringBuffer arg1) {
        return this.withIp(new String(arg1));
    }

    @Override
    public A addToPorts(int index, PortStatus item) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortStatusBuilder>();
        }
        PortStatusBuilder builder = new PortStatusBuilder(item);
        this._visitables.get("ports").add(index >= 0 ? index : this._visitables.get("ports").size(), builder);
        this.ports.add(index >= 0 ? index : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(int index, PortStatus item) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortStatusBuilder>();
        }
        PortStatusBuilder builder = new PortStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get("ports").size()) {
            this._visitables.get("ports").add(builder);
        } else {
            this._visitables.get("ports").set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(PortStatus ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortStatusBuilder>();
        }
        for (PortStatus item : items) {
            PortStatusBuilder builder = new PortStatusBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<PortStatus> items) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortStatusBuilder>();
        }
        for (PortStatus item : items) {
            PortStatusBuilder builder = new PortStatusBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(PortStatus ... items) {
        for (PortStatus item : items) {
            PortStatusBuilder builder = new PortStatusBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<PortStatus> items) {
        for (PortStatus item : items) {
            PortStatusBuilder builder = new PortStatusBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPorts(Predicate<PortStatusBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<PortStatusBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            PortStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PortStatus> getPorts() {
        return LoadBalancerIngressFluentImpl.build(this.ports);
    }

    @Override
    public List<PortStatus> buildPorts() {
        return LoadBalancerIngressFluentImpl.build(this.ports);
    }

    @Override
    public PortStatus buildPort(int index) {
        return this.ports.get(index).build();
    }

    @Override
    public PortStatus buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public PortStatus buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public PortStatus buildMatchingPort(Predicate<PortStatusBuilder> predicate) {
        for (PortStatusBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPort(Predicate<PortStatusBuilder> predicate) {
        for (PortStatusBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPorts(List<PortStatus> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").removeAll(this.ports);
        }
        if (ports != null) {
            this.ports = new ArrayList<PortStatusBuilder>();
            for (PortStatus item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    @Override
    public A withPorts(PortStatus ... ports) {
        if (this.ports != null) {
            this.ports.clear();
        }
        if (ports != null) {
            for (PortStatus item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public A addNewPort(String error, Integer port, String protocol) {
        return this.addToPorts(new PortStatus(error, port, protocol));
    }

    @Override
    public LoadBalancerIngressFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public LoadBalancerIngressFluent.PortsNested<A> addNewPortLike(PortStatus item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public LoadBalancerIngressFluent.PortsNested<A> setNewPortLike(int index, PortStatus item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public LoadBalancerIngressFluent.PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public LoadBalancerIngressFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public LoadBalancerIngressFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public LoadBalancerIngressFluent.PortsNested<A> editMatchingPort(Predicate<PortStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadBalancerIngressFluentImpl that = (LoadBalancerIngressFluentImpl)o;
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.ip != null ? !this.ip.equals(that.ip) : that.ip != null) {
            return false;
        }
        return !(this.ports != null ? !this.ports.equals(that.ports) : that.ports != null);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.ip, this.ports, super.hashCode());
    }

    public class PortsNestedImpl<N>
    extends PortStatusFluentImpl<LoadBalancerIngressFluent.PortsNested<N>>
    implements LoadBalancerIngressFluent.PortsNested<N>,
    Nested<N> {
        private final PortStatusBuilder builder;
        private final int index;

        PortsNestedImpl(int index, PortStatus item) {
            this.index = index;
            this.builder = new PortStatusBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new PortStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)LoadBalancerIngressFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }
}

