/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface HasMetadata
extends KubernetesResource {
    public static final String DNS_LABEL_START = "(?!-)[A-Za-z0-9-]{";
    public static final String DNS_LABEL_END = ",63}(?<!-)";
    public static final String DNS_LABEL_REGEXP = "(?!-)[A-Za-z0-9-]{1,63}(?<!-)";
    public static final Matcher FINALIZER_NAME_MATCHER = Pattern.compile("^((?!-)[A-Za-z0-9-]{1,63}(?<!-)\\.)+(?!-)[A-Za-z0-9-]{2,63}(?<!-)/(?!-)[A-Za-z0-9-]{1,63}(?<!-)").matcher("");

    public ObjectMeta getMetadata();

    public void setMetadata(ObjectMeta var1);

    public String getKind();

    public String getApiVersion();

    public void setApiVersion(String var1);

    @JsonIgnore
    default public boolean isMarkedForDeletion() {
        String deletionTimestamp = this.getMetadata().getDeletionTimestamp();
        return deletionTimestamp != null && !deletionTimestamp.isEmpty();
    }

    default public boolean hasFinalizer(String finalizer) {
        return this.getMetadata().getFinalizers().contains(finalizer);
    }

    default public boolean addFinalizer(String finalizer) {
        if (finalizer == null) {
            throw new IllegalArgumentException("Must pass a non-null finalizer.");
        }
        if (this.isMarkedForDeletion() || this.hasFinalizer(finalizer)) {
            return false;
        }
        if (FINALIZER_NAME_MATCHER.reset(finalizer).matches()) {
            return this.getMetadata().getFinalizers().add(finalizer);
        }
        throw new IllegalArgumentException("Invalid finalizer name: '" + finalizer + "'. Must consist of a domain name, a forward slash and the valid kubernetes name.");
    }

    default public boolean removeFinalizer(String finalizer) {
        return this.getMetadata().getFinalizers().remove(finalizer);
    }
}

