/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.JobStatus;
import io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent;
import io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluentImpl;
import java.util.Objects;

public class JobStatusBuilder
extends JobStatusFluentImpl<JobStatusBuilder>
implements VisitableBuilder<JobStatus, JobStatusBuilder> {
    JobStatusFluent<?> fluent;
    Boolean validationEnabled;

    public JobStatusBuilder() {
        this(false);
    }

    public JobStatusBuilder(Boolean validationEnabled) {
        this(new JobStatus(), validationEnabled);
    }

    public JobStatusBuilder(JobStatusFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public JobStatusBuilder(JobStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new JobStatus(), validationEnabled);
    }

    public JobStatusBuilder(JobStatusFluent<?> fluent, JobStatus instance) {
        this(fluent, instance, false);
    }

    public JobStatusBuilder(JobStatusFluent<?> fluent, JobStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withActive(instance.getActive());
        fluent.withCompletedIndexes(instance.getCompletedIndexes());
        fluent.withCompletionTime(instance.getCompletionTime());
        fluent.withConditions(instance.getConditions());
        fluent.withFailed(instance.getFailed());
        fluent.withStartTime(instance.getStartTime());
        fluent.withSucceeded(instance.getSucceeded());
        fluent.withUncountedTerminatedPods(instance.getUncountedTerminatedPods());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public JobStatusBuilder(JobStatus instance) {
        this(instance, (Boolean)false);
    }

    public JobStatusBuilder(JobStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withActive(instance.getActive());
        this.withCompletedIndexes(instance.getCompletedIndexes());
        this.withCompletionTime(instance.getCompletionTime());
        this.withConditions(instance.getConditions());
        this.withFailed(instance.getFailed());
        this.withStartTime(instance.getStartTime());
        this.withSucceeded(instance.getSucceeded());
        this.withUncountedTerminatedPods(instance.getUncountedTerminatedPods());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public JobStatus build() {
        JobStatus buildable = new JobStatus(this.fluent.getActive(), this.fluent.getCompletedIndexes(), this.fluent.getCompletionTime(), this.fluent.getConditions(), this.fluent.getFailed(), this.fluent.getStartTime(), this.fluent.getSucceeded(), this.fluent.getUncountedTerminatedPods());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobStatusBuilder that = (JobStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

