package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DeploymentConditionBuilder extends DeploymentConditionFluent<DeploymentConditionBuilder> implements VisitableBuilder<DeploymentCondition,DeploymentConditionBuilder>{
  public DeploymentConditionBuilder() {
    this(new DeploymentCondition());
  }
  
  public DeploymentConditionBuilder(DeploymentConditionFluent<?> fluent) {
    this(fluent, new DeploymentCondition());
  }
  
  public DeploymentConditionBuilder(DeploymentConditionFluent<?> fluent,DeploymentCondition instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DeploymentConditionBuilder(DeploymentCondition instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DeploymentConditionFluent<?> fluent;
  
  public DeploymentCondition build() {
    DeploymentCondition buildable = new DeploymentCondition(fluent.getLastTransitionTime(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}