/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetStatus;
import io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluentImpl;
import java.util.Objects;

public class StatefulSetStatusBuilder
extends StatefulSetStatusFluentImpl<StatefulSetStatusBuilder>
implements VisitableBuilder<StatefulSetStatus, StatefulSetStatusBuilder> {
    StatefulSetStatusFluent<?> fluent;
    Boolean validationEnabled;

    public StatefulSetStatusBuilder() {
        this(false);
    }

    public StatefulSetStatusBuilder(Boolean validationEnabled) {
        this(new StatefulSetStatus(), validationEnabled);
    }

    public StatefulSetStatusBuilder(StatefulSetStatusFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public StatefulSetStatusBuilder(StatefulSetStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StatefulSetStatus(), validationEnabled);
    }

    public StatefulSetStatusBuilder(StatefulSetStatusFluent<?> fluent, StatefulSetStatus instance) {
        this(fluent, instance, false);
    }

    public StatefulSetStatusBuilder(StatefulSetStatusFluent<?> fluent, StatefulSetStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCollisionCount(instance.getCollisionCount());
        fluent.withConditions(instance.getConditions());
        fluent.withCurrentReplicas(instance.getCurrentReplicas());
        fluent.withCurrentRevision(instance.getCurrentRevision());
        fluent.withObservedGeneration(instance.getObservedGeneration());
        fluent.withReadyReplicas(instance.getReadyReplicas());
        fluent.withReplicas(instance.getReplicas());
        fluent.withUpdateRevision(instance.getUpdateRevision());
        fluent.withUpdatedReplicas(instance.getUpdatedReplicas());
        this.validationEnabled = validationEnabled;
    }

    public StatefulSetStatusBuilder(StatefulSetStatus instance) {
        this(instance, (Boolean)false);
    }

    public StatefulSetStatusBuilder(StatefulSetStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCollisionCount(instance.getCollisionCount());
        this.withConditions(instance.getConditions());
        this.withCurrentReplicas(instance.getCurrentReplicas());
        this.withCurrentRevision(instance.getCurrentRevision());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReadyReplicas(instance.getReadyReplicas());
        this.withReplicas(instance.getReplicas());
        this.withUpdateRevision(instance.getUpdateRevision());
        this.withUpdatedReplicas(instance.getUpdatedReplicas());
        this.validationEnabled = validationEnabled;
    }

    public StatefulSetStatus build() {
        StatefulSetStatus buildable = new StatefulSetStatus(this.fluent.getCollisionCount(), this.fluent.getConditions(), this.fluent.getCurrentReplicas(), this.fluent.getCurrentRevision(), this.fluent.getObservedGeneration(), this.fluent.getReadyReplicas(), this.fluent.getReplicas(), this.fluent.getUpdateRevision(), this.fluent.getUpdatedReplicas());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatefulSetStatusBuilder that = (StatefulSetStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

