/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.jolokia;

import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.utils.Filter;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import java.util.ArrayList;
import java.util.List;
import org.jolokia.client.J4pClient;
import org.jolokia.client.J4pClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JolokiaClients {
    private static final transient Logger LOG = LoggerFactory.getLogger(JolokiaClients.class);
    private final KubernetesClient kubernetes;
    private String user = Systems.getEnvVarOrSystemProperty((String)"JOLOKIA_USER", (String)"JOLOKIA_USER", (String)"admin");
    private String password = Systems.getEnvVarOrSystemProperty((String)"JOLOKIA_PASSWORD", (String)"JOLOKIA_PASSWORD", (String)"admin");
    private Filter<Pod> podFilter = null;

    public JolokiaClients() {
        this(new KubernetesClient());
    }

    public JolokiaClients(KubernetesClient kubernetes) {
        this.kubernetes = kubernetes;
    }

    public KubernetesClient getKubernetes() {
        return this.kubernetes;
    }

    public J4pClient assertClientForReplicationController(String replicationControllerId) {
        J4pClient client = this.clientForReplicationController(replicationControllerId);
        Objects.assertNotNull((Object)client, (String)("No client for replicationController: " + replicationControllerId));
        return client;
    }

    public J4pClient assertClientForService(String serviceId) {
        J4pClient client = this.clientForService(serviceId);
        Objects.assertNotNull((Object)client, (String)("No client for service: " + serviceId));
        return client;
    }

    public J4pClient clientForReplicationController(ReplicationController replicationController) {
        List pods = this.kubernetes.getPodsForReplicationController(replicationController);
        return this.clientForPod(pods);
    }

    public J4pClient clientForReplicationController(String replicationControllerId) {
        List pods = this.kubernetes.getPodsForReplicationController(replicationControllerId);
        return this.clientForPod(pods);
    }

    public List<J4pClient> clientsForReplicationController(ReplicationController replicationController) {
        List pods = this.kubernetes.getPodsForReplicationController(replicationController);
        return this.clientsForPod(pods);
    }

    public List<J4pClient> clientsForReplicationController(String replicationControllerId) {
        List pods = this.kubernetes.getPodsForReplicationController(replicationControllerId);
        return this.clientsForPod(pods);
    }

    public J4pClient clientForService(String serviceId) {
        List pods = this.kubernetes.getPodsForService(serviceId);
        return this.clientForPod(pods);
    }

    public J4pClient clientForService(Service service) {
        List pods = this.kubernetes.getPodsForService(service);
        return this.clientForPod(pods);
    }

    public List<J4pClient> clientsForService(String serviceId) {
        List pods = this.kubernetes.getPodsForService(serviceId);
        return this.clientsForPod(pods);
    }

    public List<J4pClient> clientsForService(Service service) {
        List pods = this.kubernetes.getPodsForService(service);
        return this.clientsForPod(pods);
    }

    public J4pClient clientForPod(Iterable<Pod> pods) {
        for (Pod pod : pods) {
            J4pClient client;
            if (!KubernetesHelper.isPodRunning((Pod)pod) || !this.filterPod(pod) || (client = this.clientForPod(pod)) == null) continue;
            return client;
        }
        return null;
    }

    public List<J4pClient> clientsForPod(Iterable<Pod> pods) {
        ArrayList<J4pClient> answer = new ArrayList<J4pClient>();
        for (Pod pod : pods) {
            J4pClient client;
            if (!KubernetesHelper.isPodRunning((Pod)pod) || !this.filterPod(pod) || (client = this.clientForPod(pod)) == null) continue;
            answer.add(client);
        }
        return answer;
    }

    protected boolean filterPod(Pod pod) {
        if (this.podFilter != null) {
            return this.podFilter.matches((Object)pod);
        }
        return true;
    }

    public J4pClient clientForPod(Pod pod) {
        String host = KubernetesHelper.getHost((Pod)pod);
        List containers = KubernetesHelper.getContainers((Pod)pod);
        for (Container container : containers) {
            J4pClient jolokia = this.clientForContainer(host, container, pod);
            if (jolokia == null) continue;
            return jolokia;
        }
        return null;
    }

    public J4pClient clientForContainer(String host, Container container, Pod pod) {
        if (container != null) {
            List ports = container.getPorts();
            for (ContainerPort port : ports) {
                String dockerIp;
                Integer containerPort = port.getContainerPort();
                if (containerPort == null) continue;
                String name = port.getName();
                if (containerPort != 8778 && (!java.util.Objects.equals("jolokia", name) || containerPort <= 0)) continue;
                PodStatus currentState = pod.getStatus();
                String podIP = currentState.getPodIP();
                if (Strings.isNotBlank((String)podIP)) {
                    return this.createJolokiaClientFromHostAndPort(container, podIP, containerPort);
                }
                Integer hostPort = port.getHostPort();
                if (hostPort != null && this.hasDocker(pod) && (host.equals("localhost") || host.equals("127.0.0.1")) && Strings.isNotBlank((String)(dockerIp = KubernetesHelper.getDockerIp()))) {
                    host = dockerIp;
                }
                if (!Strings.isNotBlank((String)host)) continue;
                return this.createJolokiaClientFromHostAndPort(container, host, hostPort);
            }
        }
        return null;
    }

    protected J4pClient createJolokiaClientFromHostAndPort(Container container, String host, Integer hostPort) {
        String jolokiaUrl = "http://" + host + ":" + hostPort + "/jolokia/";
        return this.createJolokiaClient(container, jolokiaUrl);
    }

    protected boolean hasDocker(Pod pod) {
        PodStatus currentState = pod.getStatus();
        if (currentState != null) {
            List list = currentState.getContainerStatuses();
        }
        return false;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Filter<Pod> getPodFilter() {
        return this.podFilter;
    }

    public void setPodFilter(Filter<Pod> podFilter) {
        this.podFilter = podFilter;
    }

    protected J4pClient createJolokiaClient(Container container, String jolokiaUrl) {
        String name = container.getName();
        LOG.debug("Creating jolokia client for : " + name + " at URL: " + jolokiaUrl);
        J4pClientBuilder builder = J4pClient.url((String)jolokiaUrl);
        if (Strings.isNotBlank((String)this.user)) {
            builder = builder.user(this.user);
        }
        if (Strings.isNotBlank((String)this.password)) {
            builder = builder.password(this.password);
        }
        return builder.build();
    }
}

