/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.vertx;

import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.vertx.InputStreamReadStream;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.streams.ReadStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

class VertxHttpRequest
implements HttpRequest {
    final Vertx vertx;
    private final RequestOptions options;
    private final StandardHttpRequest.BodyContent body;

    public VertxHttpRequest(Vertx vertx, RequestOptions options, StandardHttpRequest.BodyContent body) {
        this.vertx = vertx;
        this.options = options;
        this.body = body;
    }

    public URI uri() {
        return URI.create(this.options.getURI());
    }

    public String method() {
        return this.options.getMethod().name();
    }

    public String bodyString() {
        return this.body.toString();
    }

    public List<String> headers(String key) {
        return this.options.getHeaders().getAll(key);
    }

    public CompletableFuture<HttpResponse<AsyncBody>> consumeBytes(HttpClient client, AsyncBody.Consumer<List<ByteBuffer>> consumer) {
        Function<HttpClientResponse, HttpResponse> responseHandler = resp -> {
            resp.pause();
            final AsyncBody result = new AsyncBody((HttpClientResponse)resp){
                final CompletableFuture done = new CompletableFuture();
                final /* synthetic */ HttpClientResponse val$resp;
                {
                    this.val$resp = httpClientResponse;
                }

                public void consume() {
                    this.val$resp.fetch(1L);
                }

                public CompletableFuture<Void> done() {
                    return this.done;
                }

                public void cancel() {
                    this.val$resp.handler(null);
                    this.val$resp.endHandler(null);
                    this.val$resp.request().reset();
                    this.done.cancel(false);
                }
            };
            resp.handler(buffer -> {
                try {
                    consumer.consume(Arrays.asList(ByteBuffer.wrap(buffer.getBytes())), result);
                }
                catch (Exception e) {
                    resp.request().reset();
                    result.done().completeExceptionally(e);
                }
            }).endHandler(end -> result.done().complete(null));
            return new HttpResponse<AsyncBody>(){

                public List<String> headers(String key) {
                    return VertxHttpRequest.this.headers().get(key);
                }

                public Map<String, List<String>> headers() {
                    return VertxHttpRequest.this.headers();
                }

                public int code() {
                    return resp.statusCode();
                }

                public AsyncBody body() {
                    return result;
                }

                public HttpRequest request() {
                    return VertxHttpRequest.this;
                }

                public Optional<HttpResponse<?>> previousResponse() {
                    return Optional.empty();
                }
            };
        };
        return client.request(this.options).compose(request -> {
            Future fut;
            if (this.body != null) {
                if (this.body instanceof StandardHttpRequest.StringBodyContent) {
                    Buffer buffer = Buffer.buffer((String)((StandardHttpRequest.StringBodyContent)this.body).getContent());
                    fut = request.send(buffer);
                } else if (this.body instanceof StandardHttpRequest.ByteArrayBodyContent) {
                    Buffer buffer = Buffer.buffer((byte[])((StandardHttpRequest.ByteArrayBodyContent)this.body).getContent());
                    fut = request.send(buffer);
                } else if (this.body instanceof StandardHttpRequest.InputStreamBodyContent) {
                    StandardHttpRequest.InputStreamBodyContent bodyContent = (StandardHttpRequest.InputStreamBodyContent)this.body;
                    InputStream is = bodyContent.getContent();
                    InputStreamReadStream stream = new InputStreamReadStream(this, is, (HttpClientRequest)request);
                    fut = request.send((ReadStream)stream);
                } else {
                    fut = Future.failedFuture((String)"Unsupported body content");
                }
            } else {
                fut = request.send();
            }
            return fut.map(responseHandler);
        }).toCompletionStage().toCompletableFuture();
    }

    public Map<String, List<String>> headers() {
        MultiMap multiMap = this.options.getHeaders();
        return VertxHttpRequest.toHeadersMap(multiMap);
    }

    static Map<String, List<String>> toHeadersMap(MultiMap multiMap) {
        LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
        multiMap.names().stream().forEach(k -> headers.put((String)k, multiMap.getAll(k)));
        return headers;
    }
}

