/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.vertx;

import io.fabric8.kubernetes.client.http.WebSocket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

class VertxWebSocket
implements io.fabric8.kubernetes.client.http.WebSocket {
    private final WebSocket ws;
    private final AtomicInteger pending = new AtomicInteger();
    private final WebSocket.Listener listener;

    VertxWebSocket(WebSocket ws, WebSocket.Listener listener) {
        this.ws = ws;
        this.listener = listener;
    }

    void init() {
        this.ws.binaryMessageHandler(msg -> {
            this.ws.pause();
            this.listener.onMessage((io.fabric8.kubernetes.client.http.WebSocket)this, msg.getByteBuf().nioBuffer());
        });
        this.ws.textMessageHandler(msg -> {
            this.ws.pause();
            this.listener.onMessage((io.fabric8.kubernetes.client.http.WebSocket)this, msg);
        });
        this.ws.closeHandler(v -> this.listener.onClose((io.fabric8.kubernetes.client.http.WebSocket)this, (int)this.ws.closeStatusCode().shortValue(), this.ws.closeReason()));
        this.ws.exceptionHandler(err -> this.listener.onError((io.fabric8.kubernetes.client.http.WebSocket)this, err));
        this.listener.onOpen((io.fabric8.kubernetes.client.http.WebSocket)this);
    }

    public boolean send(ByteBuffer buffer) {
        Buffer vertxBuffer = Buffer.buffer((ByteBuf)Unpooled.copiedBuffer((ByteBuffer)buffer));
        int len = vertxBuffer.length();
        this.pending.addAndGet(len);
        Future res = this.ws.writeBinaryMessage(vertxBuffer);
        res.onComplete(ignore -> this.pending.addAndGet(-len));
        return true;
    }

    public boolean sendClose(int code, String reason) {
        this.ws.close((short)code, reason);
        return true;
    }

    public long queueSize() {
        return this.pending.get();
    }

    public void request() {
        this.ws.fetch(1L);
    }
}

