/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.jetty;

import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.jetty.JettyHttpResponse;
import java.nio.ByteBuffer;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.LongConsumer;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.util.Callback;

public abstract class JettyAsyncResponseListener
extends Response.Listener.Adapter
implements AsyncBody {
    private final HttpRequest httpRequest;
    private final CompletableFuture<JettyHttpResponse<AsyncBody>> asyncResponse;
    private final CompletableFuture<Void> asyncBodyDone;
    private LongConsumer demand;
    private boolean initialConsumeCalled;

    JettyAsyncResponseListener(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
        this.asyncResponse = new CompletableFuture();
        this.asyncBodyDone = new CompletableFuture();
    }

    public synchronized void consume() {
        if (!this.initialConsumeCalled) {
            this.initialConsumeCalled = true;
        }
        if (this.demand != null) {
            this.demand.accept(1L);
        }
    }

    public CompletableFuture<Void> done() {
        return this.asyncBodyDone;
    }

    public void cancel() {
        if (!this.asyncBodyDone.isDone()) {
            this.asyncBodyDone.cancel(false);
            this.asyncResponse.thenAccept(r -> r.getResponse().abort((Throwable)new CancellationException()));
        }
    }

    public void onHeaders(Response response) {
        this.asyncResponse.complete(new JettyHttpResponse<JettyAsyncResponseListener>(this.httpRequest, response, this));
    }

    public void onComplete(Result result) {
        if (result.isSucceeded()) {
            this.asyncBodyDone.complete(null);
        } else {
            this.asyncBodyDone.completeExceptionally(result.getRequestFailure());
        }
    }

    public void onFailure(Response response, Throwable failure) {
        this.asyncResponse.completeExceptionally(failure);
    }

    public CompletableFuture<HttpResponse<AsyncBody>> listen(Request request) {
        request.send((Response.CompleteListener)this);
        return this.asyncResponse.thenApply(HttpResponse.class::cast);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBeforeContent(Response response, LongConsumer demand) {
        JettyAsyncResponseListener jettyAsyncResponseListener = this;
        synchronized (jettyAsyncResponseListener) {
            if (!this.initialConsumeCalled) {
                this.demand = demand;
                return;
            }
        }
        demand.accept(1L);
    }

    public void onContent(Response response, ByteBuffer content, Callback callback) {
        try {
            if (!this.asyncBodyDone.isCancelled()) {
                this.onContent(content);
                callback.succeeded();
            }
        }
        catch (Exception e) {
            callback.failed((Throwable)e);
        }
    }

    protected abstract void onContent(ByteBuffer var1) throws Exception;
}

