/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.jetty;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketHandshakeException;
import io.fabric8.kubernetes.client.jetty.JettyHttpResponse;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.exceptions.UpgradeException;

public class JettyWebSocket
implements WebSocket,
WebSocketListener {
    private final WebSocket.Listener listener;
    private final AtomicLong sendQueue;
    private final Lock lock;
    private final Condition backPressure;
    private final AtomicBoolean closed;
    private boolean moreMessages;
    private volatile Session webSocketSession;

    public JettyWebSocket(WebSocket.Listener listener) {
        this.listener = listener;
        this.sendQueue = new AtomicLong();
        this.lock = new ReentrantLock();
        this.backPressure = this.lock.newCondition();
        this.closed = new AtomicBoolean();
        this.moreMessages = true;
    }

    static WebSocketHandshakeException toHandshakeException(UpgradeException ex) {
        return new WebSocketHandshakeException(new JettyHttpResponse<Object>((HttpRequest)((StandardHttpRequest.Builder)new StandardHttpRequest.Builder().uri(ex.getRequestURI())).build(), (Response)new HttpResponse(null, Collections.emptyList()).status(ex.getResponseStatusCode()), null)).initCause((Throwable)ex);
    }

    public boolean send(ByteBuffer buffer) {
        if (this.closed.get() || !this.webSocketSession.isOpen()) {
            return false;
        }
        final int size = buffer.remaining();
        this.sendQueue.addAndGet(size);
        this.webSocketSession.getRemote().sendBytes(buffer, new WriteCallback(){

            public void writeFailed(Throwable x) {
                JettyWebSocket.this.sendQueue.addAndGet(-size);
            }

            public void writeSuccess() {
                JettyWebSocket.this.sendQueue.addAndGet(-size);
            }
        });
        return true;
    }

    public boolean sendClose(int code, String reason) {
        if (this.webSocketSession.isOpen() && !this.closed.getAndSet(true)) {
            this.webSocketSession.close(code, reason);
            return true;
        }
        return false;
    }

    public long queueSize() {
        return this.sendQueue.get();
    }

    public void request() {
        try {
            this.lock.lock();
            this.moreMessages = true;
            this.backPressure.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        this.backPressure();
        ByteBuffer buffer = ByteBuffer.allocate(len);
        buffer.put(payload, offset, len).rewind();
        this.listener.onMessage((WebSocket)this, buffer.asReadOnlyBuffer());
    }

    public void onWebSocketText(String message) {
        this.backPressure();
        this.listener.onMessage((WebSocket)this, message);
    }

    public void onWebSocketClose(int statusCode, String reason) {
        this.closed.set(true);
        this.backPressure();
        this.listener.onClose((WebSocket)this, statusCode, reason);
    }

    public void onWebSocketConnect(Session session) {
        this.webSocketSession = session;
        this.listener.onOpen((WebSocket)this);
    }

    public void onWebSocketError(Throwable cause) {
        if (cause instanceof ClosedChannelException && this.closed.get()) {
            return;
        }
        this.listener.onError((WebSocket)this, cause);
    }

    private void backPressure() {
        try {
            this.lock.lock();
            while (!this.moreMessages) {
                if (this.backPressure.await(30L, TimeUnit.SECONDS)) continue;
                throw new KubernetesClientException("Jetty HttpClient thread is waiting too long for the consumption of previous websocket message");
            }
            this.moreMessages = false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }
}

