/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.jetty;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.BufferUtil;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.StandardHttpClient;
import io.fabric8.kubernetes.client.http.StandardHttpClientBuilder;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.http.StandardWebSocketBuilder;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketResponse;
import io.fabric8.kubernetes.client.jetty.JettyAsyncResponseListener;
import io.fabric8.kubernetes.client.jetty.JettyHttpClientBuilder;
import io.fabric8.kubernetes.client.jetty.JettyHttpClientFactory;
import io.fabric8.kubernetes.client.jetty.JettyWebSocket;
import io.fabric8.kubernetes.client.utils.Utils;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.BytesRequestContent;
import org.eclipse.jetty.client.util.InputStreamRequestContent;
import org.eclipse.jetty.client.util.StringRequestContent;
import org.eclipse.jetty.websocket.api.exceptions.UpgradeException;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public class JettyHttpClient
extends StandardHttpClient<JettyHttpClient, JettyHttpClientFactory, JettyHttpClientBuilder> {
    private final HttpClient jetty;
    private final WebSocketClient jettyWs;

    public JettyHttpClient(StandardHttpClientBuilder<JettyHttpClient, JettyHttpClientFactory, JettyHttpClientBuilder> builder, HttpClient jetty, WebSocketClient jettyWs) {
        super(builder);
        this.jetty = jetty;
        this.jettyWs = jettyWs;
    }

    public void close() {
        try {
            this.jetty.stop();
            this.jettyWs.stop();
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public CompletableFuture<HttpResponse<AsyncBody>> consumeBytesDirect(StandardHttpRequest request, final AsyncBody.Consumer<List<ByteBuffer>> consumer) {
        return new JettyAsyncResponseListener((HttpRequest)request){

            @Override
            protected void onContent(ByteBuffer content) throws Exception {
                consumer.consume(Collections.singletonList(BufferUtil.copy((ByteBuffer)content)), (AsyncBody)this);
            }
        }.listen(this.newRequest(request));
    }

    private Request newRequest(StandardHttpRequest originalRequest) {
        try {
            this.jetty.start();
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
        StandardHttpRequest.Builder requestBuilder = originalRequest.newBuilder();
        StandardHttpRequest request = requestBuilder.build();
        Request jettyRequest = this.jetty.newRequest(request.uri()).method(request.method());
        jettyRequest.timeout(this.builder.getReadTimeout().toMillis() + this.builder.getWriteTimeout().toMillis(), TimeUnit.MILLISECONDS);
        jettyRequest.headers(m -> request.headers().forEach((k, l) -> l.forEach(v -> m.add(k, v))));
        Optional<String> contentType = Optional.ofNullable(request.getContentType());
        StandardHttpRequest.BodyContent body = request.body();
        if (body != null) {
            if (body instanceof StandardHttpRequest.StringBodyContent) {
                jettyRequest.body((Request.Content)new StringRequestContent(contentType.orElse("text/plain"), ((StandardHttpRequest.StringBodyContent)body).getContent()));
            } else if (body instanceof StandardHttpRequest.ByteArrayBodyContent) {
                jettyRequest.body((Request.Content)new BytesRequestContent(contentType.orElse("application/octet-stream"), (byte[][])new byte[][]{((StandardHttpRequest.ByteArrayBodyContent)body).getContent()}));
            } else if (body instanceof StandardHttpRequest.InputStreamBodyContent) {
                StandardHttpRequest.InputStreamBodyContent bodyContent = (StandardHttpRequest.InputStreamBodyContent)body;
                if (bodyContent.getLength() >= 0L) {
                    jettyRequest.headers(m -> m.put("Content-Length", Long.toString(bodyContent.getLength())));
                }
                jettyRequest.body((Request.Content)new InputStreamRequestContent(contentType.orElse("application/octet-stream"), bodyContent.getContent()));
            } else {
                throw new AssertionError((Object)"Unsupported body content");
            }
        }
        if (request.isExpectContinue()) {
            jettyRequest.headers(m -> m.put("Expect", "100-Continue"));
        }
        return jettyRequest;
    }

    public CompletableFuture<WebSocketResponse> buildWebSocketDirect(StandardWebSocketBuilder standardWebSocketBuilder, WebSocket.Listener listener) {
        try {
            this.jettyWs.start();
            StandardHttpRequest request = standardWebSocketBuilder.asHttpRequest();
            ClientUpgradeRequest cur = new ClientUpgradeRequest();
            if (Utils.isNotNullOrEmpty((String)standardWebSocketBuilder.getSubprotocol())) {
                cur.setSubProtocols(new String[]{standardWebSocketBuilder.getSubprotocol()});
            }
            cur.setHeaders(request.headers());
            if (this.builder.getReadTimeout() != null) {
                cur.setTimeout(this.builder.getReadTimeout().toMillis(), TimeUnit.MILLISECONDS);
            }
            CompletableFuture<WebSocketResponse> future = new CompletableFuture<WebSocketResponse>();
            JettyWebSocket webSocket = new JettyWebSocket(listener);
            this.jettyWs.connect((Object)webSocket, Objects.requireNonNull(WebSocket.toWebSocketUri((URI)request.uri())), cur).whenComplete((s, ex) -> {
                if (ex != null) {
                    if (ex instanceof CompletionException && ex.getCause() instanceof UpgradeException) {
                        future.complete(new WebSocketResponse((WebSocket)webSocket, JettyWebSocket.toHandshakeException((UpgradeException)ex.getCause())));
                    } else if (ex instanceof UpgradeException) {
                        future.complete(new WebSocketResponse((WebSocket)webSocket, JettyWebSocket.toHandshakeException((UpgradeException)ex)));
                    } else {
                        future.completeExceptionally((Throwable)ex);
                    }
                } else {
                    future.complete(new WebSocketResponse((WebSocket)webSocket, null));
                }
            });
            return future;
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    HttpClient getJetty() {
        return this.jetty;
    }

    WebSocketClient getJettyWs() {
        return this.jettyWs;
    }
}

