/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.jetty;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.AbstractBasicBuilder;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketHandshakeException;
import io.fabric8.kubernetes.client.jetty.JettyHttpResponse;
import io.fabric8.kubernetes.client.jetty.JettyWebSocket;
import io.fabric8.kubernetes.client.utils.Utils;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.websocket.api.exceptions.UpgradeException;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public class JettyWebSocketBuilder
extends AbstractBasicBuilder<JettyWebSocketBuilder>
implements WebSocket.Builder {
    private final WebSocketClient webSocketClient;
    private final Duration handshakeTimeout;
    private String subprotocol;

    public JettyWebSocketBuilder(WebSocketClient webSocketClient, Duration handshakeTimeout) {
        this.webSocketClient = webSocketClient;
        this.handshakeTimeout = handshakeTimeout;
    }

    public CompletableFuture<WebSocket> buildAsync(WebSocket.Listener listener) {
        try {
            this.webSocketClient.start();
            ClientUpgradeRequest cur = new ClientUpgradeRequest();
            if (Utils.isNotNullOrEmpty((String)this.subprotocol)) {
                cur.setSubProtocols(new String[]{this.subprotocol});
            }
            cur.setHeaders(this.getHeaders());
            cur.setTimeout(this.handshakeTimeout.toMillis(), TimeUnit.MILLISECONDS);
            CompletableFuture future = new CompletableFuture();
            JettyWebSocket webSocket = new JettyWebSocket(listener);
            return ((CompletableFuture)((CompletableFuture)this.webSocketClient.connect((Object)webSocket, Objects.requireNonNull(WebSocket.toWebSocketUri((URI)this.getUri())), cur).thenApply(webSocket::setWebSocketSession)).exceptionally(ex -> {
                if (ex instanceof CompletionException && ex.getCause() instanceof UpgradeException) {
                    future.completeExceptionally((Throwable)JettyWebSocketBuilder.toHandshakeException((UpgradeException)ex.getCause()));
                } else if (ex instanceof UpgradeException) {
                    future.completeExceptionally((Throwable)JettyWebSocketBuilder.toHandshakeException((UpgradeException)ex));
                } else {
                    future.completeExceptionally((Throwable)ex);
                }
                return null;
            })).thenCompose(ws -> {
                future.complete(ws);
                return future;
            });
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public JettyWebSocketBuilder subprotocol(String protocol) {
        this.subprotocol = protocol;
        return this;
    }

    private static WebSocketHandshakeException toHandshakeException(UpgradeException ex) {
        return new WebSocketHandshakeException(new JettyHttpResponse<Object>((HttpRequest)((StandardHttpRequest.Builder)new StandardHttpRequest.Builder().uri(ex.getRequestURI())).build(), (Response)new HttpResponse(null, Collections.emptyList()).status(ex.getResponseStatusCode()), null)).initCause((Throwable)ex);
    }
}

