/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.jetty;

import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.eclipse.jetty.client.api.Response;

public class JettyHttpResponse<T>
implements HttpResponse<T> {
    private final HttpRequest request;
    private final Response response;
    private final T body;

    public JettyHttpResponse(HttpRequest request, Response response, T body) {
        this.request = request;
        this.response = response;
        this.body = body;
    }

    public List<String> headers(String key) {
        return this.response.getHeaders().getValuesList(key);
    }

    public Map<String, List<String>> headers() {
        return this.response.getHeaders().stream().reduce(new HashMap(), (m, e) -> {
            m.compute(e.getName(), (k, v) -> {
                if (v == null) {
                    v = new ArrayList<String>();
                }
                v.add(e.getValue());
                return v;
            });
            return m;
        }, (m1, m2) -> m1);
    }

    public int code() {
        return this.response.getStatus();
    }

    public T body() {
        return this.body;
    }

    public HttpRequest request() {
        return this.request;
    }

    public Optional<HttpResponse<?>> previousResponse() {
        return Optional.empty();
    }

    static enum SupportedResponse {
        TEXT(String.class, (r, bytes) -> new String((byte[])bytes, SupportedResponse.responseCharset(r))),
        INPUT_STREAM(ByteArrayInputStream.class, (r, bytes) -> new ByteArrayInputStream((byte[])bytes)),
        READER(InputStreamReader.class, (r, bytes) -> new InputStreamReader((InputStream)new ByteArrayInputStream((byte[])bytes), SupportedResponse.responseCharset(r))),
        BYTE_ARRAY(byte[].class, (r, bytes) -> bytes);

        private final Class<?> type;
        private final BiFunction<Response, byte[], Object> processor;

        private SupportedResponse(Class<?> type, BiFunction<Response, byte[], Object> processor) {
            this.type = type;
            this.processor = processor;
        }

        public <T> T process(Response response, byte[] bytes, Class<T> type) {
            return type.cast(this.processor.apply(response, bytes));
        }

        static SupportedResponse from(Class<?> type) {
            for (SupportedResponse sr : SupportedResponse.values()) {
                if (!type.isAssignableFrom(sr.type)) continue;
                return sr;
            }
            throw new IllegalArgumentException("Unsupported response type: " + type.getName());
        }

        private static Charset responseCharset(Response response) {
            Charset responseCharset = StandardCharsets.UTF_8;
            String responseEncoding = response.getHeaders().get("Content-Encoding");
            if (Utils.isNotNullOrEmpty((String)responseEncoding)) {
                try {
                    responseCharset = Charset.forName(responseEncoding);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return responseCharset;
        }
    }
}

