/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.jetty;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.jetty.JettyHttpResponse;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;

public abstract class JettyAsyncResponseListener<T>
extends Response.Listener.Adapter
implements HttpClient.AsyncBody {
    private final HttpRequest httpRequest;
    private final HttpClient.BodyConsumer<T> bodyConsumer;
    private final CompletableFuture<HttpResponse<HttpClient.AsyncBody>> asyncResponse;
    private final CompletableFuture<Void> asyncBodyDone;
    private boolean consume;

    JettyAsyncResponseListener(HttpRequest httpRequest, HttpClient.BodyConsumer<T> bodyConsumer) {
        this.httpRequest = httpRequest;
        this.bodyConsumer = bodyConsumer;
        this.asyncResponse = new CompletableFuture();
        this.asyncBodyDone = new CompletableFuture();
        this.consume = false;
    }

    public synchronized void consume() {
        this.consume = true;
        ((Object)((Object)this)).notifyAll();
    }

    public CompletableFuture<Void> done() {
        return this.asyncBodyDone;
    }

    public void cancel() {
        this.asyncBodyDone.cancel(false);
    }

    public void onBegin(Response response) {
        this.asyncResponse.complete(new JettyHttpResponse<JettyAsyncResponseListener>(this.httpRequest, response, this));
    }

    public void onComplete(Result result) {
        this.asyncBodyDone.complete(null);
    }

    public CompletableFuture<HttpResponse<HttpClient.AsyncBody>> listen(Request request) {
        request.send((Response.CompleteListener)this);
        return this.asyncResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onContent(Response response, ByteBuffer content) {
        try {
            JettyAsyncResponseListener jettyAsyncResponseListener = this;
            synchronized (jettyAsyncResponseListener) {
                while (!this.consume && !this.asyncBodyDone.isCancelled()) {
                    ((Object)((Object)this)).wait();
                }
            }
            if (!this.asyncBodyDone.isCancelled()) {
                this.bodyConsumer.consume(this.process(response, content), (HttpClient.AsyncBody)this);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    protected abstract T process(Response var1, ByteBuffer var2);
}

