/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.jdkhttp;

import io.fabric8.kubernetes.client.http.HttpRequest;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Flow;

class JdkHttpRequestImpl
implements HttpRequest {
    private BuilderImpl builder;
    java.net.http.HttpRequest request;

    public JdkHttpRequestImpl(BuilderImpl builder, java.net.http.HttpRequest request) {
        this.builder = builder;
        this.request = request;
    }

    public List<String> headers(String key) {
        return this.request.headers().allValues(key);
    }

    public Map<String, List<String>> headers() {
        return this.request.headers().map();
    }

    public URI uri() {
        return this.request.uri();
    }

    public String method() {
        return this.request.method();
    }

    public String bodyString() {
        if (this.builder == null) {
            return null;
        }
        return this.builder.bodyString;
    }

    BuilderImpl newBuilder() {
        return new BuilderImpl(this.builder);
    }

    public static class BuilderImpl
    implements HttpRequest.Builder {
        private String bodyString;
        private HttpRequest.Builder builder;

        public BuilderImpl() {
            this.builder = java.net.http.HttpRequest.newBuilder();
        }

        public BuilderImpl(BuilderImpl builderImpl) {
            this.bodyString = builderImpl.bodyString;
            this.builder = builderImpl.builder.copy();
        }

        public JdkHttpRequestImpl build() {
            return new JdkHttpRequestImpl(this, this.builder.build());
        }

        public HttpRequest.Builder uri(String uri) {
            return this.uri(URI.create(uri));
        }

        public HttpRequest.Builder url(URL url) {
            return this.uri(url.toString());
        }

        public HttpRequest.Builder uri(URI uri) {
            this.builder.uri(uri);
            return this;
        }

        public HttpRequest.Builder method(String method, String contentType, String body) {
            this.bodyString = body;
            this.builder.setHeader("Content-Type", contentType).method(method, HttpRequest.BodyPublishers.ofString(body));
            return this;
        }

        public HttpRequest.Builder post(String contentType, byte[] writeValueAsBytes) {
            this.bodyString = null;
            this.builder.setHeader("Content-Type", contentType).POST(HttpRequest.BodyPublishers.ofByteArray(writeValueAsBytes));
            return this;
        }

        public HttpRequest.Builder post(String contentType, InputStream stream, final long length) {
            this.bodyString = null;
            final HttpRequest.BodyPublisher publisher = HttpRequest.BodyPublishers.ofInputStream(() -> stream);
            this.builder.setHeader("Content-Type", contentType).POST(new HttpRequest.BodyPublisher(){

                @Override
                public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
                    publisher.subscribe(subscriber);
                }

                @Override
                public long contentLength() {
                    return length;
                }
            });
            return this;
        }

        public HttpRequest.Builder header(String k, String v) {
            this.builder.header(k, v);
            return this;
        }

        public HttpRequest.Builder setHeader(String k, String v) {
            this.builder.setHeader(k, v);
            return this;
        }

        public HttpRequest.Builder timeout(Duration duration) {
            if (duration != null) {
                this.builder.timeout(duration);
            }
            return this;
        }

        public HttpRequest.Builder expectContinue() {
            this.builder.expectContinue(true);
            return this;
        }
    }
}

