/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.jdkhttp;

import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.jdkhttp.JdkHttpClientImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class JdkWebSocketImpl
implements io.fabric8.kubernetes.client.http.WebSocket {
    private WebSocket webSocket;
    private AtomicLong queueSize;

    public JdkWebSocketImpl(AtomicLong queueSize, WebSocket webSocket) {
        this.queueSize = queueSize;
        this.webSocket = webSocket;
    }

    public boolean send(ByteBuffer buffer) {
        int size = buffer.remaining();
        this.queueSize.addAndGet(size);
        CompletableFuture<WebSocket> cf = this.webSocket.sendBinary(buffer, true);
        cf.whenComplete((b, t) -> this.queueSize.addAndGet(-size));
        return this.asBoolean(cf);
    }

    private boolean asBoolean(CompletableFuture<WebSocket> cf) {
        try {
            cf.getNow(null);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean sendClose(int code, String reason) {
        CompletableFuture<WebSocket> cf = this.webSocket.sendClose(code, reason == null ? "Closing" : reason);
        cf.thenRunAsync(() -> this.webSocket.abort(), CompletableFuture.delayedExecutor(1L, TimeUnit.MINUTES));
        return this.asBoolean(cf);
    }

    public long queueSize() {
        return this.queueSize.get();
    }

    public void request() {
        this.webSocket.request(1L);
    }

    static final class ListenerAdapter
    implements WebSocket.Listener {
        private final WebSocket.Listener listener;
        private final AtomicLong queueSize;
        private final StringBuilder stringBuilder = new StringBuilder();
        private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        private final WritableByteChannel byteChannel = Channels.newChannel(this.byteArrayOutputStream);

        ListenerAdapter(WebSocket.Listener listener, AtomicLong queueSize) {
            this.listener = listener;
            this.queueSize = queueSize;
        }

        @Override
        public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
            try {
                this.byteChannel.write(data);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (last) {
                ByteBuffer value = ByteBuffer.wrap(this.byteArrayOutputStream.toByteArray());
                this.byteArrayOutputStream.reset();
                this.listener.onMessage((io.fabric8.kubernetes.client.http.WebSocket)new JdkWebSocketImpl(this.queueSize, webSocket), value);
            } else {
                webSocket.request(1L);
            }
            return null;
        }

        @Override
        public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
            this.stringBuilder.append(data);
            if (last) {
                String value = this.stringBuilder.toString();
                this.stringBuilder.setLength(0);
                this.listener.onMessage((io.fabric8.kubernetes.client.http.WebSocket)new JdkWebSocketImpl(this.queueSize, webSocket), value);
            } else {
                webSocket.request(1L);
            }
            return null;
        }

        @Override
        public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
            this.listener.onClose((io.fabric8.kubernetes.client.http.WebSocket)new JdkWebSocketImpl(this.queueSize, webSocket), statusCode, reason);
            return null;
        }

        @Override
        public void onError(WebSocket webSocket, Throwable error) {
            this.listener.onError((io.fabric8.kubernetes.client.http.WebSocket)new JdkWebSocketImpl(this.queueSize, webSocket), error);
        }

        @Override
        public void onOpen(WebSocket webSocket) {
            webSocket.request(1L);
            this.listener.onOpen((io.fabric8.kubernetes.client.http.WebSocket)new JdkWebSocketImpl(this.queueSize, webSocket));
        }
    }

    static class BuilderImpl
    implements WebSocket.Builder {
        private JdkHttpClientImpl httpClientImpl;
        private HttpRequest.Builder builder;
        String subprotocol;

        public BuilderImpl(JdkHttpClientImpl jdkHttpClientImpl) {
            this(jdkHttpClientImpl, HttpRequest.newBuilder());
        }

        public BuilderImpl(JdkHttpClientImpl httpClientImpl, HttpRequest.Builder copy) {
            this.httpClientImpl = httpClientImpl;
            this.builder = copy;
        }

        public CompletableFuture<io.fabric8.kubernetes.client.http.WebSocket> buildAsync(WebSocket.Listener listener) {
            return this.httpClientImpl.buildAsync(this, listener);
        }

        public WebSocket.Builder header(String name, String value) {
            this.builder.header(name, value);
            return this;
        }

        public WebSocket.Builder setHeader(String k, String v) {
            this.builder.setHeader(k, v);
            return this;
        }

        public WebSocket.Builder uri(URI uri) {
            this.builder.uri(uri);
            return this;
        }

        public BuilderImpl subprotocol(String protocol) {
            this.subprotocol = protocol;
            return this;
        }

        public HttpRequest asRequest() {
            return this.builder.build();
        }

        public BuilderImpl copy() {
            return new BuilderImpl(this.httpClientImpl, this.builder.copy()).subprotocol(this.subprotocol);
        }
    }
}

