/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.generator.processor;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.generator.annotation.KubernetesProvider;
import io.fabric8.kubernetes.generator.processor.AbstractKubernetesAnnotationProcessor;
import io.fabric8.kubernetes.generator.processor.CompilationTaskFactory;
import io.fabric8.utils.Files;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaCompiler;

@SupportedAnnotationTypes(value={"io.fabric8.kubernetes.generator.annotation.KubernetesProvider"})
public class KubernetesProviderProcessor
extends AbstractKubernetesAnnotationProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        void var6_10;
        StringWriter writer;
        block16: {
            void var8_18;
            String string;
            boolean bl;
            CompilationTaskFactory compilationTaskFactory = new CompilationTaskFactory(this.processingEnv);
            HashSet<TypeElement> providers = new HashSet<TypeElement>();
            for (Element element : roundEnv.getElementsAnnotatedWith(KubernetesProvider.class)) {
                providers.add(this.getClassElement(element));
            }
            if (providers.isEmpty()) {
                return true;
            }
            writer = new StringWriter();
            try {
                JavaCompiler.CompilationTask compilationTask = compilationTaskFactory.create(providers, writer);
                if (((Boolean)compilationTask.call()).booleanValue()) break block16;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to compile provider classes. See output below.");
                bl = false;
                string = writer.toString();
            }
            catch (Exception exception) {
                void var8_21;
                String string2;
                boolean bl2;
                try {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error to compile provider classes, due to: " + exception.getMessage() + ". See output below.");
                    bl2 = false;
                    string2 = writer.toString();
                }
                catch (Throwable throwable) {
                    String output = writer.toString();
                    if (Strings.isNullOrBlank((String)output)) {
                        output = "success";
                    }
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Fabric8 model generator compiler output:" + output);
                    throw throwable;
                }
                if (Strings.isNullOrBlank((String)string2)) {
                    String string3 = "success";
                }
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Fabric8 model generator compiler output:" + (String)var8_21);
                return bl2;
            }
            if (Strings.isNullOrBlank((String)string)) {
                String string4 = "success";
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Fabric8 model generator compiler output:" + (String)var8_18);
            return bl;
        }
        String string = writer.toString();
        if (Strings.isNullOrBlank((String)string)) {
            String string5 = "success";
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Fabric8 model generator compiler output:" + (String)var6_10);
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        for (Element element : roundEnv.getElementsAnnotatedWith(KubernetesProvider.class)) {
            try {
                if (!(element instanceof ExecutableElement)) continue;
                Set provided = this.getProvidedSet(hashMap, element);
                ExecutableElement methodElement = (ExecutableElement)element;
                String methodName = methodElement.getSimpleName().toString();
                TypeElement classElement = this.getClassElement(element);
                Class<?> cls = Class.forName(classElement.getQualifiedName().toString());
                Object instance = cls.newInstance();
                Method providerMethod = instance.getClass().getDeclaredMethod(methodName, new Class[0]);
                if (providerMethod == null) continue;
                providerMethod.setAccessible(true);
                provided.add(providerMethod.invoke(instance, new Object[0]));
            }
            catch (Exception ex) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error creating Kubernetes configuration.");
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            try {
                KubernetesResource answer = (KubernetesResource)KubernetesHelper.combineJson((Object[])((Set)entry.getValue()).toArray());
                this.generateKubernetesManifest((String)entry.getKey(), answer);
            }
            catch (Exception e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to combine provider items");
                return false;
            }
        }
        return true;
    }

    private void generateKubernetesManifest(String fileName, KubernetesResource resource) {
        AbstractKubernetesAnnotationProcessor.FileExtension ext = AbstractKubernetesAnnotationProcessor.FileExtension.determineExtension(Files.getFileExtension((File)new File(fileName)));
        switch (ext) {
            case JSON: {
                this.generateJson(fileName, resource);
                break;
            }
            case YAML: {
                this.generateYaml(fileName, resource);
                break;
            }
            case UNDEFINED: {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "could not determine file extension for " + fileName + ". Is it .json, .yaml, or .yml?");
            }
        }
    }

    private Set getProvidedSet(Map<String, Set> providedMap, Element element) {
        KubernetesProvider providerAnnotation = element.getAnnotation(KubernetesProvider.class);
        String kubernetesFile = providerAnnotation.value().trim();
        if (providedMap.containsKey(kubernetesFile)) {
            return providedMap.get(kubernetesFile);
        }
        LinkedHashSet rc = new LinkedHashSet();
        providedMap.put(kubernetesFile, rc);
        return rc;
    }
}

