/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.generator.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.fabric8.KubernetesJson;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.generator.annotation.KubernetesProvider;
import io.fabric8.kubernetes.generator.processor.AbstractKubernetesAnnotationProcessor;
import io.fabric8.kubernetes.generator.processor.CompilationTaskFactory;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.Route;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaCompiler;
import javax.xml.ws.Service;

@SupportedAnnotationTypes(value={"io.fabric8.kubernetes.generator.annotation.KubernetesProvider"})
public class KubernetesProviderProcessor
extends AbstractKubernetesAnnotationProcessor {
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        LinkedHashSet<Object> provided = new LinkedHashSet<Object>();
        CompilationTaskFactory compilationTaskFactory = new CompilationTaskFactory(this.processingEnv);
        HashSet<TypeElement> providers = new HashSet<TypeElement>();
        for (Element element : roundEnv.getElementsAnnotatedWith(KubernetesProvider.class)) {
            providers.add(this.getClassElement(element));
        }
        if (providers.isEmpty()) {
            return true;
        }
        try {
            JavaCompiler.CompilationTask compileTask = compilationTaskFactory.create(providers);
            if (!((Boolean)compileTask.call()).booleanValue()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to compile provider classes");
                return false;
            }
        }
        catch (Exception e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to compile provider classes");
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(KubernetesProvider.class)) {
            try {
                Object obj;
                if (!(element instanceof ExecutableElement)) continue;
                KubernetesProvider provider = element.getAnnotation(KubernetesProvider.class);
                ExecutableElement methodElement = (ExecutableElement)element;
                String methodName = methodElement.getSimpleName().toString();
                TypeElement classElement = this.getClassElement(element);
                Class<?> cls = Class.forName(classElement.getQualifiedName().toString());
                Object instance = cls.newInstance();
                Method providerMethod = instance.getClass().getDeclaredMethod(methodName, new Class[0]);
                if (providerMethod == null || (obj = providerMethod.invoke(instance, new Object[0])) == null) continue;
                provided.add(obj);
            }
            catch (Exception ex) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error creating Kubernetes configuration.");
            }
        }
        KubernetesList list = this.createList(provided);
        this.generateJson((KubernetesJson)list);
        return true;
    }

    private KubernetesList createList(Iterable<Object> objects) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> allItems = new ArrayList<Object>();
        boolean first = true;
        for (Object obj : objects) {
            if (first) {
                first = false;
            } else {
                sb.append("-");
            }
            if (obj instanceof Pod) {
                sb.append(KubernetesHelper.getName((Pod)((Pod)obj)));
                allItems.add(obj);
                continue;
            }
            if (obj instanceof ReplicationController) {
                sb.append(KubernetesHelper.getName((ReplicationController)((ReplicationController)obj)));
                allItems.add(obj);
                continue;
            }
            if (obj instanceof Service) {
                sb.append(((Service)obj).getServiceName());
                allItems.add(obj);
                continue;
            }
            if (obj instanceof BuildConfig) {
                sb.append(((BuildConfig)obj).getMetadata().getName());
                allItems.add(obj);
                continue;
            }
            if (obj instanceof DeploymentConfig) {
                sb.append(((DeploymentConfig)obj).getMetadata().getName());
                allItems.add(obj);
                continue;
            }
            if (obj instanceof ImageStream) {
                sb.append(KubernetesHelper.getName((ImageStream)((ImageStream)obj)));
                allItems.add(obj);
                continue;
            }
            if (obj instanceof Route) {
                sb.append(((Route)obj).getMetadata().getName());
                allItems.add(obj);
                continue;
            }
            if (!(obj instanceof KubernetesList)) continue;
            allItems.addAll(((KubernetesList)obj).getItems());
        }
        return ((KubernetesListBuilder)new KubernetesListBuilder().withItems(allItems)).build();
    }
}

