/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.Serialization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceExamples {
    private static final Logger logger = LoggerFactory.getLogger(ReplaceExamples.class);
    private static final String NAMESPACE = "this-is-a-test";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ConfigBuilder configBuilder = new ConfigBuilder();
        if (args.length > 0) {
            configBuilder.withMasterUrl(args[0]);
            logger.info("Using master with URL: {}", (Object)args[0]);
        }
        try (KubernetesClient client = new KubernetesClientBuilder().withConfig(configBuilder.build()).build();){
            try {
                Namespace namespace = (Namespace)((Resource)client.namespaces().resource((Object)((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(NAMESPACE)).endMetadata()).build())).create();
                logger.info("Create namespace: {}", (Object)NAMESPACE);
                Pod createdPod = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace.getMetadata().getName())).resource((Object)((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("test-pod")).addToLabels("server", "nginx")).endMetadata()).withNewSpec().addNewContainer().withName("nginx")).withImage("nginx")).addNewPort().withContainerPort(Integer.valueOf(80))).endPort()).endContainer()).endSpec()).build())).create();
                logger.info("Created Pod: {}", (Object)createdPod.getMetadata().getName());
                logger.info(Serialization.asYaml((Object)createdPod));
                Pod updatedPod = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(NAMESPACE)).withName("test-pod")).edit(p -> ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(p).editMetadata().addToLabels("server2", "nginx2")).and()).build());
                logger.info("Replaced Pod: {}", (Object)updatedPod.getMetadata().getName());
                logger.info(Serialization.asYaml((Object)updatedPod));
            }
            catch (KubernetesClientException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                ((Resource)client.namespaces().withName(NAMESPACE)).delete();
            }
        }
    }
}

