/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.examples.TemplateExample;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadExample {
    private static final Logger logger = LoggerFactory.getLogger(LoadExample.class);
    private static final String LOADED_RESOURCE = "/test-template.yml";

    public static void main(String[] args) {
        ConfigBuilder configBuilder = new ConfigBuilder();
        if (args.length > 0) {
            configBuilder.withMasterUrl(args[0]);
        }
        try (KubernetesClient kubernetesClient = new KubernetesClientBuilder().withConfig(configBuilder.build()).build();){
            OpenShiftClient client = (OpenShiftClient)kubernetesClient.adapt(OpenShiftClient.class);
            List list = (List)client.load(TemplateExample.class.getResourceAsStream(LOADED_RESOURCE)).get();
            logger.info("Found in file: {} items.", (Object)list.size());
            list.stream().map(LoadExample::display).forEach(arg_0 -> ((Logger)logger).info(arg_0));
            List visitedList = (List)((ListVisitFromServerGetDeleteRecreateWaitApplicable)client.load(TemplateExample.class.getResourceAsStream(LOADED_RESOURCE)).accept(new Visitor[]{new Visitor<ObjectMetaBuilder>(){

                public void visit(ObjectMetaBuilder item) {
                    item.addToLabels("visitorkey", "visitorvalue");
                }
            }})).get();
            logger.info("Visited: {} items.", (Object)visitedList.size());
            visitedList.stream().map(LoadExample::display).forEach(arg_0 -> ((Logger)logger).info(arg_0));
            List fromServerList = (List)client.load(TemplateExample.class.getResourceAsStream(LOADED_RESOURCE)).get();
            logger.info("Found on server: {} items.", (Object)fromServerList.size());
            fromServerList.stream().map(LoadExample::display).forEach(arg_0 -> ((Logger)logger).info(arg_0));
            List appliedList = (List)client.load(TemplateExample.class.getResourceAsStream(LOADED_RESOURCE)).createOrReplace();
            logger.info("Applied: {} items.", (Object)appliedList.size());
            appliedList.stream().map(LoadExample::display).forEach(arg_0 -> ((Logger)logger).info(arg_0));
            client.load(TemplateExample.class.getResourceAsStream(LOADED_RESOURCE)).delete();
        }
    }

    private static String display(HasMetadata item) {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        if (Utils.isNotNullOrEmpty((String)item.getKind())) {
            sb.append("Kind:").append(item.getKind());
        }
        if (Utils.isNotNullOrEmpty((String)item.getMetadata().getName())) {
            sb.append("Name:").append(item.getMetadata().getName());
        }
        if (item.getMetadata().getLabels() != null && !item.getMetadata().getLabels().isEmpty()) {
            sb.append("Labels: [ ");
            for (Map.Entry entry : item.getMetadata().getLabels().entrySet()) {
                sb.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append(" ");
            }
            sb.append("]");
        }
        sb.append(" ]");
        return sb.toString();
    }
}

