/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericKubernetesResourceExample {
    private static final Logger logger = LoggerFactory.getLogger(GenericKubernetesResourceExample.class);

    public static void main(String[] args) throws Exception {
        ConfigBuilder configBuilder = new ConfigBuilder();
        configBuilder.withWatchReconnectInterval(Integer.valueOf(500));
        configBuilder.withWatchReconnectLimit(Integer.valueOf(5));
        try (KubernetesClient client = new KubernetesClientBuilder().withConfig(configBuilder.build()).build();){
            String namespace = "default";
            CustomResourceDefinition prometheousRuleCrd = (CustomResourceDefinition)((Resource)client.apiextensions().v1beta1().customResourceDefinitions().load(GenericKubernetesResourceExample.class.getResourceAsStream("/prometheous-rule-crd.yml"))).item();
            ((Resource)client.apiextensions().v1beta1().customResourceDefinitions().resource((Object)prometheousRuleCrd)).createOrReplace();
            logger.info("Successfully created Prometheous custom resource definition");
            CustomResourceDefinitionContext crdContext = CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)prometheousRuleCrd);
            ((ListVisitFromServerGetDeleteRecreateWaitApplicable)client.load(GenericKubernetesResourceExample.class.getResourceAsStream("/prometheous-rule-cr.yml")).inNamespace(namespace)).createOrReplace();
            logger.info("Created Custom Resource successfully too");
            NonNamespaceOperation resourcesInNamespace = (NonNamespaceOperation)client.genericKubernetesResources((ResourceDefinitionContext)crdContext).inNamespace(namespace);
            GenericKubernetesResourceList list = (GenericKubernetesResourceList)resourcesInNamespace.list();
            List items = list.getItems();
            logger.info("Custom Resources :- ");
            for (GenericKubernetesResource customResource : items) {
                ObjectMeta metadata = customResource.getMetadata();
                String name = metadata.getName();
                logger.info(name);
            }
            logger.info("Watching custom resources now");
            final CountDownLatch closeLatch = new CountDownLatch(1);
            Watch watch = resourcesInNamespace.watch((Watcher)new Watcher<GenericKubernetesResource>(){

                public void eventReceived(Watcher.Action action, GenericKubernetesResource resource) {
                    logger.info("{}: {}", (Object)action, (Object)resource);
                }

                public void onClose(WatcherException e) {
                    logger.debug("Watcher onClose");
                    closeLatch.countDown();
                    if (e != null) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
            closeLatch.await(10L, TimeUnit.MINUTES);
            watch.close();
            logger.info("Deleting custom resources...");
            ((Resource)resourcesInNamespace.withName("prometheus-example-rules")).delete();
            ((Resource)client.apiextensions().v1beta1().customResourceDefinitions().withName(prometheousRuleCrd.getMetadata().getName())).delete();
        }
        catch (KubernetesClientException e) {
            logger.error("Could not create resource: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

