/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatePod {
    private static final Logger logger = LoggerFactory.getLogger(CreatePod.class);

    public static void main(String[] args) {
        File file;
        if (args.length == 0) {
            logger.warn("Usage: podJsonFileName <token> <namespace>");
            return;
        }
        String fileName = args[0];
        String namespace = null;
        if (args.length > 2) {
            namespace = args[2];
        }
        if (!(file = new File(fileName)).exists() || !file.isFile()) {
            logger.warn("File does not exist: {}", (Object)fileName);
            return;
        }
        ConfigBuilder builder = new ConfigBuilder();
        if (args.length > 1) {
            builder.withOauthToken(args[1]);
        }
        Config config = builder.build();
        try (KubernetesClient client = new KubernetesClientBuilder().withConfig(config).build();){
            List resources;
            if (namespace == null) {
                namespace = client.getNamespace();
            }
            if ((resources = client.load((InputStream)new FileInputStream(fileName)).items()).isEmpty()) {
                logger.error("No resources loaded from file: {}", (Object)fileName);
                return;
            }
            HasMetadata resource = (HasMetadata)resources.get(0);
            if (resource instanceof Pod) {
                Pod pod = (Pod)resource;
                logger.info("Creating pod in namespace {}", (Object)namespace);
                NonNamespaceOperation pods = (NonNamespaceOperation)client.pods().inNamespace(namespace);
                Pod result = (Pod)((PodResource)pods.resource((Object)pod)).create();
                logger.info("Created pod {}", (Object)result.getMetadata().getName());
            } else {
                logger.error("Loaded resource is not a Pod! {}", (Object)resource);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

