/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListImageStreams {
    private static final Logger logger = LoggerFactory.getLogger(ListImageStreams.class);

    public static void main(String[] args) {
        try (DefaultOpenShiftClient client = new DefaultOpenShiftClient();){
            if (!client.supportsOpenShiftAPIGroup("image.openshift.io")) {
                logger.warn("This cluster does not support the API Group {}", (Object)"image.openshift.io");
                return;
            }
            ImageStreamList list = (ImageStreamList)client.imageStreams().list();
            if (list == null) {
                logger.error("No list returned!");
                return;
            }
            List items = list.getItems();
            for (ImageStream item : items) {
                logger.info("ImageStream {} has version: {}", (Object)item.getMetadata().getName(), (Object)item.getApiVersion());
            }
            logger.info("Found {}  ImageStream(s)", (Object)items.size());
        }
        catch (KubernetesClientException e) {
            logger.error("Failed: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

