/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ExecListenable;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorChannelable;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.kubernetes.client.dsl.TtyExecOutputErrorable;

public class ExecExample {
    public static void main(String[] args) throws InterruptedException {
        if (args.length < 1) {
            System.out.println("Usage: podName [namespace]");
            return;
        }
        String podName = args[0];
        String namespace = "default";
        if (args.length > 1) {
            namespace = args[1];
        }
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();
             ExecWatch watch = ExecExample.newExecWatch((KubernetesClient)client, namespace, podName);){
            Thread.sleep(10000L);
        }
    }

    private static ExecWatch newExecWatch(KubernetesClient client, String namespace, String podName) {
        return (ExecWatch)((Execable)((ExecListenable)((TtyExecErrorChannelable)((TtyExecErrorable)((TtyExecOutputErrorable)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(podName)).readingInput((Object)System.in)).writingOutput((Object)System.out)).writingError((Object)System.err)).withTTY()).usingListener((Object)new SimpleListener())).exec((Object[])new String[]{"sh", "-c", "echo 'Hello world!'"});
    }

    private static class SimpleListener
    implements ExecListener {
        private SimpleListener() {
        }

        public void onOpen() {
            System.out.println("The shell will remain open for 10 seconds.");
        }

        public void onFailure(Throwable t, ExecListener.Response failureResponse) {
            System.err.println("shell barfed");
        }

        public void onClose(int code, String reason) {
            System.out.println("The shell will now close.");
        }
    }
}

