/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesVersionExample {
    private static final Logger logger = LoggerFactory.getLogger(KubernetesVersionExample.class);

    public static void main(String[] args) {
        ConfigBuilder configBuilder = new ConfigBuilder();
        if (args.length > 0) {
            configBuilder.withMasterUrl(args[0]);
        }
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(configBuilder.build());){
            VersionInfo versionInfo = client.getVersion();
            logger.info("Version details of this Kubernetes cluster :-");
            logger.info("Major        : {}", (Object)versionInfo.getMajor());
            logger.info("Minor        : {}", (Object)versionInfo.getMinor());
            logger.info("GitVersion   : {}", (Object)versionInfo.getGitVersion());
            logger.info("BuildDate    : {}", (Object)versionInfo.getBuildDate());
            logger.info("GitTreeState : {}", (Object)versionInfo.getGitTreeState());
            logger.info("Platform     : {}", (Object)versionInfo.getPlatform());
            logger.info("GitVersion   : {}", (Object)versionInfo.getGitVersion());
            logger.info("GoVersion    : {}", (Object)versionInfo.getGoVersion());
            logger.info("GitCommit    : {}", (Object)versionInfo.getGitCommit());
        }
    }
}

