/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.Collections;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceExample {
    private static final Logger logger = LoggerFactory.getLogger(ServiceExample.class);

    public static void main(String[] args) {
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            String namespace = Optional.ofNullable(client.getNamespace()).orElse("default");
            if (args.length > 0) {
                namespace = args[0];
            }
            Service service = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("my-service")).endMetadata()).withNewSpec().withSelector(Collections.singletonMap("app", "MyApp"))).addNewPort().withName("test-port")).withProtocol("TCP")).withPort(Integer.valueOf(80))).withTargetPort(new IntOrString(Integer.valueOf(9376)))).endPort()).withType("LoadBalancer")).endSpec()).build();
            service = (Service)((NonNamespaceOperation)client.services().inNamespace(namespace)).create((Object)service);
            logger.info("Created service with name {}", (Object)service.getMetadata().getName());
            String serviceURL = ((ServiceResource)((NonNamespaceOperation)client.services().inNamespace(namespace)).withName(service.getMetadata().getName())).getURL("test-port");
            logger.info("Service URL {}", (Object)serviceURL);
        }
    }
}

