/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import java.util.List;

public class ListCustomResourceDefinitions {
    public static void main(String[] args) {
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            if (!client.supportsApiPath("/apis/apiextensions.k8s.io/v1beta1") && !client.supportsApiPath("/apis/apiextensions.k8s.io/v1")) {
                System.out.println("WARNING this cluster does not support the API Group apiextensions.k8s.io");
                return;
            }
            CustomResourceDefinitionList list = (CustomResourceDefinitionList)client.customResourceDefinitions().list();
            if (list == null) {
                System.out.println("ERROR no list returned!");
                return;
            }
            List items = list.getItems();
            for (CustomResourceDefinition item : items) {
                System.out.println("CustomResourceDefinition " + item.getMetadata().getName() + " has version: " + item.getApiVersion());
            }
        }
        catch (KubernetesClientException e) {
            System.out.println("Failed: " + (Object)((Object)e));
            e.printStackTrace();
        }
    }
}

