/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluent;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePortFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.client.APIGroupNotAvailableException;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.WatchAndWaitable;
import io.fabric8.kubernetes.client.internal.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullExample {
    private static final Logger logger = LoggerFactory.getLogger(FullExample.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        block33: {
            String master = "https://localhost:8443/";
            if (args.length == 1) {
                master = args[0];
            }
            Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
            try (DefaultKubernetesClient client = new DefaultKubernetesClient(config);){
                try (Watch watch = ((WatchAndWaitable)((NonNamespaceOperation)client.replicationControllers().inNamespace("thisisatest")).withResourceVersion("0")).watch((Object)new Watcher<ReplicationController>(){

                    public void eventReceived(Watcher.Action action, ReplicationController resource) {
                        logger.info("{}: {}", (Object)action, (Object)resource);
                    }

                    public void onClose(WatcherException e) {
                        if (e != null) {
                            e.printStackTrace();
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                });){
                    Namespace ns = ((NamespaceBuilder)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName("thisisatest")).addToLabels("this", "rocks")).endMetadata()).build();
                    FullExample.log("Created namespace", client.namespaces().create((Object)ns));
                    FullExample.log("Get namespace by name", ((Resource)client.namespaces().withName("thisisatest")).get());
                    FullExample.log("Get namespace by label", ((FilterWatchListDeletable)client.namespaces().withLabel("this", "rocks")).list());
                    ResourceQuota quota = ((ResourceQuotaBuilder)((ResourceQuotaFluent.SpecNested)((ResourceQuotaBuilder)((ResourceQuotaFluent.MetadataNested)new ResourceQuotaBuilder().withNewMetadata().withName("pod-quota")).endMetadata()).withNewSpec().addToHard("pods", new Quantity("10"))).endSpec()).build();
                    FullExample.log("Create resource quota", ((NonNamespaceOperation)client.resourceQuotas().inNamespace("thisisatest")).create((Object)quota));
                    try {
                        FullExample.log("Get jobs in namespace", ((NonNamespaceOperation)client.batch().jobs().inNamespace("thisisatest")).list());
                    }
                    catch (APIGroupNotAvailableException e) {
                        FullExample.log("Skipping jobs example - extensions API group not available");
                    }
                    ReplicationController rc = ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName("nginx-controller")).addToLabels("server", "nginx")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(3))).withNewTemplate().withNewMetadata().addToLabels("server", "nginx")).endMetadata()).withNewSpec().addNewContainer().withName("nginx")).withImage("nginx")).addNewPort().withContainerPort(Integer.valueOf(80))).endPort()).endContainer()).endSpec()).endTemplate()).endSpec()).build();
                    FullExample.log("Created RC", ((NonNamespaceOperation)client.replicationControllers().inNamespace("thisisatest")).create((Object)rc));
                    FullExample.log("Created RC with inline DSL", ((NonNamespaceOperation)client.replicationControllers().inNamespace("thisisatest")).create((Object)((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName("nginx2-controller")).addToLabels("server", "nginx")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(0))).withNewTemplate().withNewMetadata().addToLabels("server", "nginx2")).endMetadata()).withNewSpec().addNewContainer().withName("nginx")).withImage("nginx")).addNewPort().withContainerPort(Integer.valueOf(80))).endPort()).endContainer()).endSpec()).endTemplate()).endSpec()).build()));
                    ReplicationController gotRc = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)client.replicationControllers().inNamespace("thisisatest")).withName("nginx-controller")).get();
                    FullExample.log("Get RC by name in namespace", gotRc);
                    FullExample.log("Dump RC as YAML", SerializationUtils.dumpAsYaml((HasMetadata)gotRc));
                    FullExample.log("Dump RC as YAML without state", SerializationUtils.dumpWithoutRuntimeStateAsYaml((HasMetadata)gotRc));
                    FullExample.log("Get RC by label", ((FilterWatchListDeletable)client.replicationControllers().withLabel("server", "nginx")).list());
                    FullExample.log("Get RC without label", ((FilterWatchListDeletable)client.replicationControllers().withoutLabel("server", "apache")).list());
                    FullExample.log("Get RC with label in", ((FilterWatchListDeletable)client.replicationControllers().withLabelIn("server", new String[]{"nginx"})).list());
                    FullExample.log("Get RC with label not in", ((FilterWatchListDeletable)client.replicationControllers().withLabelNotIn("server", new String[]{"apache"})).list());
                    FullExample.log("Get RC by label in namespace", ((FilterWatchListDeletable)((NonNamespaceOperation)client.replicationControllers().inNamespace("thisisatest")).withLabel("server", "nginx")).list());
                    ((EditReplacePatchDeletable)((RollableScalableResource)((NonNamespaceOperation)client.replicationControllers().inNamespace("thisisatest")).withName("nginx-controller")).cascading(false)).edit(r -> ((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder(r).editMetadata().addToLabels("new", "label")).endMetadata()).build());
                    ((RollableScalableResource)((NonNamespaceOperation)client.replicationControllers().inNamespace("thisisatest")).withName("nginx-controller")).scale(8);
                    Thread.sleep(1000L);
                    ((RollableScalableResource)((NonNamespaceOperation)client.replicationControllers().inNamespace("thisisatest")).withName("nginx-controller")).edit(r -> ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)new ReplicationControllerBuilder(r).editSpec().editTemplate().withNewSpec().addNewContainer().withName("nginx")).withImage("httpd")).addNewPort().withContainerPort(Integer.valueOf(80))).endPort()).endContainer()).endSpec()).endTemplate()).endSpec()).build());
                    Thread.sleep(1000L);
                    ((TimeoutImageEditReplacePatchable)((RollableScalableResource)((NonNamespaceOperation)client.replicationControllers().inNamespace("thisisatest")).withName("nginx-controller")).rolling()).updateImage("nginx");
                    Thread.sleep(1000L);
                    ((TimeoutImageEditReplacePatchable)((RollableScalableResource)((NonNamespaceOperation)client.replicationControllers().inNamespace("thisisatest")).withName("nginx-controller")).rolling()).updateImage("nginx:stable-alpine");
                    Thread.sleep(1000L);
                    ((RollableScalableResource)((NonNamespaceOperation)client.replicationControllers().inNamespace("thisisatest")).withName("nginx-controller")).edit(r -> ((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder(r).editMetadata().addToLabels("another", "label")).endMetadata()).build());
                    FullExample.log("Updated RC");
                    ((RollableScalableResource)((NonNamespaceOperation)client.replicationControllers().inNamespace("thisisatest")).withName("nginx-controller")).delete();
                    ((RollableScalableResource)((NonNamespaceOperation)client.replicationControllers().inNamespace("thisisatest")).withName("nginx2-controller")).delete();
                    FullExample.log("Deleted RCs");
                    ((NonNamespaceOperation)client.replicationControllers().inNamespace("thisisatest")).create((Object)((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName("nginx-controller")).addToLabels("server", "nginx")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(3))).withNewTemplate().withNewMetadata().addToLabels("server", "nginx")).endMetadata()).withNewSpec().addNewContainer().withName("nginx")).withImage("nginx")).addNewPort().withContainerPort(Integer.valueOf(80))).endPort()).endContainer()).endSpec()).endTemplate()).endSpec()).build());
                    FullExample.log("Created inline RC");
                    Thread.sleep(1000L);
                    ((RollableScalableResource)((NonNamespaceOperation)client.replicationControllers().inNamespace("thisisatest")).withName("nginx-controller")).delete();
                    FullExample.log("Deleted RC");
                    FullExample.log("Created RC", ((NonNamespaceOperation)client.replicationControllers().inNamespace("thisisatest")).create((Object)rc));
                    ((FilterWatchListDeletable)((FilterWatchListMultiDeletable)client.replicationControllers().inAnyNamespace()).withLabel("server", "nginx")).delete();
                    FullExample.log("Deleted RC by label");
                    FullExample.log("Created RC", ((NonNamespaceOperation)client.replicationControllers().inNamespace("thisisatest")).create((Object)rc));
                    ((FilterWatchListDeletable)((NonNamespaceOperation)client.replicationControllers().inNamespace("thisisatest")).withField("metadata.name", "nginx-controller")).delete();
                    FullExample.log("Deleted RC by field");
                    FullExample.log("Created service", ((NonNamespaceOperation)client.services().inNamespace("thisisatest")).create((Object)((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServicePortFluent.TargetPortNested)((ServiceSpecFluent.PortsNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("testservice")).endMetadata()).withNewSpec().addNewPort().withPort(Integer.valueOf(80))).withNewTargetPort().withIntVal(Integer.valueOf(80))).endTargetPort()).endPort()).endSpec()).build()));
                    FullExample.log("Updated service", ((ServiceResource)((NonNamespaceOperation)client.services().inNamespace("thisisatest")).withName("testservice")).edit(s -> ((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder(s).editMetadata().addToLabels("test", "label")).endMetadata()).build()));
                    ((FilterWatchListDeletable)((NonNamespaceOperation)client.replicationControllers().inNamespace("thisisatest")).withField("metadata.name", "testservice")).delete();
                    FullExample.log("Deleted service by field");
                    FullExample.log("Root paths:", client.rootPaths());
                }
                finally {
                    ((Resource)client.namespaces().withName("thisisatest")).delete();
                    FullExample.log("Deleted namespace");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage(), (Throwable)e);
                Throwable[] suppressed = e.getSuppressed();
                if (suppressed == null) break block33;
                for (Throwable t : suppressed) {
                    logger.error(t.getMessage(), t);
                }
            }
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

