/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRDLoadExample {
    private static Logger logger = LoggerFactory.getLogger(CRDLoadExample.class);

    public static void main(String[] args) throws IOException {
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            CRDLoadExample.log("Listing all current Custom Resource Definitions :");
            CustomResourceDefinitionList crdList = (CustomResourceDefinitionList)client.customResourceDefinitions().list();
            crdList.getItems().forEach(crd -> CRDLoadExample.log(crd.getMetadata().getName()));
            CustomResourceDefinition aCustomResourceDefinition = (CustomResourceDefinition)((Resource)client.customResourceDefinitions().load(CRDLoadExample.class.getResourceAsStream("/crd.yml"))).get();
            CRDLoadExample.log("Creating CRD...");
            client.customResourceDefinitions().create((Object)aCustomResourceDefinition);
            CRDLoadExample.log("Updated Custom Resource Definitions: ");
            ((CustomResourceDefinitionList)client.customResourceDefinitions().list()).getItems().forEach(crd -> CRDLoadExample.log(crd.getMetadata().getName()));
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

