/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.NodeMetricsList;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetrics;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsList;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopExample {
    private static final Logger logger = LoggerFactory.getLogger(TopExample.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            NodeMetricsList nodeMetricList = client.top().nodes().metrics();
            TopExample.log("name CPU(cores) CPU(%) Memory(Bytes) Memory(%)");
            for (Object nodeMetrics : nodeMetricList.getItems()) {
                TopExample.log(nodeMetrics.getMetadata().getName() + " " + nodeMetrics.getUsage().get("cpu") + " " + nodeMetrics.getUsage().get("memory"));
            }
            TopExample.log("==== Pod Metrics ====");
            TopExample.log("name CPU(cores) CPU(%) Memory(Bytes) Memory(%)");
            PodMetricsList podMetricsList = client.top().pods().metrics("default");
            for (PodMetrics podMetrics : podMetricsList.getItems()) {
                TopExample.log(podMetrics.getMetadata().getName());
                List containerMetricsList = podMetrics.getContainers();
                for (ContainerMetrics containerMetric : containerMetricsList) {
                    TopExample.log(podMetrics.getMetadata().getName() + " " + containerMetric.getUsage().get("cpu") + " " + containerMetric.getUsage().get("memory"));
                }
            }
            PodMetrics podMetrics = client.top().pods().metrics("default", "nginx-deployment-54f57cf6bf-gcvzx");
            TopExample.log(" ===== Individual Pod Metrics =====");
            TopExample.log("Pod Name: " + podMetrics.getMetadata().getName());
            List containerMetricsList = podMetrics.getContainers();
            for (ContainerMetrics containerMetric : containerMetricsList) {
                TopExample.log(podMetrics.getMetadata().getName() + " " + containerMetric.getUsage().get("cpu") + " " + containerMetric.getUsage().get("memory"));
            }
        }
        catch (KubernetesClientException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

