/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftVersionExample {
    private static Logger logger = LoggerFactory.getLogger(OpenShiftVersionExample.class);

    public static void main(String[] args) {
        String master = "https://localhost:8443/";
        if (args.length == 1) {
            master = args[0];
        }
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        try (DefaultOpenShiftClient client = new DefaultOpenShiftClient(config);){
            VersionInfo versionInfo = client.getVersion();
            OpenShiftVersionExample.log("Version details of this OpenShift cluster :-");
            OpenShiftVersionExample.log("Major        : ", versionInfo.getMajor());
            OpenShiftVersionExample.log("Minor        : ", versionInfo.getMinor());
            OpenShiftVersionExample.log("GitVersion   : ", versionInfo.getGitVersion());
            OpenShiftVersionExample.log("BuildDate    : ", versionInfo.getBuildDate());
            OpenShiftVersionExample.log("GitTreeState : ", versionInfo.getGitTreeState());
            OpenShiftVersionExample.log("Platform     : ", versionInfo.getPlatform());
            OpenShiftVersionExample.log("GitVersion   : ", versionInfo.getGitVersion());
            OpenShiftVersionExample.log("GoVersion    : ", versionInfo.getGoVersion());
            OpenShiftVersionExample.log("GitCommit    : ", versionInfo.getGitCommit());
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

