/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.batch.Job;
import io.fabric8.kubernetes.api.model.batch.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.JobFluent;
import io.fabric8.kubernetes.api.model.batch.JobSpecFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobExample {
    private static final Logger logger = LoggerFactory.getLogger(JobExample.class);

    public static void main(String[] args) {
        String master = "https://localhost:8443/";
        if (args.length == 1) {
            master = args[0];
        }
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(config);){
            String namespace = "default";
            Job job = ((JobBuilder)((JobFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((JobBuilder)((JobFluent.MetadataNested)((JobFluent.MetadataNested)((JobFluent.MetadataNested)((JobBuilder)new JobBuilder().withApiVersion("batch/v1")).withNewMetadata().withName("pi")).withLabels(Collections.singletonMap("label1", "maximum-length-of-63-characters"))).withAnnotations(Collections.singletonMap("annotation1", "some-very-long-annotation"))).endMetadata()).withNewSpec().withNewTemplate().withNewSpec().addNewContainer().withName("pi")).withImage("perl")).withArgs(new String[]{"perl", "-Mbignum=bpi", "-wle", "print bpi(2000)"})).endContainer()).withRestartPolicy("Never")).endSpec()).endTemplate()).endSpec()).build();
            logger.info("Creating job pi.");
            ((NonNamespaceOperation)client.batch().jobs().inNamespace("default")).create((Object)job);
            PodList podList = (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace("default")).withLabel("job-name", job.getMetadata().getName())).list();
            ((PodResource)((NonNamespaceOperation)client.pods().inNamespace("default")).withName(((Pod)podList.getItems().get(0)).getMetadata().getName())).waitUntilCondition(pod -> pod.getStatus().getPhase().equals("Succeeded"), 1L, TimeUnit.MINUTES);
            String joblog = (String)((ScalableResource)((NonNamespaceOperation)client.batch().jobs().inNamespace("default")).withName("pi")).getLog();
            logger.info(joblog);
        }
        catch (KubernetesClientException e) {
            logger.error("Unable to create job", (Throwable)e);
        }
        catch (InterruptedException interruptedException) {
            logger.warn("Thread interrupted!");
            Thread.currentThread().interrupt();
        }
    }
}

