/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluent;
import io.fabric8.kubernetes.client.APIGroupNotAvailableException;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceQuotaExample {
    private static final Logger logger = LoggerFactory.getLogger(NamespaceQuotaExample.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        block15: {
            String master = "https://localhost:8443";
            if (args.length == 1) {
                master = args[0];
            }
            Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
            try (DefaultKubernetesClient client = new DefaultKubernetesClient(config);){
                String namespace = "namespacetest";
                if (args.length > 2) {
                    namespace = args[2];
                }
                try {
                    Namespace ns = ((NamespaceBuilder)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(namespace)).addToLabels("hello", "world")).endMetadata()).build();
                    NamespaceQuotaExample.log("Created namespace", client.namespaces().create((Object)ns));
                    NamespaceQuotaExample.log("Get namespace by name", ((Resource)client.namespaces().withName(namespace)).get());
                    NamespaceQuotaExample.log("Get namespace by label", ((FilterWatchListDeletable)client.namespaces().withLabel("hello", "world")).list());
                    ResourceQuota quota = ((ResourceQuotaBuilder)((ResourceQuotaFluent.SpecNested)((ResourceQuotaBuilder)((ResourceQuotaFluent.MetadataNested)new ResourceQuotaBuilder().withNewMetadata().withName("quota-example")).endMetadata()).withNewSpec().addToHard("pods", new Quantity("5"))).endSpec()).build();
                    NamespaceQuotaExample.log("Create resource quota", ((NonNamespaceOperation)client.resourceQuotas().inNamespace(namespace)).create((Object)quota));
                    try {
                        NamespaceQuotaExample.log("Get jobs in namespace", ((NonNamespaceOperation)client.batch().jobs().inNamespace(namespace)).list());
                    }
                    catch (APIGroupNotAvailableException e) {
                        NamespaceQuotaExample.log("Skipping jobs example - extensions API group not available");
                    }
                }
                finally {
                    NamespaceQuotaExample.log("Deleted namespace", ((Resource)client.namespaces().withName(namespace)).delete());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage(), (Throwable)e);
                Throwable[] suppressed = e.getSuppressed();
                if (suppressed == null) break block15;
                for (Throwable t : suppressed) {
                    logger.error(t.getMessage(), t);
                }
            }
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

