/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.EditableConfig;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.examples.TemplateExample;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadExample {
    private static final Logger logger = LoggerFactory.getLogger(LoadExample.class);

    public static void main(String[] args) throws InterruptedException {
        String master = "https://localhost:8443/";
        if (args.length == 1) {
            master = args[0];
        }
        EditableConfig config = new ConfigBuilder().build();
        DefaultKubernetesClient kubernetesClient = new DefaultKubernetesClient((Config)config);
        OpenShiftClient client = (OpenShiftClient)kubernetesClient.adapt(OpenShiftClient.class);
        List list = (List)client.load(TemplateExample.class.getResourceAsStream("/test-template.yml")).get();
        System.out.println("Found in file:" + list.size() + " items.");
        for (HasMetadata meta : list) {
            System.out.println(meta.getKind() + ":" + meta.getMetadata().getName());
        }
        list = (List)((Gettable)client.load(TemplateExample.class.getResourceAsStream("/test-template.yml")).fromServer()).get();
        System.out.println("Found on server:" + list.size() + " items.");
        for (HasMetadata meta : list) {
            System.out.println(meta.getKind() + ":" + meta.getMetadata().getName());
        }
        list = (List)client.load(TemplateExample.class.getResourceAsStream("/test-template.yml")).apply();
        System.out.println("Applied:" + list.size() + " items.");
        for (HasMetadata meta : list) {
            System.out.println(meta.getKind() + ":" + meta.getMetadata().getName());
        }
        Boolean result = (Boolean)client.load(TemplateExample.class.getResourceAsStream("/test-template.yml")).delete();
        System.out.println("Deleted:" + result);
    }
}

